package com.biz.eisp.mdm.org.transform;

import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import com.google.common.base.Function;

/**
 * 组织实体转vo
 * @author wan
 * @version v1.0
 */
public class TmOrgEntityToTmOrgVo implements Function<TmOrgEntity, TmOrgVo>{
	public TmOrgEntityToTmOrgVo(TmOrgService tmOrgService){
		super();
		this.tmOrgService = tmOrgService;
	}
	private TmOrgService tmOrgService;
	@Override
	public TmOrgVo apply(TmOrgEntity e) {
		
		TmOrgVo v = new TmOrgVo();
		try {
			e = tmOrgService.get(TmOrgEntity.class, e.getId());
			MyBeanUtils.copyBeanNotNull2Bean(e,v);
			if(StringUtil.isNotEmpty(e.getTmOrg())){
				v.setPid(e.getTmOrg().getId());
				v.setParentId(e.getTmOrg().getId());
			}
		} catch (Exception e2) {
			e2.printStackTrace();
		}
		return v;
	}

}
