package com.biz.eisp.mdm.org.transform;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import com.google.common.base.Function;

/** vo转换po.
 * @author grover
 * @version v1.0
 */
public class TmOrgVoTransFormPo implements Function<TmOrgVo, TmOrgEntity> {
	/**
	 * 注入service
	 */
	private TmOrgService tmOrgService = (TmOrgService) ApplicationContextUtils.getContext().getBean("tmOrgService");

	@Override
	public TmOrgEntity apply(TmOrgVo arg0) {
		TmOrgEntity tmOrgEntity = new TmOrgEntity();
		if(StringUtil.isNotEmpty(arg0.getId())){
			tmOrgEntity = tmOrgService.get(TmOrgEntity.class, arg0.getId());
		}
		
		//验证非空
		if(StringUtil.isEmpty(arg0.getOrgName())){
			throw new BusinessException("组织名称不能为空");
		}	
		
		//验证非空
		if(StringUtil.isEmpty(arg0.getOrgCode())){
			throw new BusinessException("组织编码不能为空");
		}	
		try {
//			//手动验证组织名称
//			String hql="from TmOrgEntity where enableStatus=0 and  orgName=?";
//			//验证重复
//			List count1 =  tmOrgService.findByHql(hql, arg0.getOrgName());
//			if(count1 != null&&count1.size()>0){
//				throw new BusinessException("组织名称["+arg0.getOrgName()+"]已存在");
//			}
//			
//			//手动验证组织编码
//			String hql1="from TmOrgEntity where enableStatus=0 and  orgCode=?";
//			//验证重复
//			List count2 =  tmOrgService.findByHql(hql1, arg0.getOrgCode());
//			if(count2 != null&&count2.size()>0){
//				throw new BusinessException("组织编码["+arg0.getOrgCode()+"]已存在");
//			}
//			
//			MyBeanUtils.copyBeanNotNull2Bean(arg0, tmOrgEntity);
			copyProperties(arg0, tmOrgEntity);
			if(arg0.getEnableStatus() == null){
				tmOrgEntity.setEnableStatus(Globals.ZERO);
			}
			if(arg0.getStatus() == null){
				tmOrgEntity.setStatus(Globals.ZERO);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(StringUtil.isNotEmpty(arg0.getParentId())){
			TmOrgEntity orgEntity =tmOrgService.get(TmOrgEntity.class, arg0.getParentId());
			if(orgEntity==null){
				throw new BusinessException("转换组织关系Vo到Po时，上级组织找不到:" +arg0.getParentId());
			}
			tmOrgEntity.setTmOrg(orgEntity);
		}
		
//		if(StringUtil.isEmpty(arg0.getSubCode())){
//			String parentId = arg0.getParentId();
//			String subCode = tmOrgService.generateTreeSubCode(2, "Tm_org", parentId);
//			arg0.setSubCode(subCode);
//		}
		
		if(StringUtil.isNotEmpty(arg0.getPid())){
			TmOrgEntity orgEntity =tmOrgService.get(TmOrgEntity.class, arg0.getPid());
			if(orgEntity==null){
				throw new BusinessException("转换组织关系Vo到Po时，上级组织找不到:" +arg0.getPid());
			}
			tmOrgEntity.setTmOrg(orgEntity);
		}
		//名称非空与重复验证
		if(StringUtil.isNotEmpty(arg0.getOrgName())){
			if(tmOrgService.validate(arg0.getId(), arg0.getOrgName() , "orgName")){
				throw new BusinessException("组织名称"+arg0.getOrgName()+"已存在" );
			}
		}else{
			throw new BusinessException("组织名称不能为空" );
		}
		
		
		//编码非空与重复验证
		if(StringUtil.isNotEmpty(arg0.getOrgCode())){
			if(tmOrgService.validate(arg0.getId(), arg0.getOrgCode() , "orgCode")){
				throw new BusinessException("组织编码"+ arg0.getOrgCode()+"已存在" );
			}
		}else{
			throw new BusinessException("组织编码不能为空" );
		}
		return tmOrgEntity;
	}
	
	private void copyProperties(TmOrgVo vo, TmOrgEntity entity) {
		entity.setEnableStatus(vo.getEnableStatus());
		entity.setExtChar1(vo.getExtChar1());
		entity.setExtChar2(vo.getExtChar2());
		entity.setExtChar3(vo.getExtChar3());
		entity.setExtChar4(vo.getExtChar4());
		entity.setExtChar5(vo.getExtChar5());
		entity.setExtDate1(vo.getExtDate1());
		entity.setExtDate2(vo.getExtDate2());
		entity.setExtNumber1(vo.getExtNumber1());
		entity.setExtNumber2(vo.getExtNumber2());
		entity.setExtNumber3(vo.getExtNumber3());
		entity.setHeadString(vo.getHeadString());
		entity.setOrgCode(vo.getOrgCode());
		entity.setOrgDesc(vo.getOrgDesc());
		entity.setOrgName(vo.getOrgName());
		entity.setOrgType(vo.getOrgType());
		entity.setStatus(vo.getStatus());
		entity.setSubCode(vo.getSubCode());
	}
}
