package com.biz.eisp.mdm.org.util;

import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.util.oConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 * ${DESCRIPTION}
 *
 * @author xuduan
 * @create 2018-05-29 下午3:14
 */
public class TmOrgTreeUtil {

    /**
     * 使用递归方法建树
     * @return
     */
    public static List<ComboTree> buildTree(List<ComboTree> treeNodes) {
        List<ComboTree> trees = new ArrayList<ComboTree>();
        for (ComboTree treeNode : treeNodes) {
            if (StringUtils.isBlank(treeNode.getPid())) {

                trees.add(findChildren(treeNode,treeNodes));
            }
        }
        return trees;
    }


    /**
     * 递归查找子节点
     * @param treeNodes
     * @return
     */
    public static ComboTree findChildren(ComboTree treeNode,List<ComboTree> treeNodes) {
        boolean b=false;
        for (ComboTree it : treeNodes) {
            if(StringUtils.isNotBlank(it.getPid())&&treeNode.getId().equals(it.getPid())) {

                if (treeNode.getChildren() == null) {
                    treeNode.setChildren(new ArrayList<ComboTree>());
                }
                ComboTree ctree=findChildren(it,treeNodes);
                treeNode.setState("closed"); //子节点关闭
                treeNode.getChildren().add(ctree);
            }
        }
        return treeNode;
    }
}
