package com.biz.eisp.mdm.position.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import com.biz.eisp.mdm.position.service.PositionService;
import com.biz.eisp.mdm.position.service.TmPositionFormExtendService;
import com.biz.eisp.mdm.position.service.TmPositionMainExtendService;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.web.pojo.Client;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** 
 * <p>职位CURD操作的Controller层<br>
 * 处理职位Controller
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/tmPositionController")
public class TmPositionController extends BaseController{
	/**
	 * 注入职位Service
	 */
	@Autowired
	private TmPositionService tmPositionService;

	@Autowired(required=false)
	private TmPositionFormExtendService tmPositionFormExtendService;

	@Autowired(required=false)
	private TmPositionMainExtendService tmPositionMainExtendService;
	@Autowired
	private PositionService positionService;
	/**
	 * <p>跳转到职位管理主页面<br>
	 * @return 职位管理页面路径
	 */
	@RequestMapping(value = "goTmPositionMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmPositionMain(TmPositionVo tmPositionVo, HttpServletRequest request) {
		if(StringUtil.isNotEmpty(tmPositionVo.getOrgId())){
			request.setAttribute("orgId", tmPositionVo.getOrgId());
		}
		request.setAttribute("extendTableName",Globals.TABLE_POSITION);

		if(tmPositionMainExtendService!=null){
			request.setAttribute("includeJSP", tmPositionMainExtendService.includeJsp());
		}

		return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionMain");
	}
	/**
	 * 跳转到职位业务标签管理主页面.
	 * @author grover
	 * @param tmPositionVo 职位vo
	 * @param singleSelect 是否单选
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping("goTmPositionSearch")
	public ModelAndView goTmPositionSearch(TmPositionVo tmPositionVo,String singleSelect,String searchUrl, HttpServletRequest request) {
		ModelAndView view = new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionSearchMain");
		if(StringUtil.isNotEmpty(tmPositionVo.getOrgId())){
			view.addObject("orgId", tmPositionVo.getOrgId());
		}
		if(StringUtil.isEmpty(searchUrl)){
			searchUrl="tmPositionController/findTmPositionBySearchList";
		}
		view.addObject("searchUrl",searchUrl);
		view.addObject("extendTableName",Globals.TABLE_POSITION);
		view.addObject("vo",tmPositionVo);
		view.addObject("singleSelect", singleSelect);
		return view;
	}
	
	/**
	 * <p>跳转到职位表单页面<br>
	 * 新增，查询，修改 都共同使用此表单页面
	 * @return 职位表单页面路径
	 */
	@RequestMapping(value = "goTmPositionForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmPositionForm(TmPositionVo tmPositionVo,
				HttpServletRequest request, HttpServletResponse response) {
		//职位信息
		if(StringUtil.isNotEmpty(tmPositionVo.getId())){
			List <TmPositionVo> tmPositionVoList = tmPositionService.
					findTmPositionList(tmPositionVo, null);
			if(tmPositionVoList!=null&&tmPositionVoList.size()>0){
				TmPositionVo vo = tmPositionVoList.get(0);
				request.setAttribute("vo", vo);
			}
		}
	
		//表单类型0新增1编辑2查看
		String optype=request.getParameter("optype");
		request.setAttribute("optype", optype);
		
		//动态表单参数 表名
		request.setAttribute("extendTableName",Globals.TABLE_POSITION);

		if(tmPositionFormExtendService!=null){
			request.setAttribute("includeJSP", tmPositionFormExtendService.includeJsp());
		}

		return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionForm");
	}
	/**
	 * 跳转选择权限角色
	 * <p>跳转权限角色列表页面<br>
	 * @param tmPositionVo 职位vo
	 * @param request 请求对象
	 * @return 权限角色页面
	 */
	@RequestMapping(value = "goSelectRole", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goSelectRole(TmPositionVo tmPositionVo, HttpServletRequest request) {
		if(StringUtil.isNotEmpty(tmPositionVo.getId())){
			request.setAttribute("posId", tmPositionVo.getId());
		}
		if(StringUtil.isNotEmpty(tmPositionVo.getUserId())){
			request.setAttribute("userId", tmPositionVo.getUserId());
		}
		return new ModelAndView("com/biz/eisp/mdm/role/tmRoleSelectMain");
	}
	
	/**
	 * 查询职位Vo对象列表，以Json的格式方法。
	 * <p>
	 * @param tmPositionVo 职位Vo对象
	 * @param request request对象
	 * @param response response对象
	 * @return datagrid数据
	 */
	@RequestMapping(value = "findTmPositionList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmPositionList(TmPositionVo tmPositionVo,
				HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		
		List <TmPositionVo> tmPositionVoList = tmPositionService.
					findTmPositionList(tmPositionVo, page);
		
		return new DataGrid(tmPositionVoList, page);
	}

	/**
	 * 查询未关联任何角色的职位。
	 * <p>
	 * @param tmPositionVo 职位Vo对象
	 * @param request request对象
	 * @param response response对象
	 * @return datagrid数据
	 */
	@RequestMapping(value = "findNoAnyRolePositionList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findNoAnyRolePositionList(TmPositionVo tmPositionVo,
									   HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);

		List <TmPositionVo> tmPositionVoList = tmPositionService.
				findNoAnyRolePositionList(tmPositionVo, page);

		return new DataGrid(tmPositionVoList, page);
	}

	/**
	 * 查询未关联该角色的职位。
	 * <p>
	 * @param tmPositionVo 职位Vo对象
	 * @param request request对象
	 * @param response response对象
	 * @return datagrid数据
	 */
	@RequestMapping(value = "findNoThisRolePositionList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findNoThisRolePositionList(TmPositionVo tmPositionVo,
											  HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);

		List <TmPositionVo> tmPositionVoList = tmPositionService.
				findNoThisRolePositionList(tmPositionVo, page);

		return new DataGrid(tmPositionVoList, page);
	}

	/**
	 * 查询已关联该角色的职位。
	 * <p>
	 * @param tmPositionVo 职位Vo对象
	 * @param request request对象
	 * @param response response对象
	 * @return datagrid数据
	 */
	@RequestMapping(value = "findThisRolePositionList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findThisRolePositionList(TmPositionVo tmPositionVo,
											   HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);

		List <TmPositionVo> tmPositionVoList = tmPositionService.
				findThisRolePositionList(tmPositionVo, page);

		return new DataGrid(tmPositionVoList, page);
	}

	/**
	 * 职位业务标签查询.
	 * @author grover
	 * @param tmPositionVo 职位vo
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping(value = "findTmPositionBySearchList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmPositionBySearchList(TmPositionVo tmPositionVo, HttpServletRequest request) {
		Page page = new EuPage(request);
		if(StringUtil.isNotEmpty(tmPositionVo.getSearchParam())){
			tmPositionVo.setPositionName(tmPositionVo.getSearchParam());
		}
		List <TmPositionVo> tmPositionVoList;
		try {
			tmPositionVoList = tmPositionService.findTmPositionList(
					tmPositionVo, page);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("获取职位信息异常,"+e.getMessage());
		}
		
		return new DataGrid(tmPositionVoList, page);
	}
	/**
	 * 职位业务标签查询.
	 * @author grover
	 * @param tmPositionVo 职位vo
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping(value = "getTmPositionBySearchList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson getTmPositionBySearchList(TmPositionVo tmPositionVo, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		Map<String, Object> map = new HashMap<String, Object>();
		Page page = new EuPage(request);
		try {
			if (StringUtil.isNotEmpty(tmPositionVo.getSearchParam())) {
				tmPositionVo.setPositionName(tmPositionVo.getSearchParam());
			}
			
			List<TmPositionVo> tmPositionVoList = tmPositionService
					.findTmPositionList(tmPositionVo, page);
			map.put("totle", tmPositionVoList.size());
			j.setObj(tmPositionVoList);
		} catch (Exception e) {
			j.setSuccess(false);
			map.put("totle", 0);
			e.printStackTrace();
		}
		j.setAttributes(map);
		return j;
	}
	
	/**
	 * 保存职位VO信息
	 * <p>保存职位业务信息<br>
	 * @param tmPositionVo 职位Vo对象
	 * @param request request对象
	 * @param response response对象
	 * @return
	 */
	@RequestMapping(value = "saveTmPosition", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveTmPosition(TmPositionVo tmPositionVo, HttpServletRequest request, HttpServletResponse response) {
		AjaxJson j = new AjaxJson();
		try {
			j.setMsg("操作成功");
			Page page = new EuPage(request);
			tmPositionService.saveTmPosition(tmPositionVo, page);
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("操作职位失败,请稍后再试");
			e.printStackTrace();
		}
		return j;
	}
	/**
	 * 删除职位信息
	 * <p>
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "deleteTmPosition", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteTmPosition(String ids, 
			HttpServletRequest request, HttpServletResponse response) {
		AjaxJson ajaxJson=new AjaxJson();
		try {
			tmPositionService.deleteTmPosition(ids, page);
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setMsg("删除失败,"+e.getMessage());
		}
		return ajaxJson;
	}
	/**
	 * 启用停用
	 * @param tmPositionVo 职位vo对象
	 */
	@RequestMapping(value = "startOrStopPosition", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson startOrStopPosition(TmPositionVo tmPositionVo) {
		AjaxJson j = new AjaxJson();
		try {
			j = tmPositionService.startOrStopPosition(tmPositionVo);
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("操作失败");
			e.printStackTrace();
		}
		return j;
	}
	/**
	 * 跳转职位列表.
	 * @author grover
	 * @param tmPositionVo 职位vo对象
	 * @param request 请求对象
	 * @return 职位页面
	 */
	@RequestMapping(value = "goTmPositionByOrgMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmPositionByOrgMain(TmPositionVo tmPositionVo,HttpServletRequest request) {
		if(StringUtil.isNotEmpty(tmPositionVo.getOrgId())){
			request.setAttribute("orgId", tmPositionVo.getOrgId());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionByOrgMain");
	}
	/**
	 * 跳转上级职位页面.
	 * @author grover
	 * @param tmPositionVo 职位vo对象
	 * @param request 请求对象
	 * @return 上级职位页面
	 */
	@RequestMapping(value = "goParentTmpositionMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goParentTmpositionMain(TmPositionVo tmPositionVo,HttpServletRequest request) {
		if(StringUtil.isNotEmpty(tmPositionVo.getId())){
			request.setAttribute("id", tmPositionVo.getId());
		}
		if(StringUtil.isNotEmpty(tmPositionVo.getOrgId())){
			request.setAttribute("curentOrg", tmPositionVo.getOrgId());
		}else{
		 	TmUserVo tmUserVo = ResourceConfigUtils.getSessionTmUserVo();
			//设置当前
		 	if(StringUtil.isNotEmpty(tmUserVo)){
		 		request.setAttribute("curentOrg", tmUserVo.getOrgId());
		 	}
		}
		return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionSelectMain");
	}
	/**
	 * 跳转用户选择职位页面.
	 * @author grover
	 * @param request 请求对象
	 * @return 职位页面
	 */
	@RequestMapping(value = "goTmPositionForUserMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmPositionForUserMain(HttpServletRequest request) {
		String userId = OConvertUtils.getString(request.getParameter("userId"));
		if(StringUtil.isNotEmpty(userId)){
			request.setAttribute("userId", userId);
		}
		return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionForUserMain");
	}
	/**
	 * 跳转已经选择的职位页面.
	 * @author grover
	 * @param tmPositionVo 职位vo对象
	 * @param request 请求对象
	 * @return 职位页面
	 */
	@RequestMapping(value = "goTmPositionCheckedMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmPositionCheckedMain(TmPositionVo tmPositionVo, HttpServletRequest request) {
		request.setAttribute("userId", StringUtil.isNotEmpty(tmPositionVo.getUserId())?tmPositionVo.getUserId():"-1");
		return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionCheckedMain");
	}
	/**
	 * 用户选择职位.
	 * @author grover
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "findTmPositionForUserList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmPositionForUserList(TmPositionVo tmPositionVo,
			HttpServletRequest request, HttpServletResponse response) {
		tmPositionVo.setFlag("true");
		tmPositionVo.setEnableStatus(Globals.ZERO);
		Page page = new EuPage(request);
		List <TmPositionVo> tmPositionVoList = tmPositionService.
					findTmPositionList(tmPositionVo, page);
		return new DataGrid(tmPositionVoList, page);
	}
	
	
	/**
	 * 验证重复.
	 * @author grover
	 * @param tmPositionVo 职位vo对象
	 * @param request 请求对象
	 * @return 验证信息
	 */
	@RequestMapping(value = "validateTmposition")
	@ResponseBody
	public ValidForm validateTmposition(TmPositionVo tmPositionVo,HttpServletRequest request) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		try {
			validForm = tmPositionService.validateTmposition(tmPositionVo, param);
		} catch (Exception e) {
			validForm.setStatus("n");
			validForm.setInfo("验证出现异常");
			e.printStackTrace();
		}
		return validForm;
	}
	
	/**
	 * 菜单树型下拉列表
	 * @param request 请求对象
	 * @param comboTree 树型下拉列表对象
	 * @return 树型下拉列表集合
	 */
	@RequestMapping(value = "getPositionTree", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public List<ComboTree> getPositionTree(HttpServletRequest request,
			ComboTree comboTree) {
		return tmPositionService.getPositionForComboTree(request, comboTree);
	}
	
	/**
	 * 调整职位与组织的关系.
	 * @param request 请求对象
	 * @param tmOrgVo 组织vo对象
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "changePositionForOrg", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson changePositionForOrg(HttpServletRequest request,TmOrgVo tmOrgVo) {
		AjaxJson j = new AjaxJson();
		try {
			j = tmPositionService.changePositionForOrg(tmOrgVo);
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("调整关系失败,请稍后再试");
			e.printStackTrace();
		}
		return j;
	}
	/**
	 * 跳转角色相关职位.
	 * <p>跳转角色相关职位的主页面
	 * @param tmPositionVo 职位vo对象
	 * @param request 请求对象
	 * @return 职位管理页面路径
	 */
	@RequestMapping(value = "goTmPositionByRoleMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmPositionByRoleMain(TmPositionVo tmPositionVo, HttpServletRequest request) {
		if(StringUtil.isNotEmpty(tmPositionVo.getRoleIds())){
			request.setAttribute("roleId", tmPositionVo.getRoleIds());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionByRoleMain");
	}
	/**
	 * 跳转角色-职位关系维护.
	 * <p>跳转角色-职位关系维护的主页面
	 * @param tmPositionVo 职位vo对象
	 * @param request 请求对象
	 * @return 角色-职位关系维护路径
	 */
	@RequestMapping(value = "goTmMaintainPositionByRoleMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmMaintainPositionByRoleMain(TmPositionVo tmPositionVo, HttpServletRequest request) {
		if(StringUtil.isNotEmpty(tmPositionVo.getRoleIds())){
			request.setAttribute("roleId", tmPositionVo.getRoleIds());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmMaintainPositionByRoleMain");
	}
	/**
	 * 跳转切换职位.
	 * <p>跳转切换职位的主页面
	 * @param request 请求对象
	 * @return 切换页面路径
	 */
	@RequestMapping(value = "goChangeTmPosition", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goChangeTmPosition(HttpServletRequest request) {
		TmPositionVo tmPositionVo = new TmPositionVo();
		//获取登录人信息
		TmUserEntity userEntity = ResourceConfigUtils.getSessionUserName();
		Page page = new EuPage(request);
		if(StringUtil.isNotEmpty(userEntity)){
			tmPositionVo.setUserId(userEntity.getId());
			tmPositionVo.setEnableStatus(Globals.ZERO);
			List<TmPositionVo> list = tmPositionService.findTmPositionList(tmPositionVo, page);
			request.setAttribute("tmPositionVo", list);
			request.setAttribute("userId", userEntity.getId());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmPosition/changeTmPositionMain");
	}
	/**
	 * 切换主职位.
	 * @param request 请求对象
	 * @param tmPositionVo 职位vo对象
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "changeTmPosition",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public AjaxJson changeTmPosition(TmPositionVo tmPositionVo,HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		try {
			tmPositionService.changeTmPosition(tmPositionVo);
			Client client= ResourceConfigUtils.getClient();
			changeSession(client,tmPositionVo.getId());
		} catch (Exception e) {
			j.setMsg("切换职位失败，请稍后再试");
			j.setSuccess(false);
			e.printStackTrace();
		}
		return j;
	}
	private void changeSession(Client client,String posId){
		TmPositionVo positionVo = positionService.getPositinById(posId);
		client.setPosition(positionVo);
		TmOrgEntity orgEntity = tmPositionService.get(TmOrgEntity.class, positionVo.getOrgId());
		client.setOrg(getTmOrgEntity(orgEntity));
		//实例管理对象
		ResourceConfigUtils.setClient(client);
	}
	private TmOrgEntity getTmOrgEntity(TmOrgEntity org){
		TmOrgEntity result=new TmOrgEntity();
		result.setId(org.getId());
		result.setOrgName(org.getOrgName());
		result.setOrgDesc(org.getOrgDesc());
		result.setOrgCode(org.getOrgCode());
		result.setOrgType(org.getOrgType());
		result.setHeadString(org.getHeadString());
		result.setSubCode(org.getSubCode());
		result.setEnableStatus(org.getEnableStatus());
		result.setCreateDate(org.getCreateDate());
		result.setCreateName(org.getCreateName());
		result.setUpdateDate(org.getUpdateDate());
		result.setUpdateName(org.getUpdateName());
		result.setStatus(org.getStatus());
		result.setExtChar1(org.getExtChar1());
		result.setExtChar2(org.getExtChar2());
		result.setExtChar3(org.getExtChar3());
		result.setExtChar4(org.getExtChar4());
		result.setExtChar5(org.getExtChar5());
		result.setExtNumber1(org.getExtNumber1());
		result.setExtNumber2(org.getExtNumber2());
		result.setExtNumber3(org.getExtNumber3());
		result.setExtDate1(org.getExtDate1());
		result.setExtDate2(org.getExtDate2());
		result.setIsLeaf(org.getIsLeaf());
		return  result;
	}
	/**
	 * <p>跳转到日志管理主页面<br>
	 * @author wuzhujun
	 * @return 日志管理主界面
	 */
	@RequestMapping(value = "goTmLogDetailMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmLogDetailMain( HttpServletRequest request) {
		String businessId=request.getParameter("id");
		request.setAttribute("actionUrl", "tmPositionController/findTmLogList?businessId="+businessId);
		return new ModelAndView("com/biz/eisp/log/tmLogDetailMain");
	}
	
	/**
	 * 分页获取日志列表信息
	 * @author wuzhujun
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "findTmLogList",method = {RequestMethod.GET,RequestMethod.POST})
	public void findTmLogList(TmLogVo tmLogVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		List <TmLogVo> tmLogList = tmPositionService.findPositionLogList(tmLogVo, page);
		this.datagridReturn(response, tmLogList, page);
	}
	
	/**
	 * 职位列表excel导出
	 * @author wuzhujun
	 * @param tmPositionVo 职位vo
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "exportXls", method = {RequestMethod.GET, RequestMethod.POST})
	public void exportXls(TmPositionVo tmPositionVo, HttpServletRequest request, HttpServletResponse response) {
		List <TmPositionVo> tmPositionVoList = tmPositionService.
				findTmPositionList(tmPositionVo, null);
		doExportXls(response, request, tmPositionVoList, TmPositionVo.class, "职位列表");
	}
	
	/**
	 * 跳转职位列表.
	 * @author grover
	 * @param tmPositionVo 职位vo对象
	 * @param request 请求对象
	 * @return 职位页面
	 */
	@RequestMapping(value = "goTmPositionByOrgSelectMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTmPositionByOrgSelectMain(TmPositionVo tmPositionVo,HttpServletRequest request) {
		if(StringUtil.isNotEmpty(tmPositionVo.getOrgId())){
			request.setAttribute("orgId", tmPositionVo.getOrgId());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionByOrgSelectMain");
	}
	
	/**
	 * 查询组织职位Vo对象列表，以Json的格式方法。
	 * <p>
	 * @param tmPositionVo 职位Vo对象
	 * @param request request对象
	 * @param response response对象
	 * @return datagrid数据
	 */
	@RequestMapping(value = "findTmPositionByOrgSelectList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmPositionByOrgSelectList(TmPositionVo tmPositionVo,
				HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		
		List <TmPositionVo> tmPositionVoList = tmPositionService.
					findTmPositionByOrgSelectList(tmPositionVo, page);
		
		return new DataGrid(tmPositionVoList, page);
	}
	
	/**
	 * 调整到职位查询选择弹出框.
	 * <p>
	 * @param tmPositionVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "goTmPositionQuerySelectMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmPositionSelectMain(TmPositionVo tmPositionVo,HttpServletRequest request) {
		return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionQuerySelectMain");
	}
	
	/**
	 * 查询组织职位Vo对象列表，以Json的格式方法。
	 * <p>
	 * @param tmPositionVo 职位Vo对象
	 * @param request request对象
	 * @param response response对象
	 * @return datagrid数据
	 */
	@RequestMapping(value = "findTmPositionQuerySelectList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmPositionQuerySelectList(TmPositionVo tmPositionVo,
				HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		
		List <TmPositionVo> tmPositionVoList = tmPositionService.
				findTmPositionQuerySelectList(tmPositionVo, page);
		
		return new DataGrid(tmPositionVoList, page);
	}

	/**
	 * 添加职位与角色关联.
	 * @param request 请求对象
	 * @param roleId 角色ID
	 * @param positionIds 职位ID 逗号分隔
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "addPositionRoleRelation", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson addPositionRoleRelation(String roleId, String positionIds, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		try {
			tmPositionService.addPositionRoleRelation(positionIds, roleId);
		} catch (Exception e) {
			j.setMsg("添加职位与角色关联失败，请稍后再试");
			j.setSuccess(false);
			e.printStackTrace();
		}
		return j;
	}

	/**
	 * 移除职位与角色关联.
	 * @param request 请求对象
	 * @param relationIds 角色与职位关系Id 逗号分隔
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "deletePositionRoleRelation", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deletePositionRoleRelation(String relationIds, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		try {
			tmPositionService.deletePositionRoleRelation(relationIds);
		} catch (Exception e) {
			j.setMsg("移除职位与角色关联失败，请稍后再试");
			j.setSuccess(false);
			e.printStackTrace();
		}
		return j;
	}

	/**
	 * 替换职位与角色关联.
	 * @param request 请求对象
	 * @param relationIds 角色与职位关系Id 逗号分隔
	 * @param roleId 角色ID
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "updatePositionRoleRelation", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson updatePositionRoleRelation(String relationIds, String roleId,HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		try {
			tmPositionService.updatePositionRoleRelation(relationIds, roleId);
		} catch (Exception e) {
			j.setMsg("替换职位与角色关联失败，请稍后再试");
			j.setSuccess(false);
			e.printStackTrace();
		}
		return j;
	}
}
