package com.biz.eisp.mdm.position.dao;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.actrole.entity.TmActRoleEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.QueryTmpositionVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;

import java.util.List;

/** 职位管理业务Dao接口
 * <p>职位管理Dao，涉及表：tm_position，主要围绕表tm_position进行操作。会涉及tm_position关联表：tm_org,tm_user,tm_mdm_table_config<br>
 * @author liukai
 * @version v1.0
 */
@InterfaceDao
public interface TmPositionDao {
	
	/**
	 * 查询职位Vo列表信息.
	 * <p>查询职位Vo列表，涉及表：tm_position(主表),tm_org(关联表)<br>
	 * @param tmPositionVo 职位Vo对象，接收查询参数
	 * @param page 页面对象
	 * @return 职位Vo对象列表
	 */
	@Arguments({"tmPositionVo","page","sql"})
	@ResultType(TmPositionVo.class)
	public List <TmPositionVo> findTmPositionList(TmPositionVo tmPositionVo, Page page,String sql);
	
	/**
	 * 查询组织下的职位信息.
	 * <p>
	 * @param tmPositionVo
	 * @param page 
	 * @return
	 */
	@Arguments({"tmPositionVo","page"})
	@ResultType(TmPositionVo.class)
	public List <TmPositionVo> findTmPositionByOrgSelectList(TmPositionVo tmPositionVo, Page page);
	
	/**
	 * 查询的职位信息.
	 * <p>
	 * @param tmPositionVo
	 * @param page 
	 * @return
	 */
	@Arguments({"tmPositionVo","page"})
	@ResultType(TmPositionVo.class)
	public List <TmPositionVo> findTmPositionQuerySelectList(TmPositionVo tmPositionVo, Page page);
	
	/**
	 * 查询职位拥有权限角色.
	 * @param tmPositionVo 职位Vo对象，接收查询参数
	 * @return 角色对象
	 */
	@Arguments({"tmPositionVo"})
	@ResultType(TmRoleEntity.class)
	public List <TmRoleEntity> findTmRoleByPosition(TmPositionVo tmPositionVo);
	/**
	 * 查询职位拥有工作流角色.
	 * @param tmPositionVo 职位Vo对象，接收查询参数
	 * @return 角色对象
	 */
	@Arguments({"tmPositionVo"})
	@ResultType(TmActRoleEntity.class)
	public List <TmActRoleEntity> findTmActRoleByPosition(TmPositionVo tmPositionVo);
	/**
	 * 获取用户其他信息.
	 * <p>比如：职位，权限角色，工作流角色等
	 * @author grover
	 * @param tmPositionVo 职位vo
	 * @return 用户其他信息
	 */
	@Arguments({"tmPositionVo"})
	@ResultType(TmPositionVo.class)
	public List <TmPositionVo> findOtherTmUserInfo(TmPositionVo tmPositionVo);
	/**
	 * 获取所有可能查询职位的方式.
	 * @author grover
	 * @param queryTmpositionVo 查询职位vo
	 * @return 职位vo信息
	 */
	@Arguments({"queryTmpositionVo","page"})
	@ResultType(TmPositionVo.class)
	public List <TmPositionVo> findTmPositionByAllPossible(QueryTmpositionVo queryTmpositionVo, Page page);
	/**
	 * 查询职位，根据职位名称，职位code模糊查询
	 * @author wan
	 * @param vo
	 * @param page
	 * @return
	 */
	@Arguments({"vo","page"})
	@ResultType(TmPositionVo.class)
	public List<TmPositionVo> findTmPositionByCondition(TmPositionVo vo,Page page);
	
	/**
	 * 查看客户用户日志
	 * @param tmLogVo
	 * @param page
	 * @return
	 */
	@Arguments({"tmLogVo","page"})
	@ResultType(TmLogVo.class)
	public List<TmLogVo> findPositionLogList(TmLogVo tmLogVo, Page page);

	/**
	 * 查询未关联任何角色的职位.
	 * <p>职位VO对象信息，涉及数据库表：tm_position（主表）,tm_org（关联表）<br>
	 * @param vo 职位VO对象，接收参数使用
	 * @param page 页面对象
	 * @return 职位VO对象列表
	 */
	@Arguments({"vo","page"})
	@ResultType(TmPositionVo.class)
	public List <TmPositionVo> findNoAnyRolePositionList(TmPositionVo vo, Page page);

	/**
	 * 查询未关联该角色的职位.
	 * <p>职位VO对象信息，涉及数据库表：tm_position（主表）,tm_org（关联表）<br>
	 * @param vo 职位VO对象，接收参数使用
	 * @param page 页面对象
	 * @return 职位VO对象列表
	 */
	@Arguments({"vo","page"})
	@ResultType(TmPositionVo.class)
	public List <TmPositionVo> findNoThisRolePositionList(TmPositionVo vo, Page page);

	/**
	 * 查询已关联该角色的职位.
	 * <p>职位VO对象信息，涉及数据库表：tm_position（主表）,tm_org（关联表）<br>
	 * @param vo 职位VO对象，接收参数使用
	 * @param page 页面对象
	 * @return 职位VO对象列表
	 */
	@Arguments({"vo","page"})
	@ResultType(TmPositionVo.class)
	public List <TmPositionVo> findThisRolePositionList(TmPositionVo vo, Page page);


	/**
	 * 查询职位，根据职位名称，职位code模糊查询 如果有组织查询组织及组织下级
	 * @author wan
	 * @param vo
	 * @param page
	 * @return
	 */
	@Arguments({"vo","page"})
	@ResultType(TmPositionVo.class)
	public List<TmPositionVo> findTmPositionParentByCondition(TmPositionVo vo,Page page);

	/**
	 * 删除 职位
	 * @param vo
	 */
	@Arguments({"vo"})
	public void deleteTmPositionById(TmPositionEntity vo);

}
