package com.biz.eisp.mdm.position.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Where;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
import com.biz.eisp.mdm.actrole.entity.TmRPositionActRoleEntity;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
/**
 * 职位信息实体.
 * @author grover
 * @version v1.0
 */
@Entity
@Table(name = "tm_position")
public class TmPositionEntity  extends IdEntity implements java.io.Serializable ,Loggerable{
	private static final long serialVersionUID = 1L;
	/**
	 * 创建人
	 */
	private java.lang.String createName;
	/**
	 * 创建日期
	 */
	private java.util.Date createDate;
	/**
	 * 修改日期
	 */
	private java.util.Date updateDate;
	/**
	 * 修改名字
	 */
	private java.lang.String updateName;
	/**
	 * 组织机构
	 */
	private TmOrgEntity tmOrg;
	/**
	 * 上级岗位
	 */
	private TmPositionEntity tmPosition;
	/**
	 * 岗位编码
	 */
	private java.lang.String positionCode;
	/**
	 * 岗位名称
	 */
	private java.lang.String positionName;
	/**
	 * 岗位级别
	 */
	private java.lang.Integer positionLevel;
	/**
	 * 职位状态：0-正常，1-注销
	 */
	private java.lang.Integer enableStatus;
	/**
	 * 业务组，对应数据字典business_group下的值
	 */
	private java.lang.String businessGroup;
	/**
	 * 职位名称拼音简写
	 */
	private java.lang.String headString;
	
	/**
	 * 字符类型（length=100）-扩展字段1
	 */
	private String extChar1;
	/**
	 * 字符类型（length=100）-扩展字段2
	 */
	private String extChar2;
	/**
	 * 字符类型（length=100）-扩展字段3
	 */
	private String extChar3;
	/**
	 * 字符类型（length=100）-扩展字段4
	 */
	private String extChar4;
	/**
	 * 字符类型（length=100）-扩展字段5
	 */
	private String extChar5;
	/**
	 * 数字类型-扩展字段1
	 */
	private Integer extNumber1;
	/**
	 * 数字类型-扩展字段2
	 */
	private Integer extNumber2;
	/**
	 * 数字类型-扩展字段3
	 */
	private Integer extNumber3;
	/**
	 * 日期类型-扩展字段1
	 */
	private Date extDate1;
	/**
	 * 日期类型-扩展字段2
	 */
	private Date extDate2;
	
	
	/*****************************一对多************************************/
	/**
	 * 下级职位
	 */
	private List<TmPositionEntity> tmPositionList = new ArrayList<TmPositionEntity>();
	/**
	 * 职位与权限角色关系列表
	 */
	private List <TmRPositionRoleEntity> tmPositionRoleList = new ArrayList<TmRPositionRoleEntity>();
	/**
	 * 职位与工作流角色关系列表
	 */
	private List <TmRPositionActRoleEntity> tmRPositionActRoleList = new ArrayList<TmRPositionActRoleEntity>();
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  创建人登录名称
	 */
	@Column(name ="create_name",nullable=false)
	public java.lang.String getCreateName(){
		return this.createName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  创建人登录名称
	 */
	public void setCreateName(java.lang.String createName){
		this.createName = createName;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  创建日期
	 */
	@Column(name ="create_date",nullable=false,length=20)
	public java.util.Date getCreateDate(){
		return this.createDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  创建日期
	 */
	public void setCreateDate(java.util.Date createDate){
		this.createDate = createDate;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.position.entity.TmPositionEntity
	 *@return: com.biz.eisp.mdm.position.entity.TmPositionEntity  上级岗位
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name ="parent_id")
	public TmPositionEntity getTmPosition(){
		return this.tmPosition;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  组织机构
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "org_id")
	public TmOrgEntity getTmOrg() {
		return tmOrg;
	}
	public void setTmOrg(TmOrgEntity tmOrg) {
		this.tmOrg = tmOrg;
	}
	/**
	 *方法: 设置 com.biz.eisp.mdm.position.entity.TmPositionEntity
	 *@param: com.biz.eisp.mdm.position.entity.TmPositionEntity  上级岗位
	 */
	public void setTmPosition(TmPositionEntity tmPosition){
		this.tmPosition = tmPosition;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  岗位编码
	 */
	@Column(name ="position_code",nullable=false)
	public java.lang.String getPositionCode(){
		return this.positionCode;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  岗位编码
	 */
	public void setPositionCode(java.lang.String positionCode){
		this.positionCode = positionCode;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  岗位名称
	 */
	@Column(name ="position_name",nullable=false)
	public java.lang.String getPositionName(){
		return this.positionName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  岗位名称
	 */
	public void setPositionName(java.lang.String positionName){
		this.positionName = positionName;
	}
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  岗位级别
	 */
	@Column(name ="position_level",nullable=false,length=50)
	public java.lang.Integer getPositionLevel(){
		return this.positionLevel;
	}
	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer  岗位级别
	 */
	public void setPositionLevel(java.lang.Integer positionLevel){
		this.positionLevel = positionLevel;
	}
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  岗位状态
	 */
	@Column(name ="enable_status",nullable=true)
	public java.lang.Integer getEnableStatus(){
		return this.enableStatus;
	}
	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer  岗位状态
	 */
	public void setEnableStatus(java.lang.Integer enableStatus){
		this.enableStatus = enableStatus;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String 业务组
	 */
	@Column(name = "business_group")
	public java.lang.String getBusinessGroup() {
		return businessGroup;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 业务组
	 */
	public void setBusinessGroup(java.lang.String businessGroup) {
		this.businessGroup = businessGroup;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String 职位名称拼音简写
	 */
	@Column(name = "headstring")
	public java.lang.String getHeadString() {
		return headString;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 职位名称拼音简写
	 */
	public void setHeadString(java.lang.String headString) {
		this.headString = headString;
	}
	/**
	 *方法: 取得 java.util.Date
	 *@return: java.util.Date 修改时间
	 */
	@Column(name = "update_date")
	public java.util.Date getUpdateDate() {
		return updateDate;
	}
	/**
	 *方法: 设置 java.util.Date
	 *@param: java.util.Date 修改时间
	 */
	public void setUpdateDate(java.util.Date updateDate) {
		this.updateDate = updateDate;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 修改人
	 */
	@Column(name = "update_name")
	public java.lang.String getUpdateName() {
		return updateName;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 修改人
	 */
	public void setUpdateName(java.lang.String updateName) {
		this.updateName = updateName;
	}
	/**
	 * 方法:取得java.util.List<com.biz.eisp.mdm.position.entity.TmPositionEntity>
	 * @return java.util.List<com.biz.eisp.mdm.position.entity.TmPositionEntity> 下级职位
	 */
	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "tmPosition")
	@Where(clause="enable_status=0")
	@Fetch(FetchMode.SUBSELECT)
	public List<TmPositionEntity> getTmPositionList() {
		return tmPositionList;
	}
	/**
	 * 方法:设置java.util.List<com.biz.eisp.mdm.position.entity.TmPositionEntity>
	 * @param java.util.List<com.biz.eisp.mdm.position.entity.TmPositionEntity> 下级职位
	 */
	public void setTmPositionList(List<TmPositionEntity> tmPositionList) {
		this.tmPositionList = tmPositionList;
	}
	
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String  字符扩展字段1
	 */
	@Column(name = "ext_char_1")
	public String getExtChar1(){
		return extChar1;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段2
	 */
	@Column(name = "ext_char_2")
	public String getExtChar2(){
		return extChar2;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段3
	 */
	@Column(name = "ext_char_3")
	public String getExtChar3(){
		return extChar3;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段4
	 */
	@Column(name = "ext_char_4")
	public String getExtChar4(){
		return extChar4;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段5
	 */
	@Column(name = "ext_char_5")
	public String getExtChar5(){
		return extChar5;
	}
	/**
	 * 方法:取得java.lang.Integer 
	 * @return java.lang.Integer 数字扩展字段1
	 */
	@Column(name = "ext_number_1")
	public Integer getExtNumber1(){
		return extNumber1;
	}
	/**
	 * 方法:取得java.lang.Integer 
	 * @return java.lang.Integer 数字扩展字段2
	 */
	@Column(name = "ext_number_2")
	public Integer getExtNumber2(){
		return extNumber2;
	}
	/**
	 * 方法:取得java.lang.Integer 
	 * @return java.lang.Integer 数字扩展字段3
	 */
	@Column(name = "ext_number_3")
	public Integer getExtNumber3(){
		return extNumber3;
	}
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 日期扩展字段1
	 */
	@Column(name = "ext_date_1")
	public Date getExtDate1() {
		return extDate1;
	}
	/**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 日期扩展字段1
	 */
	public void setExtDate1(Date extDate1) {
		this.extDate1 = extDate1;
	}
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 日期扩展字段2
	 */
	@Column(name = "ext_date_2")
	public Date getExtDate2() {
		return extDate2;
	}
	/**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 日期扩展字段2
	 */
	public void setExtDate2(Date extDate2) {
		this.extDate2 = extDate2;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段1
	 */
	public void setExtChar1(String extChar1) {
		this.extChar1 = extChar1;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段2
	 */
	public void setExtChar2(String extChar2) {
		this.extChar2 = extChar2;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段3
	 */
	public void setExtChar3(String extChar3) {
		this.extChar3 = extChar3;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段4
	 */
	public void setExtChar4(String extChar4) {
		this.extChar4 = extChar4;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段5
	 */
	public void setExtChar5(String extChar5) {
		this.extChar5 = extChar5;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 数字扩展字段1
	 */
	public void setExtNumber1(Integer extNumber1) {
		this.extNumber1 = extNumber1;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 数字扩展字段2
	 */
	public void setExtNumber2(Integer extNumber2) {
		this.extNumber2 = extNumber2;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 数字扩展字段3
	 */
	public void setExtNumber3(Integer extNumber3) {
		this.extNumber3 = extNumber3;
	}
	
	/**
	 * 取得职位的与工作流角色的关系列表.
	 * @return 取得职位的与工作流角色的关系列表
	 */
	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
	@JoinColumn(name = "position_id")
	@Fetch(FetchMode.SUBSELECT)
	public List<TmRPositionActRoleEntity> getTmRPositionActRoleList() {
		return tmRPositionActRoleList;
	}
	/**
	 * 设置职位的与工作流角色的关系列表.
	 * <p>
	 * @param tmRPositionActRoleList 职位的与工作流角色的关系列表
	 */
	public void setTmRPositionActRoleList(List<TmRPositionActRoleEntity> tmRPositionActRoleList) {
		this.tmRPositionActRoleList = tmRPositionActRoleList;
	}
	
	/**
	 * 取得职位的与权限角色的关系列表.
	 * @return 职位的与权限角色的关系列表
	 */
	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
	@JoinColumn(name = "position_id")
	@Fetch(FetchMode.SUBSELECT)
	public List<TmRPositionRoleEntity> getTmPositionRoleList() {
		return tmPositionRoleList;
	}
	
	/**
	 * 设置职位的与权限角色的关系列表.
	 * @param tmPositionRoleList 职位的与权限角色的关系列表
	 */
	public void setTmPositionRoleList(List<TmRPositionRoleEntity> tmPositionRoleList) {
		this.tmPositionRoleList = tmPositionRoleList;
	}
	@Override
	public String businessDesc() {
		return "职位的基本信息";
	}
	@Override
	public String addLogContent() {
		return null;
	}
	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		return null;
	}
	
}

