package com.biz.eisp.mdm.position.entity;

import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
/**
 * 职位与角色的关系实体.
 * <p>关联数据库表：tm_r_position_role<br>
 * @author grover
 * @version v1.0
 */
@Entity
@Table(name = "tm_r_position_role")
@SuppressWarnings("deprecation")
public class TmRPositionRoleEntity extends IdEntity implements java.io.Serializable,Loggerable {
	private static final long serialVersionUID = 1L;
	
	/**
	 * 创建时间
	 */
	private java.util.Date createDate;
	/**
	 * 创建人ID
	 */
	private java.lang.String createName;
	/**
	 * 修改时间
	 */
	private java.util.Date updateDate;
	/**
	 * 修改人
	 */
	private java.lang.String updateName;
	/**
	 * 角色信息实体关联角色表id
	 */
	private TmRoleEntity tmRole;
	/**
	 * 职位实体关联职位id
	 */
	private TmPositionEntity tmPosition;
	
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  创建时间
	 */
	@Column(name ="create_date",nullable=true)
	public java.util.Date getCreateDate(){
		return this.createDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  创建时间
	 */
	public void setCreateDate(java.util.Date createDate){
		this.createDate = createDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  创建人ID
	 */
	@Column(name ="create_name",nullable=true)
	public java.lang.String getCreateName(){
		return this.createName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  创建人ID
	 */
	public void setCreateName(java.lang.String createName){
		this.createName = createName;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  修改时间
	 */
	@Column(name ="update_date",nullable=true)
	public java.util.Date getUpdateDate(){
		return this.updateDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  修改时间
	 */
	public void setUpdateDate(java.util.Date updateDate){
		this.updateDate = updateDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  修改人ID
	 */
	@Column(name ="update_name",nullable=true)
	public java.lang.String getUpdateName(){
		return this.updateName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  修改人ID
	 */
	public void setUpdateName(java.lang.String updateName){
		this.updateName = updateName;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.role.entity.TmRoleEntity
	 *@return: com.biz.eisp.mdm.role.entity.TmRoleEntity 角色
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "role_id",referencedColumnName="id",updatable=true,insertable=true)
	public TmRoleEntity getTmRole() {
		return tmRole;
	}
	/**
	 *方法: 设置 com.biz.eisp.mdm.role.entity.TmRoleEntity
	 *@param: com.biz.eisp.mdm.role.entity.TmRoleEntity 角色
	 */
	public void setTmRole(TmRoleEntity tmRole) {
		this.tmRole = tmRole;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.position.entity.TmPositionEntity
	 *@return: com.biz.eisp.mdm.position.entity.TmPositionEntity 职位
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "position_id")
	public TmPositionEntity getTmPosition() {
		return tmPosition;
	}
	/**
	 *方法: 设置 com.biz.eisp.mdm.position.entity.TmPositionEntity
	 *@param: com.biz.eisp.mdm.position.entity.TmPositionEntity 职位
	 */
	public void setTmPosition(TmPositionEntity tmPosition) {
		this.tmPosition = tmPosition;
	}
	@Override
	public String businessDesc() {
		return "职位与角色关系";
	}
	@Override
	public String addLogContent() {
		String roleCode=tmRole!=null?tmRole.getRoleCode():"空";
		String roleName=tmRole!=null?tmRole.getRoleName():"";
		String content="职位["+tmPosition.getPositionCode()+"-"+tmPosition.getPositionName()+"]关联角色["
					+roleCode+"-"+roleName+"]</br>";
		return content;
	}
	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		String content="";
		String roleCode=tmRole!=null?tmRole.getRoleCode():"空";
		String roleName=tmRole!=null?tmRole.getRoleName():"";
		if(tmPosition==null){
			content="取消关联角色["+roleCode+"-"+roleName+"]</br>";
		}
		return content;
	}
}
