package com.biz.eisp.mdm.position.service;

import java.util.List;

import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
/**
 * 职位相关接口.
 * <p>职位相关接口方法
 * @author grover
 * @version v1.0
 */
public interface PositionService {
	/**
	 * 获取职位信息.
	 * <p>根据用户获取所有有效职位的数据集合。
	 * @param tmUserEntity 用户对象
	 * @param flag 是否主职位标记. 0-主职位 1-兼职职位
	 * @return 职位数据集合 
	 */ 
	public List<TmPositionVo> getPositinByUserId(TmUserEntity tmUserEntity,String flag);

	/**
	 * 根据岗位id查对象
	 * @param posId
	 * @return
	 */
	public TmPositionVo getPositinById(String posId);
}
