package com.biz.eisp.mdm.position.service;

import com.biz.eisp.activiti.entity.activiti.ActIdUserEntity;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;

/**
 * 职位业务Service扩展接口.
 * <p>
 * 扩展职位CURD操作。主要涉及表：tm_position。 此Service就是围绕tm_position表开展的业务
 * 
 * @author liukai
 * @version v1.0
 */
public interface TmPositionExtendService extends BaseService {

	/**
	 * 验证保存数据.
	 * <p>
	 * 
	 * @param vo
	 * @param page
	 * @return 验证失败throw new BusinessException("失败内容")
	 */
	public void validate(TmPositionVo vo, Page page);

	/**
	 * 保存职位信息前操作(并且没有做Vo到Entity的转换操作).
	 * <p>
	 * 返回null即保存前不做任何操作。 返回Entity后，系统即保存返回的Entity。不再做Vo转换到Entity的操作。
	 * @param vo
	 *            vo对象值
	 * @param page
	 *            页面对象
	 * @return 返回null即保存前不做任何操作。 返回Entity后，系统即保存返回的Entity。不再做Vo转换到Entity的操作。
	 */
	public TmPositionEntity saveBefore(TmPositionVo vo, Page page);

	/**
	 * 保存职位信息前操作（已经做了Vo到Entity的转换操作）.
	 * <p>
	 * 
	 * @param entity
	 *            Vo转换成Entity的值，该Entity，如果是新增操作即为游离态，修改操作即为持久态
	 * @param vo
	 *            vo对象值
	 * @param page
	 *            页面对象
	 * @return 返回Entity后，系统即保存返回的Entity。
	 */
	public TmPositionEntity saveBefore(TmPositionEntity entity, TmPositionVo vo, Page page);

	/**
	 * 保存职位后操作.
	 * <p>
	 * 
	 * @param entity
	 *            保存后的Entity对象，该Entity状态为持久态
	 * @param vo
	 *            vo对象值
	 * @param page
	 *            页面对象
	 * @return 返回Entity后，后面的其他操作，都会使用该Entity
	 */
	public TmPositionEntity savePost(TmPositionEntity entity, TmPositionVo vo, Page page);

	/**
	 * 同步职位到工作流表前操作.
	 * <p>
	 * 
	 * @param entity
	 *            职位Entity ，保存后的职位Entity对象，该Entity状态为持久态
	 * @param vo
	 *            vo对象值
	 * @param page
	 *            页面对象
	 */
	public void saveActIdUserBefore(TmPositionEntity entity, TmPositionVo vo, Page page);

	/**
	 * 同步职位到工作流表后操作.
	 * <p>
	 * 
	 * @param actIdUserEntity
	 *            工作流职位Entity（即工作流用户信息），该Entity状态为持久态
	 * @param entity
	 *            职位Entity ，保存后的职位Entity对象，该Entity状态为持久态
	 * @param vo
	 *            vo对象值
	 * @param page
	 *            页面对象
	 */
	public void saveActIdUserPost(ActIdUserEntity actIdUserEntity, TmPositionEntity entity, TmPositionVo vo, Page page);
}
