package com.biz.eisp.mdm.position.service;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import com.biz.eisp.mdm.position.vo.QueryTmpositionVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/** 职位业务Service.
 * <p>职位CURD操作。主要涉及表：tm_position。 此Service就是围绕tm_position表开展的业务<br>
 * @author liukai
 * @version v1.0
 */
public interface TmPositionService extends BaseService{

	/**
	 * 查询职位VO信息列表.
	 * <p>职位VO对象信息，涉及数据库表：tm_position（主表）,tm_org（关联表）<br>
	 * @param tmPositionVo 职位VO对象，接收参数使用
	 * @param page 页面对象
	 * @return 职位VO对象列表
	 */
	public List <TmPositionVo> findTmPositionList(TmPositionVo tmPositionVo, Page page);

	/**
	 * 查询未关联任何角色的职位.
	 * <p>职位VO对象信息，涉及数据库表：tm_position（主表）,tm_org（关联表）<br>
	 * @param tmPositionVo 职位VO对象，接收参数使用
	 * @param page 页面对象
	 * @return 职位VO对象列表
	 */
	public List <TmPositionVo> findNoAnyRolePositionList(TmPositionVo tmPositionVo, Page page);

	/**
	 * 查询未关联该角色的职位.
	 * <p>职位VO对象信息，涉及数据库表：tm_position（主表）,tm_org（关联表）<br>
	 * @param tmPositionVo 职位VO对象，接收参数使用
	 * @param page 页面对象
	 * @return 职位VO对象列表
	 */
	public List <TmPositionVo> findNoThisRolePositionList(TmPositionVo tmPositionVo, Page page);

	/**
	 * 查询已关联该角色的职位.
	 * <p>职位VO对象信息，涉及数据库表：tm_position（主表）,tm_org（关联表）<br>
	 * @param tmPositionVo 职位VO对象，接收参数使用
	 * @param page 页面对象
	 * @return 职位VO对象列表
	 */
	public List <TmPositionVo> findThisRolePositionList(TmPositionVo tmPositionVo, Page page);

	/**
	 * 查询组织下的职位信息列表.
	 * <p>
	 * @param tmPositionVo
	 * @param page
	 * @return
	 */
	public List <TmPositionVo> findTmPositionByOrgSelectList(TmPositionVo tmPositionVo, Page page);
	
	/**
	 * 查询职位信息列表.
	 * <p>
	 * @param tmPositionVo
	 * @param page
	 * @return
	 */
	public List <TmPositionVo> findTmPositionQuerySelectList(TmPositionVo tmPositionVo, Page page);
	
	/**
	 * 保存职位VO对象信息.
	 * <p>保存职位VO对象，需要保存的表信息有：tm_position<br>
	 * @param tmPositionVo 职位VO对象
	 * @param page 页面对象
	 */
	public void saveTmPosition(TmPositionVo tmPositionVo, Page page);
	
	/**
	 * 删除职位VO对象
	 * <p>删除职位VO对象信息，即删除职位业务对象信息数据，涉及表：tm_position<br>
	 * @param page 页面对象
	 */
	public void deleteTmPosition(String ids, Page page);
	/**
	 * 启用或者停用职位.
	 * @author grover
	 * @param tmPositionVo 职位vo对象
	 * @return
	 */
	AjaxJson startOrStopPosition(TmPositionVo tmPositionVo);
	/**
	 * 验证重复.
	 * @author grover
	 * @param tmPositionVo 职位vo对象
	 * @param param 验证当前对象的值
	 * @return 验证信息
	 */
	ValidForm validateTmposition(TmPositionVo tmPositionVo,String param);
//	/**
//	 * 获取用户选择职位.
//	 * @author grover
//	 * @param tmPositionVo 职位vo对象
//	 * @param page 分页信息
//	 * @return 职位信息
//	 */
//	List<TmPositionVo> findTmPositionForUserList(TmPositionVo tmPositionVo, Page page);
	/**
	 * 岗位tree
	 * @param request 
	 * @param comboTree
	 * @return
	 */
	List<ComboTree> getPositionForComboTree(HttpServletRequest request, ComboTree comboTree);
	/**
	 * 调整组织和职位的关系接口.
	 * @author grover
	 * @param tmOrgVo 组织vo对象
	 * @return 成功或者失败
	 */
	AjaxJson changePositionForOrg(TmOrgVo tmOrgVo);
	/**
	 * 切换职位接口.
	 * @author grover
	 * @param tmPositionVo 职位vo对象
	 */
	void changeTmPosition(TmPositionVo tmPositionVo);
	
	/**
	 * 查询组织下的所有职位信息.
	 * <p>
	 * @param orgId 组织ID
	 * @return
	 */
	List <TmPositionVo> findPositionListByOrgId(String orgId);
	/**
	 * 获取用户其他信息.
	 * <p>比如：职位，权限角色，工作流角色等
	 * @author grover
	 * @return 用户其他信息
	 */
	List <TmPositionVo> findOtherTmUserInfo();
	/**
	 * 查询职位
	 * 职位名称模糊查询
	 * 组织查询条件
	 * @author wan
	 * @param query
	 * @return
	 */
	List<TmPositionVo> findPositionByConditions(TmPositionVo query,Page page);
	/**
	 * 职位相关接口 - 主要对外.
	 * <p>该接口提供了所有可能查询职位的方式.<br>
	 * 0、无参数 positionName职位名称，positionCode职位编码，positionLevel职位级别 isMain职位类型（0主职位，1兼职职位） 模糊查询.<br>
	 * 1、当前职位信息 所需参数：id职位id.<br>
	 * 2、职位的上级信息 所需参数：parentId职位id.<br>
	 * 3、职位的下级信息 所需参数：levelId职位id.<br>
	 * 4、组织直管的职位信息 所需参数：orgId组织id 或者 orgName组织名称 .<br>
	 * 5、组织及其下级组织的职位信息  所需参数：levelAllOrgId组织id.<br>
	 * 6、某一权限角色的职位信息 所需参数：roleIds角色id 或者 roleNames角色名称.<br>
	 * 7、某一工作流角色的职位信息 所需参数：workflowRoleIds角色id 或者 workflowRoleNames角色名称.<br>
	 * 8、职位及其所有下级职位信息 所需参数：levelAllPosId职位id.
	 * 9、某一用户的职位信息 所需参数：userId用户id 或者 fullName用户名称.
	 * @author grover
	 * @param queryTmpositionVo 查询方式vo
	 * @param page 分页对象 如果不分页传入一个null
	 * @return 职位vo集合
	 */
	List<TmPositionVo> findTmPositionByAllPossible(QueryTmpositionVo queryTmpositionVo, Page page);
	
	/**
	 * 查看客户用户日志
	 * @param tmLogVo
	 * @param page
	 * @return
	 */
	@Arguments({"tmLogVo","page"})
	@ResultType(TmLogVo.class)
	public List<TmLogVo> findPositionLogList(TmLogVo tmLogVo, Page page);
	
	/**
	 * 判断是否是主职位.
	 * @author grover
	 * @param posId
	 * 		职位id
	 * @return
	 * 		大于>0 是主职位
	 */
	public long isMainPosition(String posId);
	/**
	 * 修改传过来的职位为主职位.
	 * @author grover
	 * @param userId
	 * 		用户主键
	 * @param mainPosId
	 * 		主职位id
	 */
	public void updatePositionIsMain(String userId,String mainPosId);

	/**
	 * 添加职位与角色关联
	 * @param positionIds 职位id 逗号分隔
	 * @param roleId 角色id
	 */
	public void addPositionRoleRelation(String positionIds, String roleId);

	/**
	 * 移除职位与角色关联
	 * @param relationIds 关联关系Id 逗号分隔
	 */
	public void deletePositionRoleRelation(String relationIds);

	/**
	 * 替换职位与角色关联
	 * @param relationIds 关联关系id 逗号分隔
	 * @param roleId 要替换的新的角色id
	 */
	public void updatePositionRoleRelation(String relationIds, String roleId);
}
