package com.biz.eisp.mdm.position.service.impl;

import java.util.Date;
import java.util.List;

import com.biz.eisp.base.common.util.CollectionUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.position.service.PositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
/**
 * 职位接口实现类.
 * @author grover
 * @version v1.0
 */
@Service("positionService")
@Transactional
public class PositionServiceImpl extends BaseServiceImpl implements PositionService{
	/**
	 * 获取职位信息.
	 * <p>根据用户获取所有有效职位的数据集合的实现方法。
	 * @param tmUserEntity 用户对象
	 * @param flag 是否主职位标记. 0-主职位 1-兼职职位
	 * @return 职位数据集合 
	 */ 
	@Override
	public List<TmPositionVo> getPositinByUserId(TmUserEntity tmUserEntity,String flag) {
		String sql="SELECT TMP.* FROM TM_POSITION TMP"
				  +" JOIN TM_R_USER_POSITION TUP ON TMP.ID=TUP.POSITION_ID"
				  +" JOIN TM_USER TMU ON TUP.USER_ID=TMU.ID"
				  +" WHERE ? BETWEEN TUP.START_DATE AND TUP.END_DATE AND TUP.IS_MAIN=?"
				  +" AND TMU.ID=?";
		List<TmPositionVo> posts = super.findBySql(TmPositionVo.class, sql,new Date(), flag,tmUserEntity.getId());
		
		return posts;
	}

	@Override
	public TmPositionVo getPositinById(String posId) {
		String sql="SELECT TMP.* FROM TM_POSITION TMP where  TMP.ID=?";
		List<TmPositionVo> posts = super.findBySql(TmPositionVo.class, sql,posId);
        if (CollectionUtil.listNotEmptyNotSizeZero(posts)){
        	return posts.get(0);
		}
		return null;
	}
}
