package com.biz.eisp.mdm.position.service.impl;

import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.terminal.service.TmTerminalService;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;

import java.util.List;
import java.util.Map;

/**
 * 职位信息excel导入
 * @author 肖胜
 * @version v1.0
 */
public class TmPositionEventHandler extends ImpEventHandler <TmPositionVo>{

	private TmPositionService tmPositionService = null;

	public TmPositionEventHandler() {
		tmPositionService =(TmPositionService) ApplicationContextUtils
				.getContext().getBean("tmPositionService");
	}

	@Override
	public void endRow(Map<String, Object> row, TmPositionVo bean) throws ValidateException {
		try {
			//执行保存
			Page page = new EuPage();

			setRelationValues(bean);

			tmPositionService.saveTmPosition(bean,page);
		} catch (Exception e) {
			addError("第"+getRowNumber()+"行遇到错误:"+e.getMessage());
			e.printStackTrace();
		}
		//设置已成功导入条数
		setSuccNum(getSuccNum()+1);
	}

	/**
	 * 设置职位关系数据，  权限角色， 工作流角色
	 * @param bean
	 */
	private void setRelationValues(TmPositionVo bean) {
		TmPositionEntity positionEntity = tmPositionService.findUniqueByProperty(TmPositionEntity.class,
				"positionCode", bean.getPositionCode());

		//设置已存在的权限角色，工作流角色数据
		if(positionEntity != null) {
			String roleIds = this.getRoleIds(positionEntity.getId());
			String actRoleIds = this.getActRoleIds(positionEntity.getId());

			bean.setRoleIds(roleIds);

			bean.setWorkflowRoleIds(actRoleIds);
		}
	}

	/**
	 * 获取职位关联的权限角色IDS 已逗号分隔
	 * @param positionId
	 * @return
	 */
	private String getRoleIds(String positionId) {
		String sql = "SELECT LISTAGG(role_id, ',') WITHIN GROUP(ORDER BY position_id) AS roleIds FROM tm_r_position_role WHERE position_id = ?";
		List<TmPositionVo> list = tmPositionService.findBySql(TmPositionVo.class, sql, positionId);
		if(list != null) {
			return list.get(0).getRoleIds();
		}

		return null;
	}

	/**
	 * 获取职位关联的工作流角色IDS，已逗号分隔
	 * @param positionId
	 * @return
	 */
	private String getActRoleIds(String positionId) {
		String sql = "SELECT LISTAGG(role_id, ',') WITHIN GROUP(ORDER BY position_id) AS roleIds FROM tm_r_position_act_role WHERE position_id = ?";
		List<TmPositionVo> list = tmPositionService.findBySql(TmPositionVo.class, sql, positionId);
		if(list != null) {
			return list.get(0).getRoleIds();
		}

		return null;
	}
}
