package com.biz.eisp.mdm.position.service.impl;

import com.biz.eisp.activiti.entity.activiti.ActIdUserEntity;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.actrole.entity.TmActRoleEntity;
import com.biz.eisp.mdm.actrole.entity.TmRPositionActRoleEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import com.biz.eisp.mdm.position.dao.TmPositionDao;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.entity.TmRPositionRoleEntity;
import com.biz.eisp.mdm.position.service.TmPositionExtendService;
import com.biz.eisp.mdm.position.service.TmPositionSearchExtendService;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.transformer.TmPositionEntityToTmPositionVo;
import com.biz.eisp.mdm.position.transformer.TmPositionVoToTmPositionEntity;
import com.biz.eisp.mdm.position.vo.QueryTmpositionVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserPositionEntity;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 职位相关操作的接口实现.
 * @author liukai
 * @version v1.0
 */
@SuppressWarnings("deprecation")
@Service("tmPositionService")
@Transactional
public class TmPositionServiceImpl extends BaseServiceImpl implements TmPositionService{
	/**
	 * 注入职位dao
	 */
	@Autowired
	private TmPositionDao tmPositionDao;
	/**
	 * 注入职位保存扩展service 
	 */
	@Autowired(required = false)
	private TmPositionExtendService tmPositionExtendService;

	/**
	 * 注入职位查询扩展service
	 */
	@Autowired(required = false)
	private TmPositionSearchExtendService tmPositionSearchExtendService;
	
	@Override
	public List<TmPositionVo> findTmPositionList(TmPositionVo tmPositionVo, Page page) {
		
		String sql ="";
		if(tmPositionSearchExtendService!=null){
			sql=tmPositionSearchExtendService.buildSearchSql(tmPositionVo);
			if(StringUtil.isEmpty(sql)){
				sql=DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_POSITION, tmPositionVo);
				sql=tmPositionSearchExtendService.extendSearchSql(tmPositionVo,sql);
			}
		}else{
			sql=DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_POSITION, tmPositionVo);
			sql = this.appendPositionCondition(sql, tmPositionVo);
		}

		List <TmPositionVo> voList = tmPositionDao.findTmPositionList(tmPositionVo, page,sql);
		if(!CollectionUtils.isEmpty(voList)){
			for (TmPositionVo tmPositionVo2 : voList) {
				//查询权限角色 和 工作流角色
				HandleRoleName(tmPositionVo2);
			}
		}
		return voList;
	}

	@Override
	public List<TmPositionVo> findNoAnyRolePositionList(TmPositionVo tmPositionVo, Page page) {
		List <TmPositionVo> voList = tmPositionDao.findNoAnyRolePositionList(tmPositionVo, page);
		return voList;
	}

	@Override
	public List<TmPositionVo> findNoThisRolePositionList(TmPositionVo tmPositionVo, Page page) {
		List <TmPositionVo> voList = tmPositionDao.findNoThisRolePositionList(tmPositionVo, page);
		return voList;
	}

	@Override
	public List <TmPositionVo> findThisRolePositionList(TmPositionVo tmPositionVo, Page page) {
		List <TmPositionVo> voList = tmPositionDao.findThisRolePositionList(tmPositionVo, page);
		return voList;
	}

	@Override
	public List <TmPositionVo> findTmPositionByOrgSelectList(TmPositionVo tmPositionVo, Page page) {
		List <TmPositionVo> list = tmPositionDao.findTmPositionByOrgSelectList(tmPositionVo, page);
		return list;
	}
	
	public List <TmPositionVo> findTmPositionQuerySelectList(TmPositionVo tmPositionVo, Page page) {
		List <TmPositionVo> list = tmPositionDao.findTmPositionQuerySelectList(tmPositionVo, page);
		return list;
	}
	
	/**
	 * 职位信息添加非本表查询条件
	 * @param sql
	 * @return
	 */
	public String appendPositionCondition(String sql,Object paramObj){
		TmPositionVo tmPositionVo=new TmPositionVo();
		if(paramObj!=null){
			tmPositionVo=(TmPositionVo)paramObj;
		}
		
		String isRoleSerchSql = "";
		if(StringUtil.isNotBlank(tmPositionVo.getRoleIds())){
			isRoleSerchSql=",trpr.role_id";	
		}
		
		//关联了企业组织表、职位与用户对应关系表、用户表
		String joinSql="select p.id newId,o.org_name,o.id org_id,"
								+" tmo.org_name AS parentOrgName,pp.position_code AS parentCode "
								+ isRoleSerchSql;
		//查询以下字段会造成重复数据，故当有这以下查询条件的时候才追加
//		if(StringUtil.isNotEmpty(tmPositionVo.getFullName())||
//				StringUtil.isNotEmpty(tmPositionVo.getFullName())||
//				StringUtil.isNotEmpty(tmPositionVo.getParentUserName())||
//				StringUtil.isNotEmpty(tmPositionVo.getUserId())||
//				StringUtil.isNotBlank(tmPositionVo.getRoleIds())){
			joinSql+=" ,trup.is_main AS isMain,trup.user_id,tu.username AS userName,tu.fullname AS fullName, ptu.fullname AS parentUserName,trup.id AS tmRPositionUserId ";
//		}
							
			joinSql+=" FROM tm_position p LEFT JOIN tm_org o ON o.id = p.org_id"
								+" LEFT JOIN tm_r_user_position trup ON trup.position_id=p.id"
								+" LEFT JOIN tm_user tu ON tu.id = trup.user_id LEFT JOIN tm_position pp ON pp.id = p.parent_id"
								+" LEFT JOIN tm_org tmo ON pp.org_id = tmo.id LEFT JOIN tm_r_user_position ptup ON pp.id=ptup.position_id"
								+" LEFT JOIN tm_user ptu ON ptu.id=ptup.user_id";
		
		String onSql="t1.newId=t.id";
		
		String sqlWhere="";
		
		if(StringUtil.isNotEmpty(tmPositionVo.getId())){
			sql+=" and t.id='"+tmPositionVo.getId()+"'";
		}
		
		//过滤当前职位
		if(StringUtil.isNotEmpty(tmPositionVo.getCurentOrg()) && StringUtil.isEmpty(tmPositionVo.getId())){
			String posId = ResourceConfigUtils.getString("position");
			if(StringUtil.isEmpty(posId)){
				posId = ResourceConfigUtils.getCurrPosition().getId();
			}
			if(StringUtil.isNotEmpty(posId)){
				sql+=" and t.id <>'"+posId+"'";
			}
		}
		
		//弹窗口选择时 过滤已被选职位信息
		if(StringUtil.isNotEmpty(tmPositionVo.getFlag())){
			String excludeId = StringUtil.isNotEmpty(tmPositionVo.getExcludeId())?tmPositionVo.getExcludeId():"'-1'";
			sqlWhere+=" AND t.id not in (select position_id from tm_r_user_position WHERE user_id is not null AND position_id not in ("+excludeId+"))";
		}
		//弹窗口选择时 过滤已被选职位信息 并且过滤已经被选的职位信息
		if(StringUtil.isNotEmpty(tmPositionVo.getNotInId())){
			sqlWhere+=" AND t.id not in ("+tmPositionVo.getNotInId()+")";
		}
		
		//根据职位与角色对应关系的角色信息来查询
		if(StringUtil.isNotEmpty(tmPositionVo.getRoleIds())){
			joinSql+=" LEFT JOIN tm_r_position_role trpr ON p.id=trpr.position_id";
			sqlWhere+=" AND t1.role_id ='"+tmPositionVo.getRoleIds()+"'";
		}
		//根据上级职位对应用户查询
		if(StringUtil.isNotEmpty(tmPositionVo.getParentUserName())){
			sqlWhere+=" AND t1.parentUserName like '%"+tmPositionVo.getParentUserName()+"%'";
		}
		//根据上级职位对应用户查询
		if(StringUtil.isNotEmpty(tmPositionVo.getParentName())){
			sqlWhere+=" AND t.parentName like '%"+tmPositionVo.getParentName()+"%'";
		}
		//根据职位对应用户姓名查询
		if(StringUtil.isNotEmpty(tmPositionVo.getFullName())){
			sqlWhere+="AND t1.fullname like '%"+tmPositionVo.getFullName()+"%'";
		}
		//根据职位对应登录账号查询
		if(StringUtil.isNotEmpty(tmPositionVo.getUserName())){
			sqlWhere+="AND t1.username like '%"+tmPositionVo.getUserName()+"%'";
		}
		//根据职位对应用户id查询
		if(StringUtil.isNotEmpty(tmPositionVo.getUserId())){
			sqlWhere+=" AND t1.user_id ='"+tmPositionVo.getUserId()+"'";
		}
		//根据企业组织信息查询下级组织
		if(StringUtil.isNotEmpty(tmPositionVo.getCurentOrg())){
			sqlWhere+=" AND t.orgId in (select id from tm_org start with id='${tmPositionVo.curentOrg}' connect by prior parent_id=id)";
			if(StringUtil.isNotBlank(tmPositionVo.getCurentId())){
				sqlWhere+=" AND t.id <>'"+tmPositionVo.getCurentId()+"'";
			}
		}
		//	//根据企业组织查询
		if(StringUtil.isNotEmpty(tmPositionVo.getOrgId())){
			sqlWhere+=" AND t.orgId ='"+tmPositionVo.getOrgId()+"'";
		}
		String orderSql=" order by t.positionCode asc";
		return DynamicConfigUtil.getInstance().appendCustomCondition(sql, joinSql, onSql, sqlWhere,orderSql);
	}
	
	/**
	 * 职位处理相关其他信息.
	 * @author grover
	 * @param positionVo 职位vo
	 * @return 角色names
	 */
	private void HandleRoleName(TmPositionVo positionVo) {
		List<TmRoleEntity> roles = tmPositionDao.findTmRoleByPosition(positionVo);
		//权限角色 name和id的装载容器
		StringBuffer bufferNames = new StringBuffer();
		StringBuffer bufferIds = new StringBuffer();
		if(!CollectionUtils.isEmpty(roles)){
			for (TmRoleEntity tmRoleEntity : roles) {
				if(bufferNames.length() > 0){
					bufferNames.append(",");
					bufferIds.append(",");
				}
				bufferNames.append(tmRoleEntity.getRoleName());
				bufferIds.append(tmRoleEntity.getId());
			}
			//设置
			positionVo.setRoleNames(bufferNames.toString());
			positionVo.setRoleIds(bufferIds.toString());
		}
		//工作流角色 name和id的装载容器
		StringBuffer actRoleBufferNames = new StringBuffer();
		StringBuffer actRoleBufferIds = new StringBuffer();
		List<TmActRoleEntity> actRoles = tmPositionDao.findTmActRoleByPosition(positionVo);
		if(!CollectionUtils.isEmpty(actRoles)){
			for (TmActRoleEntity actRole : actRoles) {
				if(actRoleBufferNames.length() > 0){
					actRoleBufferNames.append(",");
					actRoleBufferIds.append(",");
				}
				actRoleBufferNames.append(actRole.getRoleName());
				actRoleBufferIds.append(actRole.getId());
			}
			//设置
			positionVo.setWorkflowRoleNames(actRoleBufferNames.toString());
			positionVo.setWorkflowRoleIds(actRoleBufferIds.toString());
		}
	}


	@Override
	public void saveTmPosition(TmPositionVo tmPositionVo, Page page) {
		TmPositionEntity tmPositionEntity = null;
		String positionId="";
		if(tmPositionExtendService != null) {
			//保存前，数据验证
			try {
				tmPositionExtendService.validate(tmPositionVo, page);
			} catch (BusinessException e) {
				throw new BusinessException("数据验证不通过" + e.getMessage());
			}
			//保存前操作
			tmPositionEntity = tmPositionExtendService.saveBefore(tmPositionVo, page);
		}
		
		//转换Vo为Entity
		if(tmPositionEntity == null) {
			tmPositionEntity = new TmPositionVoToTmPositionEntity(this).apply(tmPositionVo);
			tmPositionEntity.setCreateDate(new Date());

		}
		tmPositionEntity.setUpdateDate(new Date());
		
		if(tmPositionExtendService != null) {
			//保存前操作，此时tmPositionEntity已经进行了Vo到Entity的实体间转换
			tmPositionEntity = tmPositionExtendService.saveBefore(tmPositionEntity, tmPositionVo, page);
		}
		
		//1.保存TmPositionEntity
		this.saveOrUpdate(tmPositionEntity);
		positionId=tmPositionEntity.getId();
		if(tmPositionExtendService != null) {
			//保存后操作
			tmPositionEntity = tmPositionExtendService.savePost(tmPositionEntity, tmPositionVo, page);
			
			//同步职位到工作流表前操作
			tmPositionExtendService.saveActIdUserBefore(tmPositionEntity, tmPositionVo, page);
		}
		
		//2.同步职位到工作流表
		ActIdUserEntity actIdUserEntity = saveActIdUser(tmPositionEntity);
		
		if(tmPositionExtendService != null) {
			//同步职位到工作流表后操作
			tmPositionExtendService.saveActIdUserPost(actIdUserEntity, tmPositionEntity, tmPositionVo, page);
		}
		
		//记录将要删除的对应关系日志
		String hql="FROM TmRPositionRoleEntity where tmPosition.id is null";
		List<TmRPositionRoleEntity> list=this.findByHql(hql);
		for(TmRPositionRoleEntity prole:list){
			String proleId=prole.getId();
			super.addLogAndRemoveInvalidInfo(proleId, prole, positionId,null);
		}
		//4.删除无用职位与角色关系
		executeSql("DELETE FROM TM_R_POSITION_ROLE WHERE POSITION_ID IS NULL");
		
		//记录将要删除的对应关系日志
		String hql1="FROM TmRPositionActRoleEntity where tmPosition.id is null";
		List<TmRPositionActRoleEntity> list1=this.findByHql(hql1);
		for(TmRPositionActRoleEntity prole:list1){
			String proleId=prole.getId();
			super.addLogAndRemoveInvalidInfo(proleId, prole, positionId,null);
		}
		//4.删除无用职位与工作流角色关系
		executeSql("DELETE FROM TM_R_POSITION_ACT_ROLE WHERE POSITION_ID IS NULL");
		
	}
	/**
	 * 保存工作流用户同步表.
	 * @author grover
	 * @param tmPositionEntity 职位entity
	 */
	private ActIdUserEntity saveActIdUser(TmPositionEntity tmPositionEntity) {
		ActIdUserEntity actIdUserEntity = get(ActIdUserEntity.class, tmPositionEntity.getPositionCode());
		if(!StringUtil.isNotEmpty(actIdUserEntity)){
			actIdUserEntity = new ActIdUserEntity();
			actIdUserEntity.setId(tmPositionEntity.getPositionCode());
			actIdUserEntity.setRev(Globals.REV);
			actIdUserEntity.setLast(tmPositionEntity.getPositionName());
			save(actIdUserEntity);
		}else{
			actIdUserEntity.setId(tmPositionEntity.getPositionCode());
			actIdUserEntity.setRev(Globals.REV);
			actIdUserEntity.setLast(tmPositionEntity.getPositionName());
			updateEntity(actIdUserEntity);	
		}
		return actIdUserEntity;
	}

	@Override
	@Transactional
	public void deleteTmPosition(String ids, Page page) {
		if(StringUtil.isNotEmpty(ids)){
			String[] positionIds=ids.split(",");
			for(String positionId:positionIds){
				TmPositionEntity tmPositionEntity = get(TmPositionEntity.class, positionId);
				if(tmPositionEntity!=null&&StringUtil.isNotEmpty(tmPositionEntity.getId())){
					if(CollectionUtil.listNotEmptyNotSizeZero(tmPositionEntity.getTmPositionList())){
						throw new BusinessException("包含下级职位,无法删除");
					}
					//删除用户与职位对应关系
					List<TmUserPositionEntity> list=this.findByProperty(TmUserPositionEntity.class
							, "tmPosition.id",tmPositionEntity.getId() );
					for(TmUserPositionEntity userPosition:list){
						userPosition.setTmUser(this.get(TmUserEntity.class, userPosition.getTmUser().getId()));
						delete(userPosition);
					}

					tmPositionDao.deleteTmPositionById(tmPositionEntity);
//					deleteAllEntity(list);
					delete(tmPositionEntity);
				}
			}

		}
	}

	@Override
	public AjaxJson startOrStopPosition(TmPositionVo tmPositionVo) {
		AjaxJson j = new AjaxJson();
		TmPositionEntity positionEntity = get(TmPositionEntity.class, tmPositionVo.getId());
		if(StringUtil.isNotEmpty(positionEntity)){
			if(positionEntity.getEnableStatus().equals(tmPositionVo.getEnableStatus())){
				j.setSuccess(false);
				String fg = Globals.ZERO == tmPositionVo.getEnableStatus()?"启用":"停用";
				
				j.setMsg("该数据状态已经为"+fg+"，无需再次操作");
			}else{
				positionEntity.setEnableStatus(tmPositionVo.getEnableStatus());
				updateEntity(positionEntity);
			}
		}else{
			throw new BusinessException("未找到该纪录");
		}
		return j;
	}
	@Override
	public ValidForm validateTmposition(TmPositionVo tmPositionVo, String param) {
		ValidForm validForm = new ValidForm();
		String hql = "";
		if(StringUtil.isNotEmpty(tmPositionVo.getId())){
			//修改验证
			if(StringUtil.isNotEmpty(tmPositionVo.getType())){
				if(StringUtil.equals("0", tmPositionVo.getType())){
					//编码
					hql = "from TmPositionEntity where positionCode=? and id<>? and enableStatus=?";
					List<TmPositionEntity> list = findByHql(hql, param, tmPositionVo.getId(), Globals.ZERO);
					if(!CollectionUtils.isEmpty(list)){
						validForm.setInfo("职位编码已经存在");
						validForm.setStatus("n");
					}	
				}
				if(StringUtil.equals("1", tmPositionVo.getType())){
					//名称
					hql = "from TmPositionEntity where positionName=? and id<>? and enableStatus=?";
					List<TmPositionEntity> list = findByHql(hql, param, tmPositionVo.getId(), Globals.ZERO);
					if(!CollectionUtils.isEmpty(list)){
						validForm.setInfo("职位名称已经存在");
						validForm.setStatus("n");
					}
				}
			}
		}else{
			//新增验证	
			if(StringUtil.isNotEmpty(tmPositionVo.getType())){
				if(StringUtil.equals("0", tmPositionVo.getType())){
					//编码
					hql = "from TmPositionEntity where positionCode=? and enableStatus=?";
					List<TmPositionEntity> list = findByHql(hql, param, Globals.ZERO);
					if(!CollectionUtils.isEmpty(list)){
						validForm.setInfo("职位编码已经存在");
						validForm.setStatus("n");
					}
				}
				if(StringUtil.equals("1", tmPositionVo.getType())){
					//名称
					hql = "from TmPositionEntity where positionName=? and enableStatus=?";
					List<TmPositionEntity> nameList = findByHql(hql, param, Globals.ZERO);
					if(!CollectionUtils.isEmpty(nameList)){
						validForm.setInfo("职位名称已经存在");
						validForm.setStatus("n");
					}
				}
			}
		}
		return validForm;
	}
	
	@Override
	public List<ComboTree> getPositionForComboTree(HttpServletRequest request, ComboTree comboTree) {
		 String selfId = request.getParameter("selfId");
	    	List<TmPositionEntity> positionList=new ArrayList<TmPositionEntity>();
	        if(StringUtil.isNotEmpty(selfId)){
	        	positionList=this.findByProperty(TmPositionEntity.class, "id", selfId);
	        }else if(StringUtil.isNotEmpty(comboTree.getId())){
	        	positionList=this.findByProperty(TmPositionEntity.class, "tmPosition.id", comboTree.getId());
	        }else{
	        	Criterion cr=Restrictions.isNull("tmPosition.id");
	        	positionList=this.findByCriteria(TmPositionEntity.class, cr);
	        }
	    	List<ComboTree> comboTrees = new ArrayList<ComboTree>();
			ComboTreeModel comboTreeModel = new ComboTreeModel("id",
					"positionName", "positions");
			comboTrees = this.comboTree(positionList, comboTreeModel,
					null, false);
		return comboTrees;
	}
	@Override
	public AjaxJson changePositionForOrg(TmOrgVo tmOrgVo) {
		AjaxJson j = new AjaxJson();
		if(StringUtil.isNotEmpty(tmOrgVo.getPositionIds())){
			TmPositionEntity tmPositionEntity = null;
			TmOrgEntity tmOrgEntity = null;
			String[] posIds = tmOrgVo.getPositionIds().split(",");
			for (String posId : posIds) {
				tmPositionEntity = get(TmPositionEntity.class, posId);
				if(StringUtil.isNotEmpty(tmPositionEntity)){
					tmOrgEntity = this.get(TmOrgEntity.class, tmOrgVo.getOrgId());
					tmPositionEntity.setTmOrg(tmOrgEntity);
					tmPositionEntity.setTmPosition(null);
					saveOrUpdate(tmPositionEntity);
				}
			}
			j.setMsg("调整关系成功");
		}else{
			j.setSuccess(false);
			j.setMsg("缺少必要的参数");
		}
		return j;
	}
	@Override
	public void changeTmPosition(TmPositionVo tmPositionVo) {
		String slq1 = " update tm_r_user_position set is_main=? where user_id=? ";
		executeSql(slq1, new Object[]{Globals.ONE, tmPositionVo.getUserId()});
		String slq2 = " update tm_r_user_position set is_main=? where position_id=? ";
		executeSql(slq2, new Object[]{Globals.ZERO, tmPositionVo.getId()});
		//更新session
		ResourceConfigUtils.addString("position",tmPositionVo.getId());
	}
	@Override
	public List<TmPositionVo> findPositionListByOrgId(String orgId) {
		String hql = "from TmPositionEntity pe where tmOrg.id = ?";
		List <TmPositionEntity> entityList = this.findByHql(hql, orgId);
		List <TmPositionVo> list = Lists.transform(entityList, new TmPositionEntityToTmPositionVo());
		return list;
	}
	@Override
	public List<TmPositionVo> findOtherTmUserInfo() {
		String userId = ResourceConfigUtils.getSessionTmUserVo().getId();
		TmPositionVo tmPositionVo = new TmPositionVo();
		tmPositionVo.setUserId(userId);
		return tmPositionDao.findOtherTmUserInfo(tmPositionVo);
	}

	@Override
	public List<TmPositionVo> findPositionByConditions(TmPositionVo query,Page page) {
		List<TmPositionVo> list = tmPositionDao.findTmPositionParentByCondition(query, page);
		return list;
	}

	@Override
	public List<TmPositionVo> findTmPositionByAllPossible(
			QueryTmpositionVo queryTmpositionVo, Page page) {
		return tmPositionDao.findTmPositionByAllPossible(queryTmpositionVo,page);
	}


	@Override
	public List<TmLogVo> findPositionLogList(TmLogVo tmLogVo, Page page) {
		return tmPositionDao.findPositionLogList(tmLogVo, page);
	}
	

	@Override
	public long isMainPosition(String posId) {
		String sql = "select count(1) from tm_r_user_position where position_id=? and is_main=?";
		long count = getCountForJdbcParam(sql, posId, Globals.Main_Position_Type);
		return count;
	}

	@Override
	public void updatePositionIsMain(String userId, String mainPosId) {
		String sql1 = " update tm_r_user_position set is_main = ? where user_id=? ";
		executeSql(sql1, new Object[]{Globals.PartTime_Position_Type,userId});
		String sql2 = " update tm_r_user_position set is_main = ? where position_id=? ";
		executeSql(sql2, new Object[]{Globals.Main_Position_Type, mainPosId});
	}

	@Override
	public void addPositionRoleRelation(String positionIds, String roleId) {
		String [] positionIdArr = positionIds.split(",");
		for(String positionId : positionIdArr) {
			this.addPositionRoleRelationItem(positionId, roleId);
		}
	}

	/**
	 * 添加职位与角色关系数据
	 * @param positionId
	 * @param roleId
	 */
	private void addPositionRoleRelationItem(String positionId, String roleId) {
		String hql = "from TmRPositionRoleEntity where tmRole.id = ? and tmPosition.id = ?";
		List <TmRPositionRoleEntity> rPositionRoleEntityList = this.findByHql(hql, roleId, positionId);
		if(CollectionUtil.listNotEmptyNotSizeZero(rPositionRoleEntityList)) {
			throw new BusinessException("已经关联，不能重复添加");
		}

		TmRPositionRoleEntity rPositionRoleEntity = new TmRPositionRoleEntity();
		TmPositionEntity positionEntity = this.get(TmPositionEntity.class, positionId);
		if(positionEntity == null) {
			throw new BusinessException("职位Id值不存在");
		}

		TmRoleEntity roleEntity = this.get(TmRoleEntity.class, roleId);
		if(roleEntity == null) {
			throw new BusinessException("角色Id值不存在");
		}

		rPositionRoleEntity.setTmPosition(positionEntity);
		rPositionRoleEntity.setTmRole(roleEntity);
		this.save(rPositionRoleEntity);
	}

	@Override
	public void deletePositionRoleRelation(String relationIds) {
		String [] relationIdArr = relationIds.split(",");
		for(String relationId : relationIdArr) {
			TmRPositionRoleEntity rPositionRoleEntity = this.get(TmRPositionRoleEntity.class , relationId);

			//添加日志
			this.addDeletePositionRoleRelationLog(rPositionRoleEntity);

			this.delete(rPositionRoleEntity);
		}
	}

	/**
	 * 添加日志
	 * @param rPositionRoleEntity
	 */
	private void addDeletePositionRoleRelationLog(TmRPositionRoleEntity rPositionRoleEntity) {
		String logContent = "取消关联角色["+rPositionRoleEntity.getTmRole().getRoleCode() + "-" + rPositionRoleEntity.getTmRole().getRoleName()+ "]";
		super.addLogAndRemoveInvalidInfo(rPositionRoleEntity.getId(), rPositionRoleEntity, rPositionRoleEntity.getTmPosition().getId(),logContent);
	}

	@Override
	public void updatePositionRoleRelation(String relationIds, String roleId) {
		String [] relationIdArr = relationIds.split(",");
		for(String relationId : relationIdArr) {
			this.updatePositionRoleRelationItem(relationId, roleId);
		}
	}

	/**
	 * 替换职位与角色的关系
	 * @param relationId
	 * @param roleId
	 */
	private void updatePositionRoleRelationItem(String relationId, String roleId) {
		TmRPositionRoleEntity rPositionRoleEntity = this.get(TmRPositionRoleEntity.class , relationId);

		TmRoleEntity roleEntity = this.get(TmRoleEntity.class, roleId);
		if(roleEntity == null) {
			throw new BusinessException("角色Id值不存在");
		}

		//添加日志
		this.addUpdatePositionRoleRelationItemLog(rPositionRoleEntity, roleEntity);

		rPositionRoleEntity.setTmRole(roleEntity);

		this.updateEntity(rPositionRoleEntity);
	}

	/**
	 * 添加日志
	 * @param rPositionRoleEntity
	 * @param newRoleEntity
	 */
	private void addUpdatePositionRoleRelationItemLog(TmRPositionRoleEntity rPositionRoleEntity, TmRoleEntity newRoleEntity) {
		String logContent = "替换角色["+rPositionRoleEntity.getTmRole().getRoleCode() + "-"
				+ rPositionRoleEntity.getTmRole().getRoleName()+ "]为["
				+ newRoleEntity.getRoleCode() + "-" + newRoleEntity.getRoleName() + "]";

		super.addLogAndRemoveInvalidInfo(rPositionRoleEntity.getId(), rPositionRoleEntity, rPositionRoleEntity.getTmPosition().getId(),logContent,"UPDATE");
	}
}
