package com.biz.eisp.mdm.position.transformer;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.google.common.base.Function;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
public class TmPositionEntityToTmPositionVo implements Function<TmPositionEntity, TmPositionVo>{

	@Override
	public TmPositionVo apply(TmPositionEntity entity) {
		TmPositionVo vo = new TmPositionVo();
		
		vo.setId(entity.getId());
		vo.setPositionCode(entity.getPositionCode());
		vo.setPositionName(entity.getPositionName());
		//上级职位
		if(StringUtil.isNotEmpty(entity.getTmPosition())){
			vo.setParentName(entity.getTmPosition().getPositionName());
			vo.setParentId(entity.getTmPosition().getId());
		}
		vo.setBusinessGroup(entity.getBusinessGroup());
		vo.setPositionLevel(entity.getPositionLevel());
		//设置所属组织信息
		if(StringUtil.isNotEmpty(entity.getTmOrg())) {
			vo.setOrgId(entity.getTmOrg().getId());
			vo.setOrgName(entity.getTmOrg().getOrgName());
		}
		return vo;
	}

}
