package com.biz.eisp.mdm.position.transformer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.PinyinUtil;
import com.biz.eisp.mdm.actrole.entity.TmActRoleEntity;
import com.biz.eisp.mdm.actrole.entity.TmRPositionActRoleEntity;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.entity.TmRPositionRoleEntity;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.google.common.base.Function;

/** 转换职位Vo对象为Po对象.
 * <p>
 * @author liukai
 * @version v1.0
 */
public class TmPositionVoToTmPositionEntity implements Function<TmPositionVo, TmPositionEntity>, Serializable{

	private static final long serialVersionUID = 1L;

	public TmPositionVoToTmPositionEntity(TmPositionService tmPositionService) {
		this.tmPositionService = tmPositionService;
	}
	
	private TmPositionService tmPositionService; //职位Service接口
	
	@Override
	public TmPositionEntity apply(TmPositionVo vo) {
		TmPositionEntity entity = new TmPositionEntity();
		if(StringUtil.isNotEmpty(vo.getId())){
			entity = tmPositionService.get(TmPositionEntity.class, vo.getId());
			if(entity==null){
				throw new BusinessException("查询职位信息出错 ");
			}
		}
		if(StringUtil.isNotEmpty(vo.getPositionCode())){
			entity = tmPositionService.findUniqueByProperty(TmPositionEntity.class,"positionCode",vo.getPositionCode());
		}

		if(entity==null){
			entity=new TmPositionEntity();
		}

		if(!StringUtil.isNotEmpty(vo.getEnableStatus())){
			vo.setEnableStatus(Globals.ZERO);
		}
		//验证非空
		if(StringUtil.isEmpty(vo.getPositionName())){
			throw new BusinessException("职位名称不能为空");
		}	
		vo.setHeadString(PinyinUtil.getPinYinHeadChar(vo.getPositionName())); 
		try {
//			MyBeanUtils.copyBeanNotNull2Bean(vo, entity);
			copyProperties(vo, entity);
			//查询组织对象
			if(StringUtils.isNotBlank(vo.getOrgId())) {
				TmOrgEntity tmOrgEntity = tmPositionService.get(TmOrgEntity.class, vo.getOrgId());
				if(tmOrgEntity == null) {
					tmOrgEntity=tmPositionService.findUniqueByProperty(TmOrgEntity.class,"orgCode", vo.getOrgId());
					if(tmOrgEntity==null){
						throw new BusinessException("转换职位Vo到Po时，所属组织找不到:" + vo.getOrgId());
					}
				}
				entity.setTmOrg(tmOrgEntity);
			}
			//设置上级
			if(StringUtil.isNotEmpty(vo.getParentId())){
				TmPositionEntity positionEntity = tmPositionService.get(TmPositionEntity.class, vo.getParentId());
				if(positionEntity == null) {//如果为空则有可能为导入  导入为编码 页面新增为id
					positionEntity=tmPositionService.findUniqueByProperty(TmPositionEntity.class,"positionCode",vo.getParentId());
					if(positionEntity==null){
						throw new BusinessException("转换职位Vo到Po时，上级职位找不到:" + vo.getParentId());
					}
				}
				entity.setTmPosition(positionEntity);
			}
			//设置权限角色
//			if(StringUtil.isNotEmpty(vo.getRoleIds())){
				String roleIds = vo.getRoleIds();
				List<TmRPositionRoleEntity> tmPositionRoleList = this.getTmPositionRoleList(entity, roleIds);
				entity.setTmPositionRoleList(tmPositionRoleList);
//			}
			//设置工作流角色
//			if(StringUtil.isNotEmpty(vo.getWorkflowRoleIds())){
				String workFlowRoleIds = vo.getWorkflowRoleIds();
				List<TmRPositionActRoleEntity> tmPositionActRoleList = this.getTmPositionActRoleList(entity, workFlowRoleIds);
				entity.setTmRPositionActRoleList(tmPositionActRoleList);
//			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return entity;
	}
	
	private void copyProperties(TmPositionVo vo, TmPositionEntity entity) {
		entity.setBusinessGroup(vo.getBusinessGroup());
		entity.setEnableStatus(vo.getEnableStatus());
		entity.setExtChar1(vo.getExtChar1());
		entity.setExtChar2(vo.getExtChar2());
		entity.setExtChar3(vo.getExtChar3());
		entity.setExtChar4(vo.getExtChar4());
		entity.setExtChar5(vo.getExtChar5());
		entity.setExtDate1(vo.getExtDate1());
		entity.setExtDate2(vo.getExtDate2());
		entity.setExtNumber1(vo.getExtNumber1());
		entity.setExtNumber2(vo.getExtNumber2());
		entity.setExtNumber3(vo.getExtNumber3());
		entity.setHeadString(vo.getHeadString());
		entity.setPositionCode(vo.getPositionCode());
		entity.setPositionLevel(vo.getPositionLevel());
		entity.setPositionName(vo.getPositionName());
	}
	
	/**
	 * 获取职位和权限角色的关系.
	 * @author grover
	 * @param tmPositionEntity 职位
	 * @param roleIds 权限角色ids
	 * @return 职位和角色的关系
	 */
	public List<TmRPositionRoleEntity> getTmPositionRoleList(TmPositionEntity tmPositionEntity, String roleIds) {
		List<TmRPositionRoleEntity> list = new ArrayList<TmRPositionRoleEntity>();
		if(StringUtil.isNotEmpty(roleIds)){
			String hql="from TmRPositionRoleEntity WHERE tmPosition.id=? AND tmRole.id=?";
			for (String roleId : roleIds.split(",")) {
				TmRoleEntity tmRoleEntity=tmPositionService.get(TmRoleEntity.class, roleId);
				if(tmRoleEntity==null){//如果为空则为导入  导入为编码 页面新增为id
					tmRoleEntity=tmPositionService.findUniqueByProperty(TmRoleEntity.class, "roleCode",roleId);
					if(tmRoleEntity==null){
						throw new BusinessException("角色不存在");
					}
				}

				TmRPositionRoleEntity tmRPositionRoleEntity = tmPositionService
						.getUniqueByHql(TmRPositionRoleEntity.class, hql,
								tmPositionEntity.getId(), tmRoleEntity.getId());
				if(tmRPositionRoleEntity == null){
					tmRPositionRoleEntity = new TmRPositionRoleEntity();
					tmRPositionRoleEntity.setTmPosition(tmPositionEntity);
					tmRPositionRoleEntity.setTmRole(tmRoleEntity);
				}
				list.add(tmRPositionRoleEntity);
			}
		}
		return list;
	}
	/**
	 * 获取职位和工作流角色的关系.
	 * @author grover
	 * @param tmPositionEntity 职位
	 * @param workFlowRoleIds 工作流角色ids
	 * @return 职位和工作流角色的关系
	 */
	public List<TmRPositionActRoleEntity> getTmPositionActRoleList(TmPositionEntity tmPositionEntity, String workFlowRoleIds) {
		List<TmRPositionActRoleEntity> list = new ArrayList<TmRPositionActRoleEntity>();
		if(StringUtil.isNotEmpty(workFlowRoleIds)){
			String hql="from TmRPositionActRoleEntity WHERE tmPosition.id=? AND tmActRole.id=?";
			for (String workFlowRoleId : workFlowRoleIds.split(",")) {
				TmActRoleEntity tmActRoleEntity=tmPositionService.get(TmActRoleEntity.class, workFlowRoleId);
				if(tmActRoleEntity==null){//如果为空则为导入  导入为编码 页面新增为id
					tmActRoleEntity=tmPositionService.findUniqueByProperty(TmActRoleEntity.class, "roleCode",workFlowRoleId);
					if(tmActRoleEntity==null){
						throw new BusinessException("工作流角色不存在");
					}
				}
				TmRPositionActRoleEntity tmRPositionActRoleEntity = tmPositionService
						.getUniqueByHql(TmRPositionActRoleEntity.class, hql,
								tmPositionEntity.getId(), workFlowRoleId);
				if(tmRPositionActRoleEntity == null){
					tmRPositionActRoleEntity = new TmRPositionActRoleEntity();
					tmRPositionActRoleEntity.setTmPosition(tmPositionEntity);
					tmRPositionActRoleEntity.setTmActRole(tmActRoleEntity);
				}
				list.add(tmRPositionActRoleEntity);
			}
		}
		return list;
	}
}
