package com.biz.eisp.mdm.product.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.biz.eisp.mdm.product.service.TmProductFormExtendService;
import com.biz.eisp.mdm.product.service.TmProductMainExtendService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.product.entity.TmProductEntity;
import com.biz.eisp.mdm.product.service.TmProductService;
import com.biz.eisp.mdm.product.vo.ProductExcelVo;
import com.biz.eisp.mdm.product.vo.TmProductVo;


/**
 * 产品控制器.
 * @author wan
 * @version v1.0
 */
@Controller
@RequestMapping("/tmProductController")
public class TmProductController extends BaseController{
	/**
	 * 产品服务层注入
	 */
	@Autowired
	TmProductService tmProductService;

	@Autowired(required=false)
	private TmProductFormExtendService tmProductFormExtendService;

	@Autowired(required=false)
	private TmProductMainExtendService tmProductMainExtendService;

	/**
	 * 跳转产品页面.
	 * @author wan
	 * @param request 请求对象
	 * @return 产品主界面
	 */
	@RequestMapping(value = "goTmProductMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTmProductMain(HttpServletRequest request) {
		request.setAttribute("extendTableName",Globals.TABLE_PRODUCT);
		if(tmProductMainExtendService!=null){
			request.setAttribute("includeJSP", tmProductMainExtendService.includeJsp());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmProduct/tmProductMain");
	}
	/**
	 * 产品业务标签弹出跳转.
	 * @author grover
	 * @param productVo 产品vo
	 * @param singleSelect 是否单选
	 * @return
	 */
	@RequestMapping(value = "goProductSearch",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goProductSearch(TmProductVo productVo,String singleSelect,String searchUrl) {
		ModelAndView view = new ModelAndView("com/biz/eisp/mdm/tmProduct/tmProductSearchMain");
		view.addObject("extendTableName",Globals.TABLE_PRODUCT);
		view.addObject("vo", productVo);
		if(StringUtil.isEmpty(searchUrl)){
			searchUrl="tmProductController.do?findTmProductDatagridList";
		}
		view.addObject("searchUrl", searchUrl);
		view.addObject("singleSelect", singleSelect);
		return view;
	}
	/**
	 * 跳转产品选择页面.
	 * @author wan
	 * @param request 请求对象
	 * @return 产品选择界面
	 */
	@RequestMapping(value = "goTmProductSelectMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmProductSelectMain(HttpServletRequest request) {
		return new ModelAndView("com/biz/eisp/mdm/tmProduct/tmProductSelectMain");
	}
	/**
	 * 产品新增页面.
	 * <p>跳转产品新增页面
	 * @author wan
	 * @param request 请求对象
	 * @param tba 产品vo对象
	 * @return 产品新增页面
	 */
	@RequestMapping(value = "goTmProductAddForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmProductAddForm(HttpServletRequest request, TmProductVo tmProduct) {
		//表单类型0新增1编辑2查看
		String optype=request.getParameter("optype");
		request.setAttribute("optype", optype);
		
		
		//动态表单参数 表名
		request.setAttribute("extendTableName",Globals.TABLE_PRODUCT);
		
		if(StringUtil.isNotEmpty(tmProduct.getId())){
			TmProductVo vo = tmProductService.getTmProductVo(tmProduct.getId());
			request.setAttribute("pro", vo);
		}

		if(tmProductFormExtendService!=null){
			request.setAttribute("includeJSP", tmProductFormExtendService.includeJsp());
		}

		return new ModelAndView("com/biz/eisp/mdm/tmProduct/tmProductForm");
	}
	
	
	@RequestMapping(value = "findTmProductList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public List<TmProductVo> findTmProductList(HttpServletRequest request, TmProductVo productVo) {
		List<TmProductVo> voList = tmProductService.findTmProductList(productVo);
		return voList;
	}
	@RequestMapping(value = "findTmProductDatagridList",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public List<TmProductVo> findTmProductDatagridList(HttpServletRequest request, TmProductVo productVo) {
		Page page = new EuPage(request);
		if(StringUtil.isNotEmpty(productVo.getSearchParam())){
			productVo.setText(productVo.getSearchParam());
		}
		List<TmProductVo> voList = tmProductService.findTmProductSearchList(productVo,page);
		return voList;
	}
	/**
	 * 产品弹出业务标签查询.
	 * @author grover
	 * @param request 请求对象
	 * @param productVo 产品vo
	 * @return
	 */
	@RequestMapping(value = "getProductBySearchList",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public AjaxJson getProductBySearchList(HttpServletRequest request, TmProductVo productVo) {
		AjaxJson j = new AjaxJson();
		Map<String, Object> map = new HashMap<String, Object>();
		Page page = new EuPage(request);
		try {
			if (StringUtil.isNotEmpty(productVo.getSearchParam())) {
				productVo.setText(productVo.getSearchParam());
			}
			
			List<TmProductVo> voList = tmProductService
					.findTmProductSearchList(productVo, page);
			map.put("totle", voList.size());
			j.setObj(voList);
		} catch (Exception e) {
			j.setSuccess(false);
			map.put("totle", 0);
			e.printStackTrace();
		}
		j.setAttributes(map);
		return j;
	}
	
	/**
	 * 查询产品数据列表ComboTree形式.
	 * @param tmProductVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "findTmProductComboTree",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public List <TmProductVo> findTmProductComboTree(TmProductVo tmProductVo, HttpServletRequest request) {
		List <TmProductVo> voList = tmProductService.findTmProductComboTree(tmProductVo, request.getParameter("selfId"));
		return voList;
	}
	
	/**
	 * 选择产品列表.从tmBusinessAreaSelectMain.jsp页面发来的请求
	 * @author wan
	 * @param request 请求对象
	 * @param tba 产品vo对象
	 */
	@RequestMapping(value = "findProductSelectGrid",method = {RequestMethod.GET,RequestMethod.POST})
	public void findProductSelectGrid(HttpServletRequest request,HttpServletResponse response ,ProductExcelVo pro) {
		Page page = new EuPage(request);
		List<TmProductEntity> list = tmProductService.findProductSelectGrid(request, pro);
		this.datagridReturn(response, list, page);
	}
	
	/**
	 * 获取上级产品.
	 * <p>获取上级产品的方法
	 * @author wan
	 * @param request 请求对象
	 * @param tba 产品vo对象
	 * @return 下拉树
	 */
	@RequestMapping(value = "getParentProduct",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public List<ComboTree> getParentProduct(HttpServletRequest request, ComboTree comboTree,ProductExcelVo pro) {
		String selfId=request.getParameter("selfId");
		return tmProductService.getParentProduct(comboTree,pro,selfId);
	}
	/**
	 * 获取上级产品.
	 * <p>获取上级产品的方法(无自身节点)
	 * @author wuzhujun
	 * @param request 请求对象
	 * @param tba 产品vo对象
	 * @return 下拉树
	 */
	@RequestMapping(value = "getParentProducts",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public List<ComboTree> getParentProducts(HttpServletRequest request, ComboTree comboTree,ProductExcelVo pro) {
		return tmProductService.getParentProducts(comboTree,pro,request);
	}
	/**
	 * 保存编辑.
	 * @param orgVo 产品vo对象
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "saveOrUpdateProduct", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveOrUpdateProduct(HttpServletRequest request, TmProductVo pro) {
		AjaxJson j = new AjaxJson();
		try {
			Page page = new EuPage(request);
			//保存数据
			tmProductService.saveOrUpdateProduct(pro, page);
			//更新叶子节点
			tmProductService.updateIsLeafColumn(Globals.TABLE_PRODUCT);
			
			//设置编码和名称，用于保存后进行查询操作
			Map <String, Object>attributes = new HashMap<String, Object>();
			attributes.put("productCode", pro.getProductCode());
			attributes.put("productName", pro.getProductName());
			j.setAttributes(attributes);
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("操作失败：" + e.getMessage());
			e.printStackTrace();
		}
		return j;
	}
	/**
	 * 删除产品.
	 * @author wan
	 * @param ids 产品ids
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "delProduct", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson delProduct(String ids) {
		AjaxJson j = new AjaxJson();
		try {
			j = tmProductService.delProduct(ids);
			tmProductService.updateIsLeafColumn(Globals.TABLE_PRODUCT);
		}catch(Exception e) {
			e.printStackTrace();
			j.setMsg("删除失败:" + e.getMessage());
		}
		return j;
	}
	/**
	 * 验证重复Name.
	 * @author wuzhujun
	 * @param 验证对象
	 * @param tba 产品vo对象
	 */
	@RequestMapping(value = "validateProductName",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public ValidForm validateProductName(HttpServletRequest request,ProductExcelVo pro) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		//验证
		if(StringUtil.isNotEmpty(pro.getId())){
			//修改
			if(tmProductService.validate(pro.getId(), param, "productName")){
				validForm.setStatus("n");
				validForm.setInfo("产品名称已存在");
			}
		}else{
			//新增
			if(tmProductService.validate(null, param, "productName")){
				validForm.setStatus("n");
				validForm.setInfo("产品名称已存在");
			}
		}
		return validForm;
	}
	/**
	 * 验证重复Code.
	 * @author wuzhujun
	 * @param 验证对象
	 * @param tba 产品vo对象
	 */
	@RequestMapping(value = "validateProductCode",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public ValidForm validateProductCode(HttpServletRequest request,ProductExcelVo pro) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		//验证
		if(StringUtil.isNotEmpty(pro.getId())){
			//修改
			if(tmProductService.validate(pro.getId(), param, "productCode")){
				validForm.setStatus("n");
				validForm.setInfo("产品名称已存在");
			}
		}else{
			//新增
			if(tmProductService.validate(null, param, "productCode")){
				validForm.setStatus("n");
				validForm.setInfo("产品编码已存在");
			}
		}
		return validForm;
	}

	/**
	 * 启用数据.
	 * <p>
	 * @param tmBusinessAreaVo
	 * @return
	 */
	@RequestMapping(value = "startTmProduct", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson startTmProduct(TmProductVo tmProductVo){
		try {
			tmProductVo.setEnableStatus(0);
			tmProductService.updateProductEnableStatus(tmProductVo);
			return new AjaxJson();
		} catch(Exception e) {
			e.printStackTrace();
			return new AjaxJson(e.getMessage());
		}
	}
	
	/**
	 * 停用数据.
	 * <p>
	 * @param tmBusinessAreaVo
	 * @return
	 */
	@RequestMapping(value = "stopTmProduct", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson stopTmBusinessArea(TmProductVo tmProductVo){
		try {
			tmProductVo.setEnableStatus(1);
			tmProductService.updateProductEnableStatus(tmProductVo);
			return new AjaxJson();
		} catch(Exception e) {
			e.printStackTrace();
			return new AjaxJson(e.getMessage());
		}
		
	}
	
	/**
	 * 导出excel
	 * @param pro
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "exportXls", method = {RequestMethod.GET, RequestMethod.POST})
	public void exportXls(TmProductVo productVo, HttpServletRequest request, HttpServletResponse response) {
		productVo.setExportExcel("true");
		List<TmProductVo> ProductVoList = tmProductService.findTmProductList(productVo);
		doExportXls(response, request, ProductVoList, TmProductVo.class, "产品层级列表");
	}
	
}
