package com.biz.eisp.mdm.product.dao;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.mdm.product.vo.ProductExcelVo;
import com.biz.eisp.mdm.product.vo.TmProductVo;

/** 
 * 产品层级InterfaceDao.
 * @author grover
 * @version v1.0
 */
@InterfaceDao
public interface TmProductDao {
	
	/**
	 * 获取所有可能查询产品的方式.
	 * @author grover
	 * @param productVo 查询产品vo
	 * @param page 分页对象
	 * @return 产品vo信息
	 */
	@Arguments({"productVo","page"})
	@ResultType(ProductExcelVo.class)
	List <ProductExcelVo> findTmProductAllPossible(ProductExcelVo productVo, Page page);
	/**
	 * excel数据.
	 * @author grover
	 * @param productVo 查询产品vo
	 * @return 产品vo信息
	 */
	@Arguments({"productVo"})
	@ResultType(ProductExcelVo.class)
	List <ProductExcelVo> findTmExcelProduct(ProductExcelVo productVo);
	
	@Arguments({"productVo","fields","conditions"})
	@ResultType(TmProductVo.class)
	List <TmProductVo> findNodeProductList(TmProductVo productVo, String fields, String conditions);
	
	
	@Arguments({"productVo","fields","conditions"})
	@ResultType(TmProductVo.class)
	List<TmProductVo> findQueryProductList(TmProductVo productVo, String fields, String conditions);
}
