package com.biz.eisp.mdm.product.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Where;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;

/** 产品实体.
 * @author wan
 * @version v1.0
 */
@Entity
@Table(name = "tm_product")
public class TmProductEntity extends IdEntity implements Serializable,Loggerable{
	private static final long serialVersionUID = 1L;
	
	/**
	 * 产品层级名称
	 */
	private String productName;
	
	/**
	 * 产品层级编码
	 */
	private String productCode;
	/**
	 * 产品层级
	 */
	private String productLevel;
	/**
	 * 产品属性1
	 */
	private String productAttribute1;
	/**
	 * 产品属性2
	 */
	private String productAttribute2;
	/**
	 * 产品属性3
	 */
	private String productAttribute3;
	/**
	 * 产品属性4
	 */
	private String productAttribute4;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 创建人
	 */
	private String createName;
	/**
	 * 更新时间
	 */
	private Date updateDate;
	/**
	 * 更新人
	 */
	private String updateName;
	/**
	 * 状态 0启用 1停用
	 */
	private Integer enableStatus;
	/**
	 * 是否叶子节点
	 */
	private Integer isLeaf;
	/**
	 * 产品
	 */
	private TmProductEntity  product;
	/**
	 * 上级产品
	 */
	private List<TmProductEntity> tmProductList;
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品名称
	 */
	@Column(name = "product_name")
	public String getProductName() {
		return productName;
	}
	/**
	 * 方法:取得 com.biz.eisp.mdm.product.entity.TmProductEntity
	 * @return com.biz.eisp.mdm.product.entity.TmProductEntity 父级产品
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "parent_id")
	public TmProductEntity getProduct() {
		return product;
	}
	/**
	 * 方法：取得java.util.List<com.biz.eisp.mdm.product.entity.TmProductEntity>
	 * @return java.util.List<com.biz.eisp.mdm.product.entity.TmProductEntity> 下级产品列表
	 */
	@OneToMany(cascade = CascadeType.ALL,fetch = FetchType.EAGER,mappedBy = "product")
	@Where(clause="enable_status=0")
	@Fetch(FetchMode.SUBSELECT)
	public List<TmProductEntity> getTmProductList() {
		return tmProductList;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品编码
	 */
	@Column(name = "product_code")
	public String getProductCode() {
		return productCode;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品层级
	 */
	@Column(name = "product_level")
	public String getProductLevel() {
		return productLevel;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品属性1
	 */
	@Column(name = "product_attribute1")
	public String getProductAttribute1() {
		return productAttribute1;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品属性2
	 */
	@Column(name = "product_attribute2")
	public String getProductAttribute2() {
		return productAttribute2;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品属性3
	 */
	@Column(name = "product_attribute3")
	public String getProductAttribute3() {
		return productAttribute3;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品属性4
	 */
	@Column(name = "product_attribute4")
	public String getProductAttribute4() {
		return productAttribute4;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品备注
	 */
	@Column(name = "remark")
	public String getRemark() {
		return remark;
	}
	@Column(name = "create_date",nullable = false)
	public Date getCreateDate() {
		return createDate;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 创建人
	 */
	@Column(name = "create_name")
	public String getCreateName() {
		return createName;
	}
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 创建时间
	 */
	@Column(name = "update_date")
	public Date getUpdateDate() {
		return updateDate;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 更新人
	 */
	@Column(name = "update_name")
	public String getUpdateName() {
		return updateName;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 状态
	 */
	@Column(name = "enable_status")
	public Integer getEnableStatus() {
		return enableStatus;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 产品名称
	 */
	public void setProductName(String productName) {
		this.productName = productName;
	}
	/**
	 * 方法:设置 com.biz.eisp.mdm.product.entity.TmProductEntity
	 * @param  com.biz.eisp.mdm.product.entity.TmProductEntity 上级产品
	 */
	public void setProduct(TmProductEntity product) {
		if(product != null && product.getId().equals(id)) {
			throw new BusinessException("上级产品不能选择当前产品");
		}
		this.product = product;
	}
	/**
	 * 方法:设置java.util.List< com.biz.eisp.mdm.product.entity.TmProductEntity>
	 * 
	 * @param java.util.List< com.biz.eisp.mdm.product.entity.TmProductEntity> 下级产品列表
	 */
	public void setTmProductList(List<TmProductEntity> tmProductList) {
		this.tmProductList = tmProductList;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 产品编码
	 */
	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 产品层级
	 */
	public void setProductLevel(String productLevel) {
		this.productLevel = productLevel;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 产品属性1
	 */
	public void setProductAttribute1(String productAttribute1) {
		this.productAttribute1 = productAttribute1;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 产品属性2
	 */
	public void setProductAttribute2(String productAttribute2) {
		this.productAttribute2 = productAttribute2;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 产品属性3
	 */
	public void setProductAttribute3(String productAttribute3) {
		this.productAttribute3 = productAttribute3;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 产品属性4
	 */
	public void setProductAttribute4(String productAttribute4) {
		this.productAttribute4 = productAttribute4;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 产品备注
	 */
	public void setRemark(String remark) {
		this.remark = remark;
	}
	/**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 创建人
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	/**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 更新日期
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 更新人
	 */
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 状态
	 */
	public void setEnableStatus(Integer enableStatus) {
		this.enableStatus = enableStatus;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 是否是叶子节点
	 */
	@Column(name = "is_leaf")
	public Integer getIsLeaf() {
		return isLeaf;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 是否叶子节点
	 */
	public void setIsLeaf(Integer isLeaf) {
		this.isLeaf = isLeaf;
	}
	@Override
	public String businessDesc() {
		return "产品基本信息";
	}
	@Override
	public String addLogContent() {
		return null;
	}
	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		return null;
	}
	
}
