package com.biz.eisp.mdm.product.service;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.product.entity.TmProductEntity;
import com.biz.eisp.mdm.product.vo.ProductExcelVo;
import com.biz.eisp.mdm.product.vo.TmProductVo;

/** 
 * 产品 服务层接口.
 * @author wan
 * @version v1.0
 */
public interface TmProductService extends BaseService{
	/**
	 * 获取产品层级vo对象信息.
	 * @author wuzhujun
	 * @param id
	 * @return
	 */
	public TmProductVo getTmProductVo(String id);
	/**
	 * 获取产品grid列表.
	 * <p>获取产品grid列表接口定义.
	 * @author wan
	 * @param request 请求对象
	 * @param treeGrid 树对象
	 * @param pro 产品vo
	 * @return 树json模型
	 */
	List<TmProductEntity> findProductSelectGrid(HttpServletRequest request, ProductExcelVo pro);
	/**
	 * 上级产品下拉树.
	 * <p>获取下拉产品树的接口方法定义
	 * @author wan
	 * @param pro 产品vo对象
	 * @param comboTree 下拉树对象
	 * @return 下拉树模型
	 */
	List<ComboTree> getParentProduct(ComboTree comboTree,ProductExcelVo pro,String selfId);
	/**
	 * 上级产品下拉树.
	 * <p>获取下拉产品树的接口方法定义
	 * @author wan
	 * @param pro 产品vo对象
	 * @param comboTree 下拉树对象
	 * @return 下拉树模型
	 */
	public List<ComboTree> getParentProducts(ComboTree comboTree, ProductExcelVo pro,HttpServletRequest request);
	/**
	 * 保存产品.
	 * <p>保存产品接口的定义
	 * @author wan
	 * @param pro 组织vo对象
	 * @param page 页面对象
	 */
	void saveOrUpdateProduct(TmProductVo pro, Page page);
	/**
	 * 删除产品.
	 * @author wan
	 * @param ids 产品ids
	 * @return 成功或者失败
	 */
	AjaxJson delProduct(String id);
	/**
	 * 产品层级excel导出集合
	 * @author wuzhujun
	 * @param request
	 * @param pro
	 * @return
	 */
	List<ProductExcelVo> findExcelList(HttpServletRequest request, ProductExcelVo pro);
	
	/**
	 * 产品相关接口 - 主要对外.
	 * <p>该接口提供了所有可能查询产品的方式.<br>
	 * 0、无参数 areaName产品名称，areaCode产品编码 模糊查询.<br>
	 * 1、当前产品层级信息 所需参数：id产品id.<br>
	 * 2、下级产品层级信息 所需参数：levelId产品id.<br>
	 * 3、上级产品层级信息 所需参数：parentId产品id.<br>
	 * 4、某一层级产品层级信息 所需参数：areaLevel产品级别.<br>
	 * @author grover
	 * @param productVo 查询方式vo
	 * @param page 分页对象 如果不分页传入一个null
	 * @return  产品vo集合
	 */
	List<ProductExcelVo> findTmProductAllPossible(ProductExcelVo productVo, Page page);
	
	List <TmProductVo> findTmProductList(TmProductVo productVo);
	
	List <TmProductVo> findTmProductSearchList(TmProductVo productVo,Page page);
	
	List <TmProductVo> findTmProductComboTree(TmProductVo productVo, String selfId);
	
	/**
	 *  验证重复的字段
	 * @author wuzhujun
	 * @param fields 字段-值
	 * @return 重复为true 否则为flase
	 */
	public boolean validate(String id,String param,String fieldName);
	
	/**
	 * 更新启动或者停用状态
	 * 
	 * @author wan
	 * @param tbaVo
	 * @return
	 */
	public void updateProductEnableStatus(TmProductVo tmProductVo);
}
