package com.biz.eisp.mdm.product.service.impl;

import java.util.Map;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.product.service.TmProductService;
import com.biz.eisp.mdm.product.vo.TmProductVo;

/**  产品织导入.
 * @author 肖胜
 * @version v1.0
 */
public class TmProdcutEventHandler extends ImpEventHandler <TmProductVo>{
	/**
	 * service注入.
	 */
	private TmProductService tmProductService = 
			(TmProductService) ApplicationContextUtils.getContext().getBean("tmProductService");
	
	@Override
	public void endRow(Map<String, Object> row, TmProductVo bean) throws ValidateException {
		try {
			//保存
			Page page = new EuPage();
			tmProductService.saveOrUpdateProduct(bean, page);
		} catch (Exception e) {
			addError("第"+getRowNumber()+"行遇到错误:"+e.getMessage());
			e.printStackTrace();
		}
		//更新成功条数 
		setSuccNum(getSuccNum()+1);
	}
	
	public void end() {
		//更新叶子节点
		tmProductService.updateIsLeafColumn(Globals.TABLE_PRODUCT);
	}
	
}
