package com.biz.eisp.mdm.product.service.impl;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.product.dao.TmProductDao;
import com.biz.eisp.mdm.product.entity.TmProductEntity;
import com.biz.eisp.mdm.product.service.TmProductExtendService;
import com.biz.eisp.mdm.product.service.TmProductService;
import com.biz.eisp.mdm.product.transformer.TmProductEntityToTmProductVo;
import com.biz.eisp.mdm.product.transformer.TmProductVoToTmProductEntity;
import com.biz.eisp.mdm.product.vo.ProductExcelVo;
import com.biz.eisp.mdm.product.vo.TmProductVo;
import com.google.common.collect.Lists;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author wan
 * @version v1.0
 */
@SuppressWarnings("deprecation")
@Service("tmProductService")
@Transactional
public class TmProductServiceImpl extends BaseServiceImpl implements TmProductService{
	/**
	 * 注入dao.
	 */
	@Autowired
	private TmProductDao tmProductDao;
	/**
	 * 注入产品扩展service.
	 */
	@Autowired(required=false)
	private TmProductExtendService tmProductExtendService;
	
	@Override
	public List<TmProductEntity> findProductSelectGrid(HttpServletRequest request, ProductExcelVo pro) {
		Criterion cr1 = null;
        if (StringUtil.isNotEmpty(pro.getProductName())) {
           cr1 = Restrictions.like("productName", "%"+pro.getProductName()+"%");
        }
        if (StringUtil.isEmpty(pro.getId())) {
        	cr1 = Restrictions.isNull("product");
        } 
        Criterion cr2 = Restrictions.eq("enableStatus", Globals.ZERO);
        List<TmProductEntity> proList = findByCriteria(TmProductEntity.class, cr1,cr2);
		return proList;
	}

	@Override
	public List<ComboTree> getParentProduct(ComboTree comboTree,ProductExcelVo pro,String selfId) {
		List<TmProductEntity> proList = new ArrayList<TmProductEntity>();
		Criterion cr1 = null;
		
		if(StringUtil.isNotEmpty(selfId)){
			proList = findByProperty(TmProductEntity.class,"id",selfId);
		}else if(StringUtil.isNotEmpty(pro.getId())){
			cr1 = Restrictions.ne("id", pro.getId());
		}
		Criterion cr4 = Restrictions.eq("enableStatus", Globals.ZERO);
		if(StringUtil.isNotEmpty(comboTree.getId())) {
			Criterion cr2 = Restrictions.eq("product.id", comboTree.getId());
			if(StringUtil.isNotEmpty(cr1)){
				proList.addAll(findByCriteria(TmProductEntity.class, cr1, cr2, cr4));
			}else{
				proList.addAll(findByCriteria(TmProductEntity.class, cr2, cr4));
			}
		} else {
			Criterion cr3 = null;
			if(StringUtil.isNotEmpty(pro.getParentId())){
				cr3 = Restrictions.eq("id", pro.getParentId());
			}else{
				cr3 = Restrictions.isNull("product.id");
			}
			if(StringUtil.isNotEmpty(cr1)){
				proList.addAll(findByCriteria(TmProductEntity.class, cr1, cr3, cr4));
			}else{
				proList.addAll(findByCriteria(TmProductEntity.class, cr3, cr4));
			}
		}
		ComboTreeModel comboTreeModel = new ComboTreeModel("id", "productName", "tmProductList");
		List<ComboTree> comboTrees = this.comboTree(proList, comboTreeModel, null, false);
		return comboTrees;
	}

	@Override
	public void saveOrUpdateProduct(TmProductVo pro, Page page) {
		TmProductEntity productEntity = null;
		//保存前扩展 此时entity还未通过vo转换
		if(StringUtil.isNotEmpty(tmProductExtendService)){
			//验证
			try {
				tmProductExtendService.validate(pro, page);
			} catch (Exception e) {
				throw new BusinessException("验证数据失败:"+e.getMessage());
			}
			//扩展
			productEntity  = tmProductExtendService.saveBefore(pro, page);
		}
		//如果entity为null 则使用vo转换
		if(StringUtil.isEmpty(productEntity)){
			//转化对象实例
			TmProductVoToTmProductEntity formPo = new TmProductVoToTmProductEntity(this);
			productEntity = formPo.apply(pro);
		}
		//保存前扩展 此时entity已经通过vo转换
		if(StringUtil.isNotEmpty(productEntity) && tmProductExtendService != null){
			productEntity = tmProductExtendService.saveBefore(productEntity, pro, page);
		}
		//保存或者更新
		saveOrUpdate(productEntity);
		//保存后扩展
		if(StringUtil.isNotEmpty(productEntity) && tmProductExtendService != null){
			productEntity = tmProductExtendService.savePost(productEntity, pro, page);
		}
	}
	@Override
	public AjaxJson delProduct(String ids) {
		AjaxJson j = new AjaxJson();
		String[] proIds = ids.split(",");
		for (String id : proIds) {
			TmProductEntity proEntity = get(TmProductEntity.class, id);
			if(!StringUtil.isNotEmpty(proEntity)){
				j.setSuccess(false);
				j.setMsg("删除失败！");
				return j;
			}else{
				//判断是否有子节点
				if(StringUtil.isNotEmpty(proEntity.getTmProductList())
						&&proEntity.getTmProductList().size()>0){
					j.setSuccess(false);
					j.setMsg("删除失败！【"+proEntity.getProductName()+"】下面有其他产品！");
					return j;
				}
				delete(proEntity);
			}
		}
		j.setMsg("删除成功!");
		return j;
	}

	@Override
	public List<ProductExcelVo> findExcelList(HttpServletRequest request, ProductExcelVo pro) {
		return tmProductDao.findTmExcelProduct(pro);
	}
	
	@Override
	public List<ComboTree> getParentProducts(ComboTree comboTree, ProductExcelVo pro,HttpServletRequest request) {
		String selfId = request.getParameter("selfId");
		List<TmProductEntity> proList = new ArrayList<TmProductEntity>();
		if(StringUtil.isNotEmpty(comboTree.getId())){
			Criterion cr1 = Restrictions.eq("product.id", comboTree.getId());
			proList = findByCriteria(TmProductEntity.class,cr1);
		}else{
			Criterion cr2 = Restrictions.isNull("product.id");
			proList = findByCriteria(TmProductEntity.class,cr2);
		}
		List<TmProductEntity> proList2 = new ArrayList<TmProductEntity>();
		if(StringUtil.isNotEmpty(selfId)){
			for(TmProductEntity p:proList){
				if(p.getId().equals(selfId)){
					continue;
				}
				proList2.add(p);
			}
			ComboTreeModel comboTreeModel = new ComboTreeModel("id", "productName", "products");
			List<ComboTree> comboTrees = this.comboTree(proList2, comboTreeModel, null, false);
			return comboTrees;
		}else{
			ComboTreeModel comboTreeModel = new ComboTreeModel("id", "productName", "products");
			List<ComboTree> comboTrees = this.comboTree(proList, comboTreeModel, null, false);
			return comboTrees;
		}
	}
	
	@Override
	public List<ProductExcelVo> findTmProductAllPossible(ProductExcelVo productVo,
			Page page) {
		return tmProductDao.findTmProductAllPossible(productVo, page);
	}

	@Override
	public boolean validate(String id, String param, String fieldName) {
		Criterion cr1 = Restrictions.eq(fieldName, param);
		List<TmProductEntity> tmprds = new ArrayList<TmProductEntity>();
		if(StringUtil.isNotEmpty(id)){
			Criterion cr2 = Restrictions.ne("id", id);
			tmprds = findByCriteria(TmProductEntity.class, cr1, cr2);
		}else{
			tmprds = findByCriteria(TmProductEntity.class, cr1);
		}
		if(!CollectionUtils.isEmpty(tmprds)){
			return true;
		}
		return false;
	}

	@Override
	public List<TmProductVo> findTmProductList(TmProductVo productVo) {
		//动态sql
		String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_PRODUCT, productVo);
		sql+=" order by t.product_code asc";
		List <TmProductVo> voList = findBySql(TmProductVo.class, sql);
		//如果带查询条件 则组装树形
		if(DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_PRODUCT, productVo)) {
			voList = this.findQueryProductList(productVo, voList);
		}
		return voList;
	}
	
	public List <TmProductVo> findTmProductComboTree(TmProductVo productVo, String selfId) {
		List <TmProductVo> voList = null;
		if(StringUtils.isNotBlank(selfId)) {
			List <TmProductEntity> entityList = this.findByProperty(TmProductEntity.class, "id", selfId);
			voList = Lists.transform(entityList, new TmProductEntityToTmProductVo(this)); 
		} else {
			voList = this.findTmProductList(productVo);
		}
		return voList;
	}
	
	@SuppressWarnings("unchecked")
	private List<TmProductVo> findQueryProductList(TmProductVo productVo, List <TmProductVo> voList) {
		//如果是导出，即不用组装成TreeGrid 带有children的树形截至值，直接返回列表值
		if(productVo.getExportExcel().equals("true")) {
			return voList;
		}
		
		//构造成树状值传回
		List <TmProductVo> allQueryVoList = TreeGridUtil.buildTreeGrid(voList);
		
		return allQueryVoList;
	}

	@Override
	public TmProductVo getTmProductVo(String id) {
		TmProductEntity entity  = get(TmProductEntity.class , id);
		TmProductEntityToTmProductVo transForm = new TmProductEntityToTmProductVo(this);
		TmProductVo vo = transForm.apply(entity);
		return vo;
	}

	@Override
	public List<TmProductVo> findTmProductSearchList(TmProductVo productVo,
			Page page) {
		//动态sql
		String sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_PRODUCT, productVo);
		List <TmProductVo> voList = findBySql(TmProductVo.class, sql);
		return voList;
	}
	
	public void updateProductEnableStatus(TmProductVo tmProductVo) {
		TmProductEntity entity = get(TmProductEntity.class, tmProductVo.getId());		
		entity.setEnableStatus(tmProductVo.getEnableStatus());
		updateEntity(entity);
	}
}
