package com.biz.eisp.mdm.product.transformer;

import org.springframework.beans.BeanUtils;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.product.entity.TmProductEntity;
import com.biz.eisp.mdm.product.service.TmProductService;
import com.biz.eisp.mdm.product.vo.ProductExcelVo;
import com.biz.eisp.mdm.product.vo.TmProductVo;
import com.google.common.base.Function;

/** vo - po
 * <p>讲vo转成实体<br>
 * @author wan
 * @version v1.0
 */
public class TmProductEntityToTmProductVo implements Function<TmProductEntity,TmProductVo>{
	
	private TmProductService productService ;
	public TmProductEntityToTmProductVo(TmProductService productService){
		this.productService = productService;
	}
	@Override
	public TmProductVo apply(TmProductEntity entity) {
		if(entity == null){
			return null;
		}
		TmProductVo productVo = new TmProductVo();
		BeanUtils.copyProperties(entity, productVo);
		
		TmProductEntity parentEntity = entity.getProduct();
		
		if(parentEntity !=null){
			productVo.setParentId(parentEntity.getId());
			productVo.setParentName(parentEntity.getProductName());
			productVo.setParentProductCode(parentEntity.getProductCode());
		}
		productVo.setText(entity.getProductName());
		
		return productVo;
	}
	
}
