package com.biz.eisp.mdm.product.transformer;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.mdm.product.entity.TmProductEntity;
import com.biz.eisp.mdm.product.service.TmProductService;
import com.biz.eisp.mdm.product.vo.TmProductVo;
import com.google.common.base.Function;

import jodd.util.StringUtil;

/** vo - po
 * <p>讲vo转成实体<br>
 * @author wan
 * @version v1.0
 */
public class TmProductVoToTmProductEntity implements Function<TmProductVo, TmProductEntity>{
	private TmProductService productService;
	
	public TmProductVoToTmProductEntity(TmProductService productService){
		this.productService = productService;
	}
	@Override
	public TmProductEntity apply(TmProductVo vo) {
		if(vo == null){
			return null;
		}
		TmProductEntity tmProductEntity  = null;
		//判断是新增还是修改
		if(StringUtil.isNotEmpty(vo.getId())){
			tmProductEntity = productService.get(TmProductEntity.class, vo.getId());
		}else{
			tmProductEntity = new TmProductEntity();
		}
		
		
		//名称非空与重复验证
		if(StringUtil.isNotEmpty(vo.getProductName())){
			if(productService.validate(vo.getId(),vo.getProductName() , "productName")){
//				throw new BusinessException("转换产品层级Vo到Po时，产品层级"+ vo.getProductName()+"已存在" );
			}
		}else{
			throw new BusinessException("产品层级名称不能为空" );
		}
		
		
		//编码非空与重复验证
		if(StringUtil.isNotEmpty(vo.getProductCode())){
			if(productService.validate(vo.getId(),vo.getProductCode() , "productCode")){
				throw new BusinessException("转换产品层级Vo到Po时，产品层级"+ vo.getProductCode()+"已存在" );
			}
		}else{
			throw new BusinessException("产品层级编码不能为空" );
		}
		
		try {
//			MyBeanUtils.copyBeanNotNull2Bean(vo, tmProductEntity);
			copyProperties(vo, tmProductEntity);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		//装载上一级的产品信息
		if(StringUtil.isNotBlank(vo.getParentId())){
			TmProductEntity parnet = productService.get(TmProductEntity.class, vo.getParentId());
			if(parnet == null){
//				throw new BusinessException("转换产品Vo到Po时，上级产品找不到:" +vo.getParentId());
			}
			tmProductEntity.setProduct(parnet);
		}
		
		//导入装载上一级的产品信息 动态数据表单showField字段 传递上级产品code
//		if(StringUtil.isNotBlank(vo.getParentName())){
//			TmProductEntity parentProduct = productService.
//					findUniqueByProperty(TmProductEntity.class,"productName", vo.getParentName());
//			if(parentProduct == null){
//				throw new BusinessException("转换产品Vo到Po时，上级产品找不到:" +vo.getParentName());
//			}
//			tmProductEntity.setProduct(parentProduct);
//		}
		
		tmProductEntity.setEnableStatus(Globals.ZERO);
		return tmProductEntity;
	}
	
	public void copyProperties(TmProductVo vo, TmProductEntity entity) {
		entity.setEnableStatus(vo.getEnableStatus());
		entity.setProductAttribute1(vo.getProductAttribute1());
		entity.setProductAttribute2(vo.getProductAttribute2());
		entity.setProductAttribute3(vo.getProductAttribute3());
		entity.setProductAttribute4(vo.getProductAttribute4());
		entity.setProductCode(vo.getProductCode());
		entity.setProductLevel(vo.getProductLevel());
		entity.setProductName(vo.getProductName());
		entity.setRemark(vo.getRemark());
	}

}
