package com.biz.eisp.mdm.role.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.authobj.service.TmFunAuthService;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.dict.vo.TmDictDataAuVo;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.operation.entity.TmOperationEntity;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.service.TmRoleService;
import com.biz.eisp.mdm.role.vo.TmRoleInfoExportVo;
import com.biz.eisp.mdm.role.vo.TmRoleVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** 
 * 角色控制器.
 * <p>角色相关模块功能
 * @author grovr
 * @version v1.0
 */
@Controller
@RequestMapping("/tMroleController")
public class TmRoleController extends BaseController{
	/**
	 * 权限注入
	 */
	@Autowired
	private TmFunctionService functionService;
	/**
	 * 注入角色service
	 */
	@Autowired
	private TmRoleService tmRoleService;
	/**
	 * 注入权限对象service
	 */
	@Autowired
	private TmFunAuthService tmFunAuthService;
	
	/**  
	 * 角色列表界面.
	 * <p>跳转角色界面的方法
	 * @author grover
	 * @param request 请求对象
	 * @return 角色页面
	 */
	@RequestMapping(value = "goRoleList",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goRoleList(HttpServletRequest request) {
		request.setAttribute("extendTableName",Globals.TABLE_ROLE);
		return new ModelAndView("com/biz/eisp/mdm/role/tmRoleMain");
	}

	/**  
	 * 职位选中角色列表界面.
	 * <p>跳转角色界面的方法
	 * @author grover
	 * @param tmRoleVo 角色vo对象
	 * @param request 请求对象
	 * @return 角色页面
	 */
	@RequestMapping(value = "goTmRoleCheckedMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmRoleCheckedMain(TmRoleVo tmRoleVo,HttpServletRequest request) {
		if(StringUtil.isNotEmpty(tmRoleVo.getPosId())){
			request.setAttribute("posId", tmRoleVo.getPosId());
		}else{
			request.setAttribute("posId", "-1");
		}
		if(StringUtil.isNotEmpty(tmRoleVo.getUserId())){
			request.setAttribute("userId", tmRoleVo.getUserId());
		}else{
			request.setAttribute("userId", "-1");
		}
		return new ModelAndView("com/biz/eisp/mdm/role/tmRoleCheckedMain");
	}
	
	/**
	 * 查询角色列表信息.
	 * <p>
	 * @param request
	 * @param tmRoleVo
	 * @param response
	 */
	@RequestMapping(value = "findRoleList", method = {RequestMethod.GET, RequestMethod.POST})
	public void findRoleList(HttpServletRequest request, TmRoleVo tmRoleVo, HttpServletResponse response) {
		//是否分页
		String pagination = OConvertUtils.getString(request.getParameter("pagination"));
		Page page = new EuPage(request);
		if(StringUtil.isNotEmpty(pagination)){
			page = null;
		}
		//获取角色 并返回
		List<TmRoleEntity> roles = tmRoleService.findRoleList(tmRoleVo, page);
		if(StringUtil.isNotEmpty(pagination)){
			this.datagridReturn(response, roles);
		}else{
			this.datagridReturn(response, roles, page);
		}
	}
	
	/**
	 * 角色列表信息.
	 * <p>根据当前用户职位获取角色列表
	 * @author grover
	 * @param request 请求对象
	 * @param tmRoleVo 角色vo对象
	 */
	@RequestMapping(value = "getRoleListByUserPost", method = {RequestMethod.GET, RequestMethod.POST})
	public void getRoleListByUserPost(HttpServletRequest request, TmRoleVo tmRoleVo, HttpServletResponse response) {
		//是否分页
		String pagination = OConvertUtils.getString(request.getParameter("pagination"));
		Page page = new EuPage(request);
		if(StringUtil.isNotEmpty(pagination)){
			page = null;
		}
		//获取角色 并返回
		List<TmRoleEntity> roles = tmRoleService.getRoleListByCurrentPosId(tmRoleVo, page);
		if(StringUtil.isNotEmpty(pagination)){
			this.datagridReturn(response, roles);
		}else{
			this.datagridReturn(response, roles, page);
		}
	}
	/**
	 * 角色新增编辑界面.
	 * <p>跳转角色新增编辑界面的方法
	 * @author grover
	 * @param request 请求对象
	 * @return 角色新增编辑页面
	 */
	@RequestMapping(value = "goRoleForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goRoleForm(HttpServletRequest request) {
		String id = OConvertUtils.getString(request.getParameter("id"));
		if(StringUtil.isNotEmpty(id)){
			TmRoleEntity roleEntity = tmRoleService.get(TmRoleEntity.class, id);
			request.setAttribute("role", roleEntity);
		}
		
		//表单类型0新增1编辑2查看
		String optype=request.getParameter("optype");
		request.setAttribute("optype", optype);
		
		//动态表单参数 表名
		request.setAttribute("extendTableName",Globals.TABLE_ROLE);
		
		return new ModelAndView("com/biz/eisp/mdm/role/tmRoleForm");
	}
	/**
	 * 检查角色名称.
	 * @author grover
	 * @param tmRoleEntity 角色
	 * @return
	 */
    @RequestMapping(value = "validFormRoleForm", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ValidForm validFormRoleForm(HttpServletRequest request,TmRoleEntity tmRoleEntity) {
    	String param = OConvertUtils.getString(request.getParameter("param"));
    	String flag = OConvertUtils.getString(request.getParameter("flag"));
    	if(StringUtil.isNotEmpty(flag) && flag.equalsIgnoreCase("roleName")){
    		tmRoleEntity.setRoleName(param);
    	}
    	if(StringUtil.isNotEmpty(flag) && flag.equalsIgnoreCase("roleCode")){
    		tmRoleEntity.setRoleCode(param);
    	}
        return tmRoleService.validateTmRoleForm(tmRoleEntity);
    }
	
	/**
	 * 接收新增角色请求
	 * @param tmRoleVo 前端传入的角色信息
	 * @return 返回增加是否成功判断值
	 */
	@RequestMapping(value = "saveRoleForm", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveRoleForm(HttpServletRequest request, TmRoleVo tmRoleVo) {
		AjaxJson j = new AjaxJson();
		try {
			Page page = new EuPage(request);
			tmRoleService.createTmRole(tmRoleVo, page);
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("操作角色失败");
			e.printStackTrace();
		}
		return j;
	}
	
	/**
	 * 接收删除角色请求
	 * @param id 前端传入的角色ID
	 * @return 返回删除是否成功判断值
	 */
	@RequestMapping(value = "delete", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson delete(String id) {
		AjaxJson j = new AjaxJson();
		try {
			if(tmRoleService.deleteTmRole(id)){
				j.setMsg("删除角色成功");
			}else{
				j.setSuccess(false);
				j.setMsg("超级管理员角色不能被删除");
			}
		}catch (Exception e1) {
			j.setSuccess(false);
			j.setMsg("删除失败,该角色已经关联其他数据");
			e1.printStackTrace();
		}
		return j;
	}
	
	/**
	 * 接收修改角色请求
	 * @param tmRole 前端传入的修改之后的角色信息
	 * @return 返回修改是否成功判断值
	 */
	@RequestMapping(value = "update",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public Map<String, Object> update(TmRoleEntity tmRole) {
		Map<String, Object> model = new HashMap<String, Object>();
		Map<String, String> map = tmRoleService.updateTmRole(tmRole);
		if("true".equals(map.get("success"))){
			//修改成功，返回true
			model.put("success", true);
		}else{
			//修改失败返回false，并返回修改失败原因
			model.put("success", false);
			model.put("msg", map.get("msg"));
		}
		return model;
	}
	
	/**
	 * 启用停用
	 * @param tmRoleVo 角色vo对象
	 */
	@RequestMapping(value = "startOrStopRole", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson startOrStopRole(TmRoleVo tmRoleVo) {
		AjaxJson j = new AjaxJson();
		try {
			j = tmRoleService.startOrStopRole(tmRoleVo);
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("操作失败");
			e.printStackTrace();
		}
		return j;
	}
	
	/**
	 * 权限界面.
	 * <p>跳转权限配置界面的方法
	 * @author grover
	 * @param request 请求对象
	 * @return 权限配置页面
	 */
	@RequestMapping(value = "goPermSetting", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goPermSetting(HttpServletRequest request) {
		String roleId = OConvertUtils.getString(request.getParameter("roleId"));
		request.setAttribute("roleId", roleId);
		return new ModelAndView("com/biz/eisp/mdm/role/permSetting");
	}
	/**
	 * 菜单权限列表.
	 * <p>获取当前角色的菜单权限信息
	 * @author grover
	 * @param request 请求对象
	 * @return 菜单数据模型
	 */
    @RequestMapping(value = "getMenuInfoTreeByRole", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<ComboTree> getMenuInfoTreeByRole(HttpServletRequest request, ComboTree comboTree) {
        String roleId = request.getParameter("roleId");
        //查询所有菜单列表 已树形式
        List<ComboTree> trees = functionService.getAllFuncAndHandleCheck(request,comboTree, roleId);
		return trees; 
    }
    /**
     * 获取菜单按钮.
     * <p>通过角色和菜单的关系查询菜单的按钮<br>
     * ,做按钮权限配置
     * @author grover
     * @param request 请求对象
     * @param roleId 角色id
     * @param functionId 菜单id
     * @return 按钮集合信息
     */
    @RequestMapping(value = "getOpetateInfoByRoleFunc", method = {RequestMethod.GET, RequestMethod.POST})
    public void getOpetateInfoByRoleFunc(HttpServletRequest request, 
    		HttpServletResponse response, String roleId, String functionId) {
    	try { 
    		List<TmOperationEntity> operations = functionService.getOptByRoleFunc(roleId, functionId);
    		JSONArray operationsJson = JSONArray.parseArray(JSONObject.toJSONString(operations));
    		sendResponseState(response, true, operationsJson);
		} catch (Exception e) {
			this.message = "获取按钮信息失败";
			e.printStackTrace();
			sendResponseState(response, false, null);
		}
    }
    /**
     * 设置菜单角色权限.
     * <p>设置角色所属的菜单权限方法
     * @author grover
     * @param response 响应对象
     * @param roleId 角色id
     * @param funcIds 菜单集合ids
     */
    @RequestMapping(value = "setFuncRole", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson setFuncRole(HttpServletResponse response, String roleId, String funcIds) {
    	AjaxJson j = new AjaxJson();
    	try { 
    		//1.删除之前存在并且现在移除的关系
    		functionService.delExistFuncRole(roleId, funcIds);
    		//2.保存角色菜单关系
    		functionService.setFuncRole(roleId, funcIds);
    	} catch (Exception e) {
    		j.setMsg("修改菜单权限失败");
    		e.printStackTrace();
    	}
    	return j;
    }
   /**
    * 设置按钮权限.
    * <p>设置角色的菜单按钮权限方法
    * @author grover
    * @param response 响应对象
    * @param opretionIds 按钮ids
    * @param roleId 角色id
    * @param funcId 菜单id
    * @return
    */
    @RequestMapping(value = "setOperateByFuncRole", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson setOperateByFuncRole(HttpServletResponse response,
    		String opretionIds, String roleId, String funcId) {
    	AjaxJson j = new AjaxJson();
    	try { 
    		functionService.setOperateByFuncRole(opretionIds, roleId, funcId);
    	} catch (Exception e) {
    		j.setMsg("修改按钮权限失败");
    		e.printStackTrace();
    	}
    	return j;
    }
    /**
     * 获取权限对象.
     * <p>根据角色和菜单的关系确定权限对象
     * @author grover
     * @param roleId 角色id
     * @param funcId 菜单id
     * @return 数据对象
     */
    @RequestMapping(value = "getAuthObj", method = {RequestMethod.GET, RequestMethod.POST})
    public void getAuthObj(HttpServletResponse response,String roleId , String funcId) {
    	try { 
    		List<TmFunctionAuthVo> authVos = functionService.getAuthObjByFunc(roleId, funcId);
    		JSONArray obj = JSONArray.parseArray(JSONObject.toJSONString(authVos));
    		sendResponseState(response, true, obj);
    	} catch (Exception e) {
    		this.message="获取权限对象失败";
			sendResponseState(response, false, null);
    		e.printStackTrace();
    	}
    }
    /**
     * 获取权限值.
     * <p>根据角色和菜单的关系确定权限值对象
     * @author grover
     * @param roleId 角色id
     * @param funcId 菜单id
     * @param authObj 权限对象
     * @return 数据对象
     */
    @RequestMapping(value = "getAuthObjValue", method = {RequestMethod.GET, RequestMethod.POST})
    public void getAuthObjValue(HttpServletResponse response,String roleId , String funcId, String authObj) {
    	try { 
    		List<TmDictDataAuVo> dataVos = tmFunAuthService.getTmFunAuthValueByRoleFunc(roleId, funcId, authObj);
    		JSONArray obj = JSONArray.parseArray(JSONObject.toJSONString(dataVos));
    		sendResponseState(response, true, obj);
    	} catch (Exception e) {
    		this.message = "获取权限对象值失败";
    		sendResponseState(response, false, null);
    		e.printStackTrace();
    	}
    }
    /**
     * 获取权限值.
     * @author grover
     * @param roleId 角色id
     * @param funcId 菜单id
     * @param authObj 权限对象
     * @param authCodes 权限对象值codes
     * @return 提示
     */
    @RequestMapping(value = "setAuthObjValue", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson setAuthObjValue(String roleId , String funcId, String authObj,String authCodes) {
    	AjaxJson ajaxJson = new AjaxJson();
    	try { 
    		tmFunAuthService.saveFunAuthValue(roleId, funcId, authObj, authCodes);
    	} catch (Exception e) {
    		ajaxJson.setMsg("设置权限值失败");
    		ajaxJson.setSuccess(false);
    		e.printStackTrace();
    	}
		return ajaxJson;
    }

	/**
	 * 跳转排除自己的角色界面
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "goNoSelfRoleMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goNoSelfRoleMain(HttpServletRequest request) {
		return new ModelAndView("com/biz/eisp/mdm/role/noSelfRoleMain");
	}

	/**
	 * 查询排除自己的角色列表
	 * @param request
	 * @param tmRoleVo 角色参数对象
	 * @param selfRoleId  自己的角色id
	 * @return
	 */
	@RequestMapping(value = "findNoSelfRoleList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findNoSelfRoleList(HttpServletRequest request, TmRoleVo tmRoleVo, String selfRoleId) {
		Page page = new EuPage(request);
		List <TmRoleVo>	voList = tmRoleService.findNoSelfRoleList(tmRoleVo, selfRoleId, page);
		return new DataGrid(voList, page);
	}

	/**
	 * 导出excel
	 * @param tmRoleInfoExportVo
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "exportXls", method = {RequestMethod.GET, RequestMethod.POST})
	public void exportXls(TmRoleInfoExportVo tmRoleInfoExportVo, HttpServletRequest request, HttpServletResponse response) {
		List <TmRoleInfoExportVo> voList = tmRoleService.findExportRoleInfoList(tmRoleInfoExportVo);
		doExportXls(response, request, voList, TmRoleInfoExportVo.class, "权限角色列表");
	}
}
