package com.biz.eisp.mdm.role.dao;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.vo.TmRoleInfoExportVo;
import com.biz.eisp.mdm.role.vo.TmRoleVo;

/** 角色持久类.
 * <p>角色相关功能的最终查询实现
 * @author grover
 * @version v1.0
 */
@InterfaceDao
public interface TmRoleDao {
	
	/**
	 * 获取角色信息.
	 * <p>根据当前职位获取有效的角色集合信息
	 * @author grover
	 * @param PosId 职位id
	 * @return 角色集合
	 */
	@ResultType(TmRoleEntity.class)
	@Arguments({"tmRoleVo","page"})
	List<TmRoleEntity> getRoleListByCurrentPosId(TmRoleVo tmRoleVo, Page page);
	
	/**
	 * 查询角色列表.
	 * <p>
	 * @param tmRoleVo
	 * @param page
	 * @return
	 */
	@ResultType(TmRoleEntity.class)
	@Arguments({"tmRoleVo","page"})
	List<TmRoleEntity> findRoleList(TmRoleVo tmRoleVo, Page page);

	/**
	 * 查询排除自己的角色列表
	 * @param tmRoleVo 角色参数对象
	 * @param selfRoleId  自己的角色id
	 * @param page
	 * @return
	 */
	@ResultType(TmRoleVo.class)
	@Arguments({"tmRoleVo","selfRoleId","page"})
	public List<TmRoleVo> findNoSelfRoleList(TmRoleVo tmRoleVo, String selfRoleId, Page page);

	/**
	 * 查询导出角色权限信息列表
	 * @param vo
	 * @return
	 */
	@ResultType(TmRoleInfoExportVo.class)
	@Arguments({"vo"})
	public List <TmRoleInfoExportVo> findExportRoleInfoList(TmRoleInfoExportVo vo);
}
