package com.biz.eisp.mdm.role.entity;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.List;
/**
 * 角色实体.
 * @author grover
 * @version v1.0
 */
@Entity
@Table(name = "tm_role")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)  
public class TmRoleEntity extends IdEntity implements java.io.Serializable,Loggerable {
	private static final long serialVersionUID = 1L;
	/**
	 * 角色编码
	 */
	private String roleCode;
	/**
	 * 角色名称
	 */
	private String roleName;
	/**
	 * 创建时间
	 */
	private java.util.Date createDate;
	/**
	 * 创建人ID
	 */
	private java.lang.String createName;
	/**
	 * 修改时间
	 */
	private java.util.Date updateDate;
	/**
	 * 修改人
	 */
	private java.lang.String updateName;
	/**
	 * 状态 0删除 1正常
	 */
	private Integer enableStatus;
	/**
	 * 修改人
	 */
	private java.lang.String headString;
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 角色名称
	 */
	@Column(name = "role_name", nullable = false)
	public String getRoleName() {
		return this.roleName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 角色名称
	 */
	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 角色编码
	 */
	@Column(name = "role_code")
	public String getRoleCode() {
		return this.roleCode;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 角色编码
	 */
	public void setRoleCode(String roleCode) {
		this.roleCode = roleCode;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  创建时间
	 */
	@Column(name ="create_date",nullable=true)
	public java.util.Date getCreateDate(){
		return this.createDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  创建时间
	 */
	public void setCreateDate(java.util.Date createDate){
		this.createDate = createDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  创建人ID
	 */
	@Column(name ="create_name",nullable=true)
	public java.lang.String getCreateName(){
		return this.createName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  创建人ID
	 */
	public void setCreateName(java.lang.String createName){
		this.createName = createName;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  修改时间
	 */
	@Column(name ="update_date",nullable=true)
	public java.util.Date getUpdateDate(){
		return this.updateDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  修改时间
	 */
	public void setUpdateDate(java.util.Date updateDate){
		this.updateDate = updateDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  修改人ID
	 */
	@Column(name ="update_name",nullable=true)
	public java.lang.String getUpdateName(){
		return this.updateName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  修改人ID
	 */
	public void setUpdateName(java.lang.String updateName){
		this.updateName = updateName;
	}
	/**
	 *方法: 取得 java.lang.Integer
	 *@return: java.lang.Integer 状态
	 */
	@Column(name = "enable_status")
	public Integer getEnableStatus() {
		return enableStatus;
	}
	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer 状态
	 */
	public void setEnableStatus(Integer enableStatus) {
		this.enableStatus = enableStatus;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 状态
	 */
	@Column(name = "headstring")
	public java.lang.String getHeadString() {
		return headString;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 角色名称拼音简写
	 */
	public void setHeadString(java.lang.String headString) {
		this.headString = headString;
	}
	@Override
	public String businessDesc() {
		return "角色基本信息";
	}
	@Override
	public String addLogContent() {
		return null;
	}
	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		String content="";
		for(ModifyObject obj:modifyFieldList){
			if(StringUtil.equals("roleCode", obj.getFieldName())){
				content+="角色编码";
			}
			if(StringUtil.equals("roleName", obj.getFieldName())){
				content+="角色名称";
			}
			if(StringUtil.equals("headString", obj.getFieldName())){
				content+="拼音简写";
			}
			content+="原["+obj.getOldVal()+"],"+"修改为["+obj.getNowVal()+"]</br>";
		}
		return content;
	}
}


