package com.biz.eisp.mdm.role.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
/**
 * 角色与菜单对应关系实体.
 * @author grover
 * @version v1.0
 */
@Entity
@Table(name = "tm_r_role_function")
public class TmRoleFunctionEntity extends IdEntity implements java.io.Serializable {
	private static final long serialVersionUID = 1L;
	
	/**
	 * 操作按钮
	 */
	private String operation;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 创建人ID
	 */
	private String createName;
	/**
	 * 修改时间
	 */
	private Date updateDate;
	/**
	 * 修改人
	 */
	private String updateName;
	/**
	 * 菜单实体关联菜单表id
	 */
	private TmFunctionEntity tmFunction;
	/**
	 * 角色实体关联角色表id
	 */
	private TmRoleEntity tmRole;
	
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 按钮id
	 */
	@Column(name = "operation")
	public String getOperation() {
		return this.operation;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 按钮id
	 */
	public void setOperation(String operation) {
		this.operation = operation;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  创建时间
	 */
	@Column(name ="create_date",nullable=true)
	public java.util.Date getCreateDate(){
		return this.createDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  创建时间
	 */
	public void setCreateDate(java.util.Date createDate){
		this.createDate = createDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  创建人ID
	 */
	@Column(name ="create_name",nullable=true)
	public java.lang.String getCreateName(){
		return this.createName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  创建人ID
	 */
	public void setCreateName(java.lang.String createName){
		this.createName = createName;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  修改时间
	 */
	@Column(name ="update_date",nullable=true)
	public java.util.Date getUpdateDate(){
		return this.updateDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  修改时间
	 */
	public void setUpdateDate(java.util.Date updateDate){
		this.updateDate = updateDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  修改人ID
	 */
	@Column(name ="update_name",nullable=true)
	public java.lang.String getUpdateName(){
		return this.updateName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  修改人ID
	 */
	public void setUpdateName(java.lang.String updateName){
		this.updateName = updateName;
	}
	/**
	 *方法: 取得 com.biz.eisp.base.common.tag.bean.TmMenuFunctionEntity
	 *@return: com.biz.eisp.base.common.tag.bean.TmMenuFunctionEntity 菜单实体
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "function_id")
	public TmFunctionEntity getTmFunction() {
		return this.tmFunction;
	}
	/**
	 *方法: 设置 com.biz.eisp.base.common.tag.bean.TmMenuFunctionEntity
	 *@param: com.biz.eisp.base.common.tag.bean.TmMenuFunctionEntity菜单实体
	 */
	public void setTmFunction(TmFunctionEntity tmFunction) {
		this.tmFunction = tmFunction;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.role.entity.TmRoleEntity
	 *@return: com.biz.eisp.mdm.role.entity.TmRoleEntity 角色实体
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "role_id")
	public TmRoleEntity getTmRole() {
		return this.tmRole;
	}
	/**
	 *方法: 设置com.biz.eisp.mdm.role.entity.TmRoleEntity
	 *@param: com.biz.eisp.mdm.role.entity.TmRoleEntity 角色实体
	 */
	public void setTmRole(TmRoleEntity tmRole) {
		this.tmRole = tmRole;
	}
}

