package com.biz.eisp.mdm.role.service;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.vo.TmRoleVo;

/**
 * 角色保存或者编辑时的接口扩展定义.
 * <p>
 * 角色保存或者编辑时的接口,如需扩展则需实现该接口.
 * @author grover
 * @version v1.0
 */
public interface TmRoleExtendService extends BaseService{

	/**
	 * 验证保存数据.
	 * <p>
	 * 
	 * @param vo
	 * @param page
	 * @return 验证失败throw new BusinessException("失败内容")
	 */
	public void validate(TmRoleVo vo, Page page);

	/**
	 * 保存角色信息前操作(并且没有做Vo到Entity的转换操作).
	 * <p>
	 * 返回null即保存前不做任何操作。 返回Entity后，系统即保存返回的Entity。不再做Vo转换到Entity的操作。
	 * @param vo
	 *            vo对象值
	 * @param page
	 *            页面对象
	 * @return 返回null即保存前不做任何操作。 返回Entity后，系统即保存返回的Entity。不再做Vo转换到Entity的操作。
	 */
	public TmRoleEntity saveBefore(TmRoleVo vo, Page page);

	/**
	 * 保存角色信息前操作（已经做了Vo到Entity的转换操作）.
	 * <p>
	 * 
	 * @param entity
	 *            Vo转换成Entity的值，该Entity，如果是新增操作即为游离态，修改操作即为持久态
	 * @param vo
	 *            vo对象值
	 * @param page
	 *            页面对象
	 * @return 返回Entity后，系统即保存返回的Entity。
	 */
	public TmRoleEntity saveBefore(TmRoleEntity entity, TmRoleVo vo, Page page);

	/**
	 * 保存角色后操作.
	 * <p>
	 * 
	 * @param entity
	 *            保存后的Entity对象，该Entity状态为持久态
	 * @param vo
	 *            vo对象值
	 * @param page
	 *            页面对象
	 * @return 返回Entity后，后面的其他操作，都会使用该Entity
	 */
	public TmRoleEntity savePost(TmRoleEntity entity, TmRoleVo vo, Page page);
}
