package com.biz.eisp.mdm.role.service;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.vo.TmRoleInfoExportVo;
import com.biz.eisp.mdm.role.vo.TmRoleVo;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/** 角色接口.
 * <p>角色相关功能接口的定义
 * @author grover
 * @version v1.0
 */
@SuppressWarnings("deprecation")
public interface TmRoleService extends BaseService{
	/**
	 * 获取角色信息.
	 * <p>根据当前职位获取有效的角色集合信息
	 * @author grover
	 * @param tmRoleVo 角色vo
	 * @param page 分页对象
	 * @return 角色集合
	 * @throws BusinessException 运行过程中可能出现的异常
	 */
	List<TmRoleEntity> getRoleListByCurrentPosId(TmRoleVo tmRoleVo, Page page) throws BusinessException;
	
	/**
	 * 查询角色列表.
	 * <p>
	 * @param tmRoleVo
	 * @param page
	 * @return
	 * @throws BusinessException
	 */
	List<TmRoleEntity> findRoleList(TmRoleVo tmRoleVo, Page page) throws BusinessException;
	
	/**
	 * 分页查询角色
	 * @param page 分页对象
	 * @param tmRole 模糊查询条件
	 * @return 返回查询结果的list集合
	 */
	List<TmRoleEntity> findPage(Page page, TmRoleEntity tmRole);

	/**
	 * 新增权限角色
	 * @param tmRoleVo 角色vo信息
	 * @param page 页面对象
	 */
	void createTmRole(TmRoleVo tmRoleVo, Page page) throws BusinessException;

	/**
	 * 删除权限角色
	 * @param id 需要删除的权限角色的ID
	 * @return 返回删除成功的boolean值
	 * @exception SQLException 约束错误
	 */
	boolean deleteTmRole(String id) throws SQLException;

	/**
	 * 修改权限角色信息
	 * @param tmRole 修改之后的权限角色信息
	 * @return 返回修改成功的boolean值
	 */
	Map<String,String> updateTmRole(TmRoleEntity tmRole);
	
	/**
	 * 停用，启用角色信息.
	 * <p>
	 * @param tmRoleVo
	 */
	AjaxJson startOrStopRole(TmRoleVo tmRoleVo);
	
	/**
	 * 验证角色.
	 * @author grover
	 * @param tmRole 角色对象
	 * @return 验证信息
	 */
	ValidForm validateTmRoleForm(TmRoleEntity tmRole);
	/**
	 * 查询角色，根据职位的id
	 * @author wan
	 * @param positionId
	 * @return
	 */
	List<TmRoleVo> findTmRoleByPostionId(String positionId);
	
	/**
	 * 查询角色，根据用户的id
	 * @author wan
	 * @param userId
	 * @return
	 */
	List<TmRoleVo> findTmRoleByUserId(String userId);
	
	 /**检测角色通用权限*/
    public boolean checkRoleAu(String userid);

	/**
	 * 查询排除自己的角色列表
	 * @param tmRoleVo 角色参数对象
	 * @param selfRoleId  自己的角色id
	 * @param page
	 * @return
	 */
	public List <TmRoleVo> findNoSelfRoleList(TmRoleVo tmRoleVo, String selfRoleId, Page page);

	/**
	 * 查询导出角色权限信息列表
	 * @param tmRoleInfoExportVo
	 * @return
	 */
	public List <TmRoleInfoExportVo> findExportRoleInfoList(TmRoleInfoExportVo tmRoleInfoExportVo);
}
