package com.biz.eisp.mdm.role.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.actrole.entity.TmRPositionActRoleEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.entity.TmRPositionRoleEntity;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.service.TmRoleService;
import com.biz.eisp.mdm.role.vo.TmRolePositionImportVo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by xuduan on 2017/11/19.
 * 角色职位关系导入处理器
 */
public class TmRolePositionHandler extends ImpEventHandler<TmRolePositionImportVo> {

    /**
     * 要导入的关系数据
     */
    private List<TmRPositionRoleEntity> importDataList = new ArrayList<TmRPositionRoleEntity>();
    private TmRoleService tmRoleService;
    private int succNum = 0;
    private int errNum = 0;
    private StringBuilder errors = new StringBuilder();

    public TmRolePositionHandler() {
        tmRoleService = ApplicationContextUtils.getContext().getBean(TmRoleService.class);
    }

    @Override
    public void endRow(Map<String, Object> row, TmRolePositionImportVo bean) throws ValidateException {
        String positionCode = bean.getPositionCode();
        String roleCode = bean.getRoleCode();

        TmPositionEntity positionEntity = tmRoleService
                .findUniqueByProperty(TmPositionEntity.class, "positionCode", positionCode);
        TmRoleEntity roleEntity = tmRoleService
                .findUniqueByProperty(TmRoleEntity.class, "roleCode", roleCode);

        if(positionEntity == null) {
            this.addErrorMsg("职位编码：" + positionCode + "不存在");
        }

        if(roleEntity == null) {
            this.addErrorMsg("角色编码：" + roleCode + "不存在");
        }

        if(positionEntity != null && roleEntity != null) {
            TmRPositionRoleEntity entity = getExistTmRPositionRoleEntity(positionEntity.getId(),
                    roleEntity.getId());
            if(entity == null) {
                //不存在则新增
                entity = new TmRPositionRoleEntity();
            }
            //把数据添加到保存数据列表中
            entity.setTmPosition(positionEntity);
            entity.setTmRole(roleEntity);

            importDataList.add(entity);

            //设置导入成功信息
            succNum++;
            this.setSuccNum(succNum);
        }

    }

    /**
     * 是否存在职位-角色的对应关系数据
     * @param positionId
     * @param actRoleId
     * @return
     */
    private TmRPositionRoleEntity getExistTmRPositionRoleEntity(String positionId, String actRoleId) {
        String hql = "from TmRPositionRoleEntity where tmPosition.id = ? and tmRole.id = ?";
        List<TmRPositionRoleEntity> tmRPositionActRoleEntityList = tmRoleService.findByHql(hql,positionId,actRoleId);
        if(CollectionUtil.listNotEmptyNotSizeZero(tmRPositionActRoleEntityList)){
            return tmRPositionActRoleEntityList.get(0);
        }
        return null;
    }

    /**
     * 添加错误信息提示
     * @param error
     * @throws ValidateException
     */
    private void addErrorMsg(String error) throws ValidateException {
        this.errors.append("【第" +this.getRowNumber()+"行】:" + error).append("<br/>");
        this.errNum += 1;
        if (this.errNum > 200)
            throw new ValidateException(this.errors.toString());
    }

    public void end(){
        if(errNum > 0) {
            //返回导入验证失败的数据
            throw new BusinessException(this.errors.toString());
        }

        //保存导入数据
        this.saveData();
        //导入是分批次提交，end()方法会多次调用，保存完了把数据清掉，不然会重复保存
        importDataList.clear();
    }

    /**
     * 保存导入数据到数据库
     */
    private void saveData() {
        if(CollectionUtil.listNotEmptyNotSizeZero(importDataList)) {
            for(TmRPositionRoleEntity entity : importDataList) {
                tmRoleService.saveOrUpdate(entity);
            }
        }
    }

}
