package com.biz.eisp.mdm.role.transform;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.PinyinUtil;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.service.TmRoleService;
import com.biz.eisp.mdm.role.vo.TmRoleVo;
import com.google.common.base.Function;

/** 
 * 角色vo换实体
 * @author grover
 * @version v1.0
 */
public class TmRoleVoToTmRoleEntity implements Function<TmRoleVo, TmRoleEntity>{
	/**
	 * 角色service
	 */
	private TmRoleService tmRoleService;
	
	public TmRoleVoToTmRoleEntity(TmRoleService roleService) {
		this.tmRoleService = roleService;
	}
	
	@Override
	public TmRoleEntity apply(TmRoleVo vo) {
		//实例
		TmRoleEntity entity = new TmRoleEntity();
		if(StringUtil.isNotEmpty(vo.getId())){
			entity = tmRoleService.get(TmRoleEntity.class, vo.getId());
		}
		if(StringUtil.isEmpty(vo.getEnableStatus())){
			vo.setEnableStatus(Globals.ZERO);
		}
		vo.setHeadString(PinyinUtil.getPinYinHeadChar(vo.getRoleName()));
		//拷贝
		try {
			MyBeanUtils.copyBeanNotNull2Bean(vo, entity);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("拷贝角色信息异常");
		}
		return entity;
	}

}
