package com.biz.eisp.mdm.system.listener;


import com.biz.eisp.mdm.system.service.InitListenerService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.ServletContextEvent;

/**
 * 系统初始化监听器,在系统启动时运行,进行一些初始化工作
 * 
 * @author keith
 *
 */
public class InitListener implements javax.servlet.ServletContextListener {

    @Override
    public void contextDestroyed(ServletContextEvent arg0) {

    }

    @Override
    public void contextInitialized(ServletContextEvent event) {
        WebApplicationContext webApplicationContext =
        		WebApplicationContextUtils.getWebApplicationContext(event .getServletContext());
        
        InitListenerService systemService = 
        		(InitListenerService) webApplicationContext.getBean("initListenerService");
        
        //缓存数据字典
        systemService.initAllTypeGroups();
        
        //缓存动态配置数据表信息
        systemService.initAllTableColumns();
        
        systemService.initDepart();
    }

}
