package com.biz.eisp.mdm.system.service.impl;


import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ComboxTreeUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.DBConfigUtil;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.dict.dao.TmDictDao;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import com.biz.eisp.mdm.dict.vo.TmDictTypeVo;
import com.biz.eisp.mdm.org.dao.TmOrgDao;
import com.biz.eisp.mdm.org.util.TmOrgTreeUtil;
import com.biz.eisp.mdm.system.service.InitListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("initListenerService")
@Transactional
public class InitListenerServiceImpl extends BaseServiceImpl implements InitListenerService {

  @Autowired
  private TmOrgDao tmOrgDao;
  @Autowired
  private IRedisCacheService redisCacheService;
  @Autowired
  private TmDictDao tmDictDao;

  @Resource
  private DBConfigUtil dbConfigUtil;

  @Override
  public void initAllTypeGroups() {

    List<TmDictTypeVo> typeGroups = tmDictDao.getDictTypeVoList(new TmDictTypeVo());
    DictUtil.versionMap.put(this.dbConfigUtil.getJdbcUserName() + "_dict_version", redisCacheService.incrBy(this.dbConfigUtil.getJdbcUserName() + "_dict_version", 0));//获取初始版本号
    for (TmDictTypeVo dictTypeEntity : typeGroups) {
      DictUtil.allDictType.put(dictTypeEntity.getDictTypeCode(),
          dictTypeEntity);
      try {
        redisCacheService.setMap(this.dbConfigUtil.getJdbcUserName() + "_dict_json_type", dictTypeEntity.getDictTypeCode(), dictTypeEntity);
      } catch (Exception e) {
        e.printStackTrace();
      }
      TmDictTypeVo vo = new TmDictTypeVo();
      vo.setDictTypeCode(dictTypeEntity.getDictTypeCode());
      List<TmDictDataVo> list = tmDictDao.getDictDataVoList(vo);
      if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
        DictUtil.allDictData.put(dictTypeEntity.getDictTypeCode(), list);
        try {
          for (int i = 0; i < list.size(); i++) {
            redisCacheService.setMap(this.dbConfigUtil.getJdbcUserName() + "_dict_json_data" + dictTypeEntity.getDictTypeCode(), list.get(i).getDictCode(), list.get(i));
          }
        } catch (Exception e) {
          e.printStackTrace();
        }
      }
    }
  }

  @Override
  public void initAllTableColumns() {

    String sql = "select table_Name from tm_mdm_table_config group by table_Name ";
    List<Map<String, Object>> list = this.findForMapList(sql);

    for (Map<String, Object> map : list) {
      String tableName = (String) map.get("table_Name");

      List<TmMdmTableConfigEntity> tableColumns =
          this.findByPropertyisOrder(TmMdmTableConfigEntity.class,
              "tableName", tableName, true, "columnOrder");
      //导入字段信息
      List<TmMdmTableConfigEntity> tableConfigImp = new ArrayList<TmMdmTableConfigEntity>();

      //缓存所有动态配置表信息key--> 表名，Map-->实体field，字段描述
      Map<String, TmMdmTableConfigEntity> allFieldEntity = new HashMap<String, TmMdmTableConfigEntity>();
      //字段值与字段描述放入map
      Map<String, String> fieldMap = new HashMap<String, String>();
      //列名与字段描述
      Map<String, String> clounmMap = new HashMap<String, String>();
      //动态表单数据字典列
      Map<String, String> cloumnDictTypeMap = new HashMap<String, String>();

      for (TmMdmTableConfigEntity tableColumn : tableColumns) {
        allFieldEntity.put(tableColumn.getField(), tableColumn);
        //数据字典
        if (StringUtil.isNotEmpty(tableColumn.getDictType())) {
          cloumnDictTypeMap.put(tableColumn.getField(), tableColumn.getDictType());
        }

        //字段描述
        String columnDesc = StringUtil.isNotEmpty(tableColumn.getFieldName()) ?
            tableColumn.getFieldName() : tableColumn.getColumnDesc();
        clounmMap.put(tableColumn.getField(), columnDesc);
        fieldMap.put(tableColumn.getColumnName(), columnDesc);

        //导出信息值
        if (StringUtil.isNotEmpty(tableColumn.getImportOut())) {
          String keyName = tableColumn.getTableName() + tableColumn.getField();
          if (StringUtil.isNotEmpty(tableColumn.getFieldProperty())) {
            keyName = tableColumn.getTableName() + tableColumn.getFieldProperty();
          }
          DynamicConfigUtil.allTableConfigByField.put(keyName.toLowerCase(), tableColumn);
        }

        //导入信息
        if (StringUtil.isNotEmpty(tableColumn.getAddShowMode()) && tableColumn.getAddShowMode() == 1) {
          tableConfigImp.add(tableColumn);
        }
      }
      DynamicConfigUtil.allTableConfigEntity.put(tableName, allFieldEntity);
      DynamicConfigUtil.allTableConfigDictColumn.put(tableName, cloumnDictTypeMap);
      DynamicConfigUtil.allTableConfigField.put(tableName, fieldMap);
      DynamicConfigUtil.allTableConfigColumn.put(tableName, clounmMap);
      DynamicConfigUtil.allTableConfig.put(tableName.toLowerCase(), tableColumns);
      DynamicConfigUtil.allTableConfigImpColumn.put(tableName, tableConfigImp);
    }
  }

  /**********组织树初始加载start******************/
  /**
   * 初始添加组织缓存
   */
  @Override
  public void initDepart() {

    List<ComboTree> comboTrees = new ArrayList<ComboTree>();
    List<ComboTree> orgVos = tmOrgDao.findComboTree();
    try {
      ComboxTreeUtil.currMap.clear();
      for (ComboTree obj : orgVos) {
        redisCacheService.setMap(this.dbConfigUtil.getJdbcUserName() + "_orgTree", obj.getId(), obj);
      }
      comboTrees = TmOrgTreeUtil.buildTree(orgVos);
      ComboxTreeUtil.versionMap.put(this.dbConfigUtil.getJdbcUserName() + "_orgTree_version", redisCacheService.incrBy(this.dbConfigUtil.getJdbcUserName() + "_orgTree_version", 0));//获取初始版本号
      ComboxTreeUtil.currMap.put(this.dbConfigUtil.getJdbcUserName() + "_orgTree", comboTrees);
    } catch (Exception e) {
      e.printStackTrace();
    }

  }

  /**
   * 刷新组织缓存数据
   *
   * @param orgId
   * @param parentId
   * @param departname
   * @param type       1新增  2修改 3删除 4更换 上级组织
   */
  @Override
  public void refleshDepart(String orgId, String parentId, String departname, int type) {
    try {
      if (StringUtil.isNotEmpty(orgId) && StringUtil.isNotEmpty(departname)) {
        ComboTree tp = new ComboTree();
        tp.setId(orgId);
        tp.setText(departname);
        tp.setPid(parentId);
        if (type == 3) { //删除
          redisCacheService.removeMap(this.dbConfigUtil.getJdbcUserName() + "_orgTree", orgId);
        } else {
          redisCacheService.setMap(this.dbConfigUtil.getJdbcUserName() + "_orgTree", orgId, tp);
        }
        redisCacheService.incrBy(this.dbConfigUtil.getJdbcUserName() + "_orgTree_version", 1);//加0  获取当前的版本号
      }
    } catch (Exception e) {
      throw new BusinessException("更新缓存失败");
    }
  }
  /**********组织树初始加载end******************/
}
