package com.biz.eisp.mdm.terminal.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.terminal.service.TmTerminalCustPostExtendService;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.terminal.service.TmTermCustPostService;
import com.biz.eisp.mdm.terminal.vo.TmTermCustPostVo;

/** 
 * 终端与经销商职位对应关系controller
 * @author 肖胜
 * @version v1.0
 */
@Controller
@RequestMapping("/tmTermCustPostController")
public class TmTermCustPostController extends BaseController {

	@Autowired
	private TmTermCustPostService tmTermCustPostService;

	@Autowired(required = false)
	private TmTerminalCustPostExtendService tmTerminalCustPostExtendService;

	/**
	 * 删除终端与经销商职位对应关系
	 * @param termCustPostVo
	 * @param response
	 */
	@RequestMapping(value="deleteTmTermCustPost",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public JSONObject deleteTmTermCustPost(TmTermCustPostVo termCustPostVo,HttpServletResponse response){
		tmTermCustPostService.deleteTmTermCustPost(termCustPostVo);
		if (null != tmTerminalCustPostExtendService){
			tmTerminalCustPostExtendService.afterDeleteTmTermCustPost(termCustPostVo);
		}
		return returnJson();
	}

	/**
	 * 跳转终端和职位的关系. （维护 ）
	 * @param request 请求对象
	 * @param termCustPostVo 关系vo
	 * @return 成功或者失败
	 */
	@RequestMapping(value="goTermBindPosMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTermBindPosMain(HttpServletRequest request,TmTermCustPostVo termCustPostVo){
		request.setAttribute("positionId", termCustPostVo.getPositionId());
		return new ModelAndView("com/biz/eisp/mdm/tmTerminal/termBindPosMain");
	}

	/**
	 * 跳转终端和职位的关系. （仅查看 ）
	 * @param request 请求对象
	 * @param termCustPostVo 关系vo
	 * @return 成功或者失败
	 */
	@RequestMapping(value="goTermPosCustMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTermPosCustMain(HttpServletRequest request,TmTermCustPostVo termCustPostVo){
		request.setAttribute("positionId", termCustPostVo.getPositionId());
		request.setAttribute("customerId", termCustPostVo.getCustomerId());
		return new ModelAndView("com/biz/eisp/mdm/tmTerminal/terminalPosCustMain");
	}

	/**
	 * 选择新客户关联
	 * @param request 请求对象
	 * @param customerId 关系vo
	 * @return
	 */
	@RequestMapping(value="goSelectNewCustomer", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goSelectNewCustomer(HttpServletRequest request,String customerId,String relationIds){
		request.setAttribute("customerId", customerId);
		request.setAttribute("relationIds", relationIds);

		//经销商用户查询经销商时用
		request.setAttribute("custUser", request.getParameter("custUser"));
		return new ModelAndView("com/biz/eisp/mdm/tmTerminal/customerSelect");
	}

	/**
	 * 查询选择新的上客户信息
	 * @param termCustPostVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value="findNewTmCustomerList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findNewTmCustomerList(TmTermCustPostVo termCustPostVo, HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmCustomerVo> customerList=
				tmTermCustPostService.findCustomerBySelect(termCustPostVo, page);
		return new DataGrid(customerList, page);
	}

	/**
	 * 选择新客户关联
	 * @param request 请求对象
	 * @param positionId 关系vo
	 * @return
	 */
	@RequestMapping(value="goSelectNewPosition", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goSelectNewPosition(HttpServletRequest request,String positionId,String relationIds){
		request.setAttribute("positionId", positionId);
		request.setAttribute("relationIds", relationIds);
		return new ModelAndView("com/biz/eisp/mdm/tmTerminal/positionSelect");
	}

	/**
	 * 查询选择新的对接人职位信息
	 * @param termCustPostVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value="findNewTmPositionList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findNewTmPositionList(TmTermCustPostVo termCustPostVo, HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmPositionVo> tmPositionVoList=
				tmTermCustPostService.findPostionBySelect(termCustPostVo,page);
		return new DataGrid(tmPositionVoList, page);
	}

	/**
	 * 保存终端和职位的关系.
	 * @param request 请求对象
	 * @param customerId 关系vo
	 * @return 成功或者失败
	 */
	@RequestMapping(value="goMaintainCustAndTerminalMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goMaintainCustAndTerminalMain(HttpServletRequest request,String customerId){
		request.setAttribute("customerId", customerId);
		return new ModelAndView("com/biz/eisp/mdm/tmTerminal/tmMaintainTerminalByCustomerMain");
	}

	/**
	 * 根据终端id查询关系列表 
	 * @param termCustPostVo
	 * @return
	 */
	@RequestMapping(value="findTmTermCustPostList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmTermCustPostList(TmTermCustPostVo termCustPostVo,
			HttpServletRequest request,HttpServletResponse response){
		Page page=new EuPage(request);
		List<TmTermCustPostVo> custPostList=
				tmTermCustPostService.findTmTermCustPostList(termCustPostVo,page);
		return new DataGrid(custPostList, page);
	}
	


	/**
	 * 查询终端信息数据
	 * @param termCustPostVo 终端vo对象
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping(value="findNotAnyCustTerminalList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findNotAnyCustTerminalList(TmTermCustPostVo termCustPostVo, HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmTerminalVo> terminalList=
				tmTermCustPostService.findNotAnyCustTerminalList(termCustPostVo, page);
		return new DataGrid(terminalList, page);
	}

	/**
	 * 查询终端信息数据
	 * @param termCustPostVo 终端vo对象
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping(value="findNotCurrCustTerminalList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findNotCurrCustTerminalList(TmTermCustPostVo termCustPostVo,HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmTerminalVo> terminalList=
				tmTermCustPostService.findNotCurrCustTerminalList(termCustPostVo, page);
		return new DataGrid(terminalList, page);
	}

	/**
	 * 批量添加终端与客户对应关系
	 * @param terminalIds 终端vo对象
	 * @param customerId 客户编码
	 * @param response 响应对象
	 */
	@RequestMapping(value="addRelotaionForCustomerId", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson addRelotaionForCustomerId(String terminalIds,String customerId, HttpServletResponse response){
		AjaxJson ajaxJson=new AjaxJson();
		try {
			tmTermCustPostService.addRelotaionForCustomerId(terminalIds,customerId);
			if (null != tmTerminalCustPostExtendService){
				tmTerminalCustPostExtendService.afterAddRelotaionForCustomerId(terminalIds,customerId);
			}
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setSuccess(false);
			ajaxJson.setMsg(e.getMessage());
		}
		return ajaxJson;
	}

	/**
	 * 批量解除终端与客户对应关系
	 * @param ids 终端vo对象
	 * @param flag 1表示客户批量调整 2表示职位批量调整
	 * @param response 响应对象
	 */
	@RequestMapping(value="deleteRelotaion", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteRelotaion(String ids,Integer flag,HttpServletResponse response){
		AjaxJson ajaxJson=new AjaxJson();
		try {
			List<TmTermCustPostVo> result = tmTermCustPostService.deleteRelotaionForCustomerId(ids,flag);
			if (null != tmTerminalCustPostExtendService){
				tmTerminalCustPostExtendService.afterDeleteRelotaion(result,flag);
			}
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setSuccess(false);
			ajaxJson.setMsg(e.getMessage());
		}
		return ajaxJson;
	}

	/**
	 * 批量解除终端与客户对应关系
	 * @param ids 终端vo对象
	 * @param response 响应对象
	 */
	@RequestMapping(value="deleteTmRCustTermPost",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteTmRCustTermPost(String ids,HttpServletResponse response){
		AjaxJson ajaxJson=new AjaxJson();
		try {
			List<TmTermCustPostVo> result = tmTermCustPostService.deleteTmRCustTermPost(ids);
			if (null != tmTerminalCustPostExtendService){
				tmTerminalCustPostExtendService.afterDeleteTmRCustTermPost(result);
			}
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setSuccess(false);
			ajaxJson.setMsg(e.getMessage());
		}
		return ajaxJson;
	}


	/**
	 * 替换 终端与经销商对应关系
	 * @param relationIds 对应关系主键ids
	 * @param customerId  新的客户id
	 */
	@RequestMapping(value="updateCustTerminalRelation", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson updateCustTerminalRelation(String relationIds,String customerId,HttpServletResponse response){
		AjaxJson ajaxJson=new AjaxJson();
		try {
			List<TmTermCustPostVo> result = tmTermCustPostService.updateCustTerminalRelation(relationIds,customerId);
			if (null != tmTerminalCustPostExtendService){
				tmTerminalCustPostExtendService.afterUpdateCustTerminalRelation(result,customerId);
			}
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setSuccess(false);
			ajaxJson.setMsg(e.getMessage());
		}
		return ajaxJson;
	}

	/**
	 * 查询终端信息数据
	 * @param termCustPostVo 终端vo对象
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping(value="findNotAnyPostTerminalList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findNotAnyPostTerminalList(TmTermCustPostVo termCustPostVo, HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmTerminalVo> terminalList=
				tmTermCustPostService.findNotAnyPostTerminalList(termCustPostVo, page);
		return new DataGrid(terminalList, page);
	}

	/**
	 * 查询终端信息数据
	 * @param termCustPostVo 终端vo对象
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping(value="findNotCurrPostTerminalList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findNotCurrPostTerminalList(TmTermCustPostVo termCustPostVo,HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmTerminalVo> terminalList=tmTermCustPostService.findNotCurrPostTerminalList(termCustPostVo, page);
		return new DataGrid(terminalList, page);
	}

	/**
	 * 批量添加终端与客户对应关系
	 * @param terminalIds 终端vo对象
	 * @param positionId 职位ID
	 * @param response 响应对象
	 */
	@RequestMapping(value="addRelotaionForPositionId", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson addRelotaionForPositionId(String terminalIds,String positionId, HttpServletResponse response){
		AjaxJson ajaxJson=new AjaxJson();
		try {
			tmTermCustPostService.addRelotaionForPositionId(terminalIds,positionId);
			if (null != tmTerminalCustPostExtendService){
				tmTerminalCustPostExtendService.afterAddRelotaionForPositionId(terminalIds,positionId);
			}
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setSuccess(false);
			ajaxJson.setMsg(e.getMessage());
		}
		return ajaxJson;
	}

	/**
	 * 替换 终端与经销商对应关系
	 * @param relationIds 对应关系主键ids
	 * @param positionId  新的职位id
	 */
	@RequestMapping(value="updatePostTerminalRelation", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson updatePostTerminalRelation(String relationIds,String positionId,HttpServletResponse response){
		AjaxJson ajaxJson=new AjaxJson();
		try {
			tmTermCustPostService.updatePostTerminalRelation(relationIds,positionId);
			if (null != tmTerminalCustPostExtendService){
				tmTerminalCustPostExtendService.afterUpdatePostTerminalRelation(relationIds,positionId);
			}
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setSuccess(false);
			ajaxJson.setMsg(e.getMessage());
		}
		return ajaxJson;
	}

}
