package com.biz.eisp.mdm.terminal.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.biz.eisp.mdm.terminal.service.*;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.vo.TmTermCustPostVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;

/** 
 * 终端管理controller
 * @author 肖胜
 * @version v1.0
 */
@Controller
@RequestMapping("/tmTerminalController")
public class TmTerminalController extends BaseController {

	@Autowired
	private TmTerminalService tmTerminalService;
	
	@Autowired
	private TmTermCustPostService tmTermCustPostService;

	@Autowired(required=false)
	private TmTerminalBackExtendService terminalBackExtendService;

	@Autowired(required = false)
	private TmTerminalFormExtendService tmTerminalFormExtendService;

	@Autowired(required = false)
	private TmTerminalMainExtendService tmTerminalMainExtendService;

	@Autowired(required = false)
	private TmTerminalApprovalExtendService tmTerminalApprovalExtendService;

	/**
	 * 终端管理展示主界面
	 * @return 页面视图
	 */
	@RequestMapping(value="goTmTerminalMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTmTerminalMain(HttpServletRequest request){
     	request.setAttribute("extendTableName",Globals.TABLE_TERMINAL);

		if(tmTerminalMainExtendService != null){
			request.setAttribute("includeJsp", tmTerminalMainExtendService.includeJsp());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmTerminal/terminalMain");
	}
	/**
	 * 终端业务弹出标签页面跳转.
	 * @author grover
	 * @param terminalVo 终端vo
	 * @param singleSelect 是否单选
	 * @return
	 */
	@RequestMapping(value="goTerminalSearch",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTerminalSearch(TmTerminalVo terminalVo,String singleSelect,String searchUrl){
		ModelAndView view =  new ModelAndView("com/biz/eisp/mdm/tmTerminal/terminalSearchMain");
		view.addObject("extendTableName",Globals.TABLE_TERMINAL);
		view.addObject("vo",terminalVo);
		if(StringUtil.isEmpty(searchUrl)){
			searchUrl="tmTerminalController.do?findTmTerminalBySearchList";
		}
		view.addObject("searchUrl",searchUrl);
		view.addObject("singleSelect", singleSelect);
		return view;
	}
	
	
	/**
	 * 跳转终端管理新增
	 * @param terminalVo 终端vo对象
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value="goTmTerminal", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmTerminal(TmTerminalVo terminalVo,
			HttpServletRequest request,HttpServletResponse response){
		//表单跳转标识
		String optype=request.getParameter("optype");
		request.setAttribute("optype", optype);
		
		if(StringUtil.isNotEmpty(terminalVo.getId())){
			//修改或查看加载数据 
			terminalVo=tmTerminalService.getTmTerminal(terminalVo,null);
			request.setAttribute(Globals.TABLE_TERMINAL, terminalVo);
			
			//加载与客户职位对应关系
			TmTermCustPostVo tmTermCust=new TmTermCustPostVo();
			tmTermCust.setTerminalId(terminalVo.getId());
			List<TmTermCustPostVo> custPostList=
					tmTermCustPostService.findTmTermCustPostList(tmTermCust,null);
			request.setAttribute("custPostList", custPostList);
		}
		//动态表单传入表名
		request.setAttribute("extendTableName",Globals.TABLE_TERMINAL);
		
		
		if(tmTerminalFormExtendService != null){
			request.setAttribute("includeJsp", tmTerminalFormExtendService.includeJsp());
		}
		
		return new ModelAndView("com/biz/eisp/mdm/tmTerminal/terminalForm");
	}
	
	/**
	 * 终端选择上级客户展示主界面
	 * @return 页面视图
	 */
	@RequestMapping(value="goTerminalCust",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTerminalCust(HttpServletRequest request){
		String terminalId=request.getParameter("terminalId");
		request.setAttribute("terminalId", terminalId);
		return new ModelAndView("com/biz/eisp/mdm/tmTerminal/terminalCust");
	}
	
	/**
	 * 查询终端信息数据
	 * @param terminalVo 终端vo对象
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping(value="findTmTerminalList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmTerminalList(TmTerminalVo terminalVo,HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmTerminalVo> terminalList=
				tmTerminalService.findTmTerminalList(terminalVo, page);
		return new DataGrid(terminalList, page);
	} 
	
	/**
	 * 查询终端信息数据
	 * @author grover
	 * @param terminalVo 终端vo对象
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping(value="findTmTerminalBySearchList",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmTerminalBySearchList(TmTerminalVo terminalVo,HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmTerminalVo> terminalList = new ArrayList<TmTerminalVo>();
		try {
			if (StringUtil.isNotEmpty(terminalVo.getSearchParam())) {
				terminalVo.setTerminalName(terminalVo.getSearchParam());
			}
			terminalList = tmTerminalService.findTmTerminalList(terminalVo, page);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("获取终端信息失败,"+e.getMessage());
		}
		return new DataGrid(terminalList, page);
	} 
	/**
	 * 查询终端信息数据
	 * @author grover
	 * @param terminalVo 终端vo对象
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping(value="getTerminalBySearchList",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public AjaxJson getTerminalBySearchList(TmTerminalVo terminalVo,HttpServletRequest request){
		AjaxJson j = new AjaxJson();
		Map<String, Object> map = new HashMap<String, Object>();
		Page page=new EuPage(request);
		try {
			if (StringUtil.isNotEmpty(terminalVo.getSearchParam())) {
				terminalVo.setTerminalName(terminalVo.getSearchParam());
			}
			List<TmTerminalVo> terminalList = tmTerminalService
					.findTmTerminalList(terminalVo, page);
			map.put("totle", terminalList.size());
			j.setObj(terminalList);
		} catch (Exception e) {
			j.setSuccess(false);
			map.put("totle", 0);
			e.printStackTrace();
		}
		j.setAttributes(map);
		return j;
	} 
	
	/**
	 * 通过职位查询终端信息数据..
	 * @author grover
	 * @param terminalVo 终端对象
	 * @param request 请求对象
	 * @return 终端列表
	 */
	@RequestMapping(value="findTmTerminalByPosList",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmTerminalByPosList(TmTerminalVo terminalVo,HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmTerminalVo> terminalList=
				tmTerminalService.findTmTerminalByPosList(terminalVo, page);
		return new DataGrid(terminalList, page);
	} 
	
	/**
	 * 保存终端信息
	 * @param terminalVo 终端vo对象
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value="saveTmTerminal", method = {RequestMethod.GET, RequestMethod.POST})
	public void saveTmTerminal(TmTerminalVo terminalVo,
			HttpServletRequest request,HttpServletResponse response){
		Page page = new EuPage(request);
		String id = tmTerminalService.saveTmTerminal(terminalVo, page);
		if (null != terminalBackExtendService){
			terminalBackExtendService.afterSaveTerminal(id);
		}
		super.sendResponse(response);
	}
	
	/**
	 * 删除终端信息
	 * @param ids 终端vo对象
	 * @param request 请求对象
	 */
	@RequestMapping(value="deleteTmTerminal", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteTmTerminal(String ids,HttpServletRequest request){
		AjaxJson ajaxJson=new AjaxJson();
		try {
			Page page = new EuPage(request);
			ajaxJson= tmTerminalService.deleteTmTerminal(ids,page);
			if (null != terminalBackExtendService){
				Map<String, Object> attributes = ajaxJson.getAttributes();
				Object terminalCodeList = attributes.get("terminalCodeList");
				if (null != terminalCodeList){
					terminalBackExtendService.afterDeleteTmTerminal((List<String>) terminalCodeList);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setMsg("删除失败:"+e.getMessage());
		}
		return ajaxJson;
	}


	/**
	 * 删除终端信息
	 * @param ids 终端vo对象
	 * @param response 响应对象
	 */
	@RequestMapping(value="doApprovalTerminal", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson doApprovalTerminal(String ids,HttpServletResponse response){
		AjaxJson ajaxJson=new AjaxJson();
		try {
			if(tmTerminalApprovalExtendService!=null){
				tmTerminalApprovalExtendService.examineAndApprove(ids);
			}else{
				ajaxJson.setMsg("未找到终端审批接口tmTerminalApprovalExtendService实现");
			}
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setMsg("提交失败");
		}
		return ajaxJson;
	}

	/**
	 * 查询终端审批详情
	 * @author Sean
	 * @param terminalId 终端对象
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping(value="findAppravalDetail",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public DataGrid findAppravalDetail(String terminalId,HttpServletRequest request){
		Page page=new EuPage(request);
		if(tmTerminalApprovalExtendService!=null){
			return tmTerminalApprovalExtendService.findAppravalDetail(terminalId,request,page);
		}
		return new DataGrid(new ArrayList(), page);
	}

	/**
	 * <p>跳转审批情况<br>
	 * @author Sean
	 * @return 终端审批详情界面
	 */
	@RequestMapping(value = "goAppravalDetail", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goAppravalDetail(String terminalId, HttpServletRequest request) {
		if(tmTerminalApprovalExtendService!=null){
			return tmTerminalApprovalExtendService.goAppravalDetail(terminalId,request);
		}else{
			throw new BusinessException("未找到终端审批接口tmTerminalApprovalExtendService实现");
		}
	}


	/**
	 * <p>跳转到日志管理主页面<br>
	 * @author Sean
	 * @return 日志管理主界面
	 */
	@RequestMapping(value = "goTmLogDetailMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmLogDetailMain( HttpServletRequest request) {
		String businessId=request.getParameter("id");
		request.setAttribute("actionUrl", "tmTerminalController/findTmLogList?businessId="+businessId);
		return new ModelAndView("com/biz/eisp/log/tmLogDetailMain");
	}
	
	/**
	 * 分页获取日志列表信息
	 * @author Sean
	 * @param tmLogVo 日志实体模型
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "findTmLogList",method = {RequestMethod.GET,RequestMethod.POST})
	public void findTmLogList(TmLogVo tmLogVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		List <TmLogVo> tmLogList = tmTerminalService.findTerminalLogList(tmLogVo, page);
		this.datagridReturn(response, tmLogList, page);
	}
	
	/**
	 * 终端列表excel导出
	 * @author wuzhujun
	 * @param terminalVo 终端vo
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "exportXls", method = {RequestMethod.GET, RequestMethod.POST})
	public void exportXls(TmTerminalVo terminalVo, HttpServletRequest request, HttpServletResponse response) {
		List<TmTerminalVo> terminalList=
				tmTerminalService.findTmTerminalList(terminalVo, null);
		doExportXls(response, request, terminalList, TmTerminalVo.class, "终端列表");
	}
	
	/**
	 * 验证重复终端名称Name.
	 * @author wuzhujun
	 * @param terminalVo 终端vo对象
	 */
	@RequestMapping(value = "validateTerminalName",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public ValidForm validateTerminalName(HttpServletRequest request,TmTerminalVo terminalVo) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		//验证
		if(StringUtil.isNotEmpty(terminalVo.getId())){
			//修改
			Criterion cr1 = Restrictions.eq("terminalName", param);
			Criterion cr2 = Restrictions.ne("id", terminalVo.getId());
			
			List<TmTerminalEntity> tmTerminals = tmTerminalService
					.findByCriteria(TmTerminalEntity.class, cr1, cr2);
			if(!CollectionUtils.isEmpty(tmTerminals)){
				validForm.setStatus("n");
				validForm.setInfo("终端名称已存在");
			}
		}else{
			//新增
			List<TmTerminalEntity> tmTerminals = tmTerminalService
					.findByProperty(TmTerminalEntity.class, "terminalName", param);
			if(!CollectionUtils.isEmpty(tmTerminals)){
				validForm.setStatus("n");
				validForm.setInfo("终端名称已存在");
			}
		}
		return validForm;
	}

}
