package com.biz.eisp.mdm.terminal.dao;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.terminal.vo.TmTermCustPostVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;

/**
 * 终端与经销商职位关系管理dao
 * @author 肖胜
 * @version v1.0
 */
@InterfaceDao
public interface TmTermCustPostDao {

	/**
	 * 条件查询经销商终端信息
	 * @param tmTermCustPostVo 查询条件
	 * @return
	 */
	@Arguments({"tmTermCustPostVo"})
	@ResultType(TmTermCustPostVo.class)
	public List<TmTermCustPostVo> findTermCustPostList(TmTermCustPostVo tmTermCustPostVo);
	
	/**
	 * 条件查询经销商终端信息
	 * @param tmTermCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	@Arguments({"tmTermCustPostVo","page"})
	@ResultType(TmTermCustPostVo.class)
	public List<TmTermCustPostVo> findTermListByCustomerId(TmTermCustPostVo tmTermCustPostVo,Page page);

	/**
	 * 条件查询经销商终端信息 未关联任何经销商的门店
	 * @param tmTermCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	@Arguments({"tmTermCustPostVo","page"})
	@ResultType(TmTerminalVo.class)
	public List<TmTerminalVo> findNotAnyCustTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page);

	/**
	 * 条件查询经销商终端信息未关联当前经销商门店
	 * @param tmTermCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	@Arguments({"tmTermCustPostVo","page"})
	@ResultType(TmTerminalVo.class)
	public List<TmTerminalVo> findNotCurrCustTerminalList(TmTermCustPostVo tmTermCustPostVo,Page page);

	/**
	 * 选择新的客户编码 替换经销商与终端对应关系
	 * @param tmTermCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	@Arguments({"tmTermCustPostVo","page"})
	@ResultType(TmCustomerVo.class)
	public List<TmCustomerVo> findCustomerBySelect(TmTermCustPostVo tmTermCustPostVo, Page page);

	/**
	 * 条件查询经销商终端信息 未关联任何职位的门店
	 * @param tmTermCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	@Arguments({"tmTermCustPostVo","page"})
	@ResultType(TmTerminalVo.class)
	public List<TmTerminalVo> findNotAnyPostTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page);

	/**
	 * 条件查询经销商终端信息未关联当前职位门店
	 * @param tmTermCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	@Arguments({"tmTermCustPostVo","page"})
	@ResultType(TmTerminalVo.class)
	public List<TmTerminalVo> findNotCurrPostTerminalList(TmTermCustPostVo tmTermCustPostVo,Page page);

	/**
	 * 选择新的客户编码 替换经销商与终端对应关系
	 * @param tmTermCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	@Arguments({"tmTermCustPostVo","page"})
	@ResultType(TmPositionVo.class)
	public List<TmPositionVo> findPositionBySelect(TmTermCustPostVo tmTermCustPostVo, Page page);
	
}
