package com.biz.eisp.mdm.terminal.dao;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.terminal.vo.QueryTmTerminalVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;

/**
 * 终端管理dao
 * @author 肖胜
 * @version v1.0
 */
@InterfaceDao
public interface TmTerminalDao {

	/**
	 * 条件查询终端信息
	 * @param tmTerminalVo 查询条件
	 * @param page 分页对象
	 * @param sql 查询sql 主数据已配置则自动构建
	 * @return
	 */
	@Arguments({"tmTerminalVo","page","sql"})
	@ResultType(TmTerminalVo.class)
	public List<TmTerminalVo> findTerminalList(TmTerminalVo tmTerminalVo,Page page,String sql);

	@Arguments({"terminalId","sql"})
	@ResultType(TmTerminalVo.class)
	public List<TmTerminalVo> findTerminalListChildren(String terminalId,String sql);

	/**
	 * 通过其他vo参数查询终端.
	 * @author grover
	 * @param terminalVo 终端vo对象
	 * @return 终端信息
	 */
	@Arguments({"terminalVo","page"})
	@ResultType(TmTerminalVo.class)
	List<TmTerminalVo> findTmTerminalByPosList(TmTerminalVo terminalVo, Page page);

	/**
	 * 获取查询终端的所有可能性.
	 * @author grover
	 * @param queryTmTerminalVo 终端查询vo对象
	 * @return 终端信息
	 */
	@Arguments({"queryTmTerminalVo","page"})
	@ResultType(TmTerminalVo.class)
	List<TmTerminalVo> findTmTerminalByAllPossible(QueryTmTerminalVo queryTmTerminalVo, Page page);

	/**
	 * 查看客户日志
	 * @param tmLogVo
	 * @param page
	 * @return
	 */
	@Arguments({"tmLogVo","page"})
	@ResultType(TmLogVo.class)
	public List<TmLogVo> findTerminalLogList(TmLogVo tmLogVo, Page page);
	/**
	 * 根据终端类型获取终端和上级客户.
	 * <p>该接口提供dms查询终端和客户信息.<br>
	 * @author grover
	 * @param queryTmTerminalVo 查询方式vo
	 * @param page 分页对象 如果不分页传入一个null
	 * @return 终端查询vo集合
	 */
	@Arguments({"queryTmTerminalVo","page"})
	@ResultType(QueryTmTerminalVo.class)
	public List<QueryTmTerminalVo> findTmTerminalAndCustByterminalType(
			QueryTmTerminalVo queryTmTerminalVo, Page page);
}
