package com.biz.eisp.mdm.terminal.entity;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;

/**
 * 经销商与业务组职位关联实体
 * 
 * @author 肖胜
 * @version v1.0
 */
@Entity
@Table(name = "TM_R_TERM_CUST_POS_BG")
public class TmRTermCustPosBGEntity extends IdEntity implements Serializable {

	private static final long serialVersionUID = 1L;
	/**
	 * 业务组
	 */
	private String businessGroup;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 创建用户账号
	 */
	private String createName;
	/**
	 * 终端实体
	 */
	private TmTerminalEntity tmTerminal;
	/**
	 * 经销商实体
	 */
	private TmCustomerEntity tmCustomer;
	/**
	 * 职位实体
	 */
	private TmPositionEntity tmPosition;

	/**
	 * 组织id
	 */
	private String orgId;

	/**
	 * 备注1
	 */
	private String extChar1;
	/**
	 * 备注2
	 */
	private String extChar2;

	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 业务组
	 */
	@Column(name = "business_group")
	public String getBusinessGroup() {
		return businessGroup;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            业务组
	 */
	public void setBusinessGroup(String businessGroup) {
		this.businessGroup = businessGroup;
	}

	/**
	 * 方法:取得java.util.Date
	 * 
	 * @return java.util.Date 创建时间
	 */
	@Column(name = "create_date")
	public Date getCreateDate() {
		return createDate;
	}

	/**
	 * 方法:设置java.util.Date
	 * 
	 * @param java.util.Date
	 *            创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 创建人
	 */
	@Column(name = "create_name")
	public String getCreateName() {
		return createName;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            创建人
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}

	/**
	 * 方法:取得com.biz.eisp.mdm.terminal.entity.TmTerminalEntity
	 * 
	 * @return com.biz.eisp.mdm.terminal.entity.TmTerminalEntity 终端
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "terminal_id", referencedColumnName = "id", updatable = true, insertable = true)
	public TmTerminalEntity getTmTerminal() {
		return tmTerminal;
	}

	/**
	 * 方法:设置com.biz.eisp.mdm.terminal.entity.TmTerminalEntity
	 * 
	 * @param com.biz.eisp.mdm.terminal.entity.TmTerminalEntity
	 *            终端
	 */
	public void setTmTerminal(TmTerminalEntity tmTerminal) {
		this.tmTerminal = tmTerminal;
	}

	/**
	 * 方法:取得com.biz.eisp.mdm.customer.entity.TmCustomerEntity
	 * 
	 * @return com.biz.eisp.mdm.customer.entity.TmCustomerEntity 经销商
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "customer_id")
	public TmCustomerEntity getTmCustomer() {
		return tmCustomer;
	}

	/**
	 * 方法:设置com.biz.eisp.mdm.customer.entity.TmCustomerEntity
	 * 
	 * @param com.biz.eisp.mdm.customer.entity.TmCustomerEntity
	 *            经销商
	 */
	public void setTmCustomer(TmCustomerEntity tmCustomer) {
		this.tmCustomer = tmCustomer;
	}

	/**
	 * 方法: 取得com.biz.eisp.mdm.position.entity.TmPositionEntity
	 * 
	 * @return com.biz.eisp.mdm.position.entity.TmPositionEntity 职位
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "position_id")
	public TmPositionEntity getTmPosition() {
		return tmPosition;
	}

	/**
	 * 方法:设置com.biz.eisp.mdm.position.entity.TmPositionEntity
	 * 
	 * @param com.biz.eisp.mdm.position.entity.TmPositionEntity
	 *            职位
	 */
	public void setTmPosition(TmPositionEntity tmPosition) {
		this.tmPosition = tmPosition;
	}

	@Column(name = "ORG_ID")
	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}

	@Column(name = "EXT_CHAR_1")
	public String getExtChar1() {
		return extChar1;
	}

	public void setExtChar1(String extChar1) {
		this.extChar1 = extChar1;
	}

	@Column(name = "EXT_CHAR_2")
	public String getExtChar2() {
		return extChar2;
	}

	public void setExtChar2(String extChar2) {
		this.extChar2 = extChar2;
	}
}
