package com.biz.eisp.mdm.terminal.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

/** 
 * 终端基础信息实体
 * <p>关联数据库表：tm_terminal<br>
 * @author 肖胜
 * @version v1.0
 */
@Entity
@Table(name = "tm_terminal")
public class TmTerminalEntity extends IdEntity implements Serializable,Loggerable {

	private static final long serialVersionUID = 1L;

	/**
	 * 终端编码
	 */
	private String terminalCode;
	/**
	 * ERP编码
	 */
	private String erpCode;
	/**
	 * 终端名称
	 */
	private String terminalName;
	/**
	 * 终端类型
	 */
	private String terminalType;
	/**
	 * 渠道类型
	 */
	private String channelType;
	
	/**
	 * 合作状态
	 */
	private String cooperative;
	/**
	 * 省
	 */
	private String province;
	/**
	 * 市
	 */
	private String city;
	/**
	 * 区
	 */
	private String area;
	/**
	 * 终端地址
	 */
	private String address;
	/**
	 * 终端联系人
	 */
	private String linkman;
	/**
	 * 终端联系人电话
	 */
	private String linkmanPhone;
	/**
	 * 启用状态：0-启用
	 */
	private Integer enableStatus;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 创建用户账号
	 */
	private String createName;
	/**
	 * 修改时间
	 */
	private Date updateDate;
	/**
	 * 修改用户账号
	 */
	private String updateName;
	/**
	 * 字符类型（length=100）-扩展字段1
	 */
	private String extChar1;
	/**
	 * 字符类型（length=100）-扩展字段2
	 */
	private String extChar2;
	/**
	 * 字符类型（length=100）-扩展字段3
	 */
	private String extChar3;
	/**
	 * 字符类型（length=100）-扩展字段4
	 */
	private String extChar4;
	/**
	 * 字符类型（length=100）-扩展字段5
	 */
	private String extChar5;
	/**
	 * 字符类型（length=200）-扩展字段6
	 */
	private String extChar6;
	/**
	 * 字符类型（length=200）-扩展字段7
	 */
	private String extChar7;
	/**
	 * 字符类型（length=200）-扩展字段8
	 */
	private String extChar8;
	/**
	 * 字符类型（length=200）-扩展字段9
	 */
	private String extChar9;
	/**
	 * 字符类型（length=200）-扩展字段10
	 */
	private String extChar10;
	/**
	 * 字符类型（length=1000）-扩展字段11
	 */
	private String extChar11;
	/**
	 * 字符类型（length=1000）-扩展字段12
	 */
	private String extChar12;
	/**
	 * 字符类型（length=1000）-扩展字段13
	 */
	private String extChar13;
	/**
	 * 字符类型（length=1000）-扩展字段14
	 */
	private String extChar14;
	/**
	 * 字符类型（length=1000）-扩展字段15
	 */
	private String extChar15;
	/**
	 * 字符类型（length=500）-扩展字段16
	 */
	private String extChar16;
	/**
	 * 字符类型（length=500）-扩展字段17
	 */
	private String extChar17;
	/**
	 * 字符类型（length=500）-扩展字段18
	 */
	private String extChar18;
	/**
	 * 字符类型（length=500）-扩展字段19
	 */
	private String extChar19;
	/**
	 * 字符类型（length=500）-扩展字段20
	 */
	private String extChar20;
	/**
	 * 字符类型（length=500）-扩展字段21
	 */
	private String extChar21;
	/**
	 * 字符类型（length=500）-扩展字段22
	 */
	private String extChar22;
	/**
	 * 字符类型（length=500）-扩展字段23
	 */
	private String extChar23;
	/**
	 * 字符类型（length=500）-扩展字段24
	 */
	private String extChar24;
	/**
	 * 字符类型（length=500）-扩展字段25
	 */
	private String extChar25;
	/**
	 * 字符类型（length=500）-扩展字段26
	 */
	private String extChar26;
	/**
	 * 字符类型（length=500）-扩展字段27
	 */
	private String extChar27;
	/**
	 * 字符类型（length=500）-扩展字段28
	 */
	private String extChar28;
	/**
	 * 字符类型（length=500）-扩展字段29
	 */
	private String extChar29;
	/**
	 * 字符类型（length=500）-扩展字段30
	 */
	private String extChar30;
	/**
	 * 数字类型-扩展字段1
	 */
	private Integer extNumber1;
	/**
	 * 数字类型-扩展字段2
	 */
	private Integer extNumber2;
	/**
	 * 数字类型-扩展字段3
	 */
	private Integer extNumber3;
	/**
	 * 数字类型-扩展字段4
	 */
	private Integer extNumber4;
	/**
	 * 数字类型-扩展字段5
	 */
	private Integer extNumber5;
	/**
	 * 所属组织
	 */
	private TmOrgEntity tmOrg;
	/**
	 * 审批状态
	 */
	private Integer bpmStatus;
	/**
	 * 经销商与业务组职位关联实体列表
	 */
	private List <TmRTermCustPosBGEntity> tmRTermCustPosBGList = new ArrayList<TmRTermCustPosBGEntity>();
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 终端编码
	 */
	@Column(name = "terminal_code")
	public String getTerminalCode(){
		return terminalCode;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 终端名称
	 */
	@Column(name = "terminal_name")
	public String getTerminalName(){
		return terminalName;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 终端类型
	 */
	@Column(name = "terminal_type")
	public String getTerminalType(){
		return terminalType;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 渠道类型
	 */
	@Column(name = "channel_type")
	public String getChannelType(){
		return channelType;
	}
	/**
	 * 方法:取得com.biz.eisp.mdm.org.entity.TmOrgEntity
	 * @return jcom.biz.eisp.mdm.org.entity.TmOrgEntity 组织
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "org_id")
	public TmOrgEntity getTmOrg() {
		return tmOrg;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 地址
	 */
	@Column(name = "address")
	public String getAddress(){
		return address;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 联系人
	 */
	@Column(name = "linkman")
	public String getLinkman(){
		return linkman;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 联系人电话
	 */
	@Column(name = "linkman_phone")
	public String getLinkmanPhone(){
		return linkmanPhone;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String erp编码
	 */
	@Column(name = "erp_code")
	public String getErpCode(){
		return erpCode;
	}
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 创建时间
	 */
	@Column(name = "create_date")
	public Date getCreateDate(){
		return createDate;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 创建人
	 */
	@Column(name = "create_name")
	public String getCreateName(){
		return createName;
	}
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date  更新时间
	 */
	@Column(name = "update_date")
	public Date getUpdateDate(){
		return updateDate;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 更新人
	 */
	@Column(name = "update_name")
	public String getUpdateName(){
		return updateName;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段1
	 */
	@Column(name = "ext_char_1")
	public String getExtChar1(){
		return extChar1;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String  字符扩展字段2
	 */
	@Column(name = "ext_char_2") 
	public String getExtChar2(){
		return extChar2;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段3
	 */
	@Column(name = "ext_char_3")
	public String getExtChar3(){
		return extChar3;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段4
	 */
	@Column(name = "ext_char_4")
	public String getExtChar4(){
		return extChar4;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段5
	 */
	@Column(name = "ext_char_5")
	public String getExtChar5(){
		return extChar5;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String  字符扩展字段6
	 */
	@Column(name = "ext_char_6")
	public String getExtChar6(){
		return extChar6;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段7
	 */
	@Column(name = "ext_char_7")
	public String getExtChar7(){
		return extChar7;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段8
	 */
	@Column(name = "ext_char_8")
	public String getExtChar8(){
		return extChar8;	
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段9
	 */
	@Column(name = "ext_char_9")
	public String getExtChar9(){
		return extChar9;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段10
	 */
	@Column(name = "ext_char_10")
	public String getExtChar10(){
		return extChar10;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段11
	 */
	@Column(name = "ext_char_11")
	public String getExtChar11(){
		return extChar11;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段12
	 */
	@Column(name = "ext_char_12")
	public String getExtChar12(){
		return extChar12;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段13
	 */
	@Column(name = "ext_char_13")
	public String getExtChar13(){
		return extChar13;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段14
	 */
	@Column(name = "ext_char_14")
	public String getExtChar14(){
		return extChar14;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段15
	 */
	@Column(name = "ext_char_15")
	public String getExtChar15(){
		return extChar15;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 数字扩展字段 1
	 */
	@Column(name = "ext_number_1")
	public Integer getExtNumber1(){
		return extNumber1;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 数字扩展字段 2
	 */
	@Column(name = "ext_number_2")
	public Integer getExtNumber2(){
		return extNumber2;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 数字扩展字段 3
	 */
	@Column(name = "ext_number_3")
	public Integer getExtNumber3(){
		return extNumber3;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 数字扩展字段 4
	 */
	@Column(name = "ext_number_4")
	public Integer getExtNumber4(){
		return extNumber4;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 数字扩展字段 5
	 */
	@Column(name = "ext_number_5")
	public Integer getExtNumber5(){
		return extNumber5;
	}

	/**
	 * 审批状态
	 * @return
	 */
	@Column(name = "bpm_status")
	public Integer getBpmStatus() {
		return bpmStatus;
	}

	public void setBpmStatus(Integer bpmStatus) {
		this.bpmStatus = bpmStatus;
	}

	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 终端编码
	 */
	public void setTerminalCode(String terminalCode) {
		this.terminalCode = terminalCode;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 终端名称
	 */
	public void setTerminalName(String terminalName) {
		this.terminalName = terminalName;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 终端类型
	 */
	public void setTerminalType(String terminalType) {
		this.terminalType = terminalType;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 渠道类型
	 */
	public void setChannelType(String channelType) {
		this.channelType = channelType;
	}
	/**
	 * 方法:设置 com.biz.eisp.mdm.org.entity.TmOrgEntity
	 * @param com.biz.eisp.mdm.org.entity.TmOrgEntity 组织
	 */
	public void setTmOrg(TmOrgEntity tmOrg) {
		this.tmOrg = tmOrg;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 地址
	 */
	public void setAddress(String address) {
		this.address = address;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 联系人
	 */
	public void setLinkman(String linkman) {
		this.linkman = linkman;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 联系人电话
	 */
	public void setLinkmanPhone(String linkmanPhone) {
		this.linkmanPhone = linkmanPhone;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String erp编码
	 */
	public void setErpCode(String erpCode) {
		this.erpCode = erpCode;
	}
	/**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 创建时间
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	/**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 更新时间
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 更新人
	 */
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段1
	 */
	public void setExtChar1(String extChar1) {
		this.extChar1 = extChar1;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段2
	 */
	public void setExtChar2(String extChar2) {
		this.extChar2 = extChar2;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段3
	 */
	public void setExtChar3(String extChar3) {
		this.extChar3 = extChar3;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段4
	 */
	public void setExtChar4(String extChar4) {
		this.extChar4 = extChar4;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段5
	 */
	public void setExtChar5(String extChar5) {
		this.extChar5 = extChar5;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段6
	 */
	public void setExtChar6(String extChar6) {
		this.extChar6 = extChar6;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段7
	 */
	public void setExtChar7(String extChar7) {
		this.extChar7 = extChar7;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段8
	 */
	public void setExtChar8(String extChar8) {
		this.extChar8 = extChar8;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段9
	 */
	public void setExtChar9(String extChar9) {
		this.extChar9 = extChar9;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段10
	 */
	public void setExtChar10(String extChar10) {
		this.extChar10 = extChar10;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段12
	 */
	public void setExtChar12(String extChar12) {
		this.extChar12 = extChar12;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段13
	 */
	public void setExtChar13(String extChar13) {
		this.extChar13 = extChar13;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段14
	 */
	public void setExtChar14(String extChar14) {
		this.extChar14 = extChar14;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段15
	 */
	public void setExtChar15(String extChar15) {
		this.extChar15 = extChar15;
	}
	
	@Column(name = "ext_char_16")
	public String getExtChar16() {
		return extChar16;
	}

	public void setExtChar16(String extChar16) {
		this.extChar16 = extChar16;
	}

	@Column(name = "ext_char_17")
	public String getExtChar17() {
		return extChar17;
	}

	public void setExtChar17(String extChar17) {
		this.extChar17 = extChar17;
	}

	@Column(name = "ext_char_18")
	public String getExtChar18() {
		return extChar18;
	}

	public void setExtChar18(String extChar18) {
		this.extChar18 = extChar18;
	}

	@Column(name = "ext_char_19")
	public String getExtChar19() {
		return extChar19;
	}

	public void setExtChar19(String extChar19) {
		this.extChar19 = extChar19;
	}

	@Column(name = "ext_char_20")
	public String getExtChar20() {
		return extChar20;
	}

	public void setExtChar20(String extChar20) {
		this.extChar20 = extChar20;
	}

	@Column(name = "ext_char_21")
	public String getExtChar21() {
		return extChar21;
	}

	public void setExtChar21(String extChar21) {
		this.extChar21 = extChar21;
	}

	@Column(name = "ext_char_22")
	public String getExtChar22() {
		return extChar22;
	}

	public void setExtChar22(String extChar22) {
		this.extChar22 = extChar22;
	}

	@Column(name = "ext_char_23")
	public String getExtChar23() {
		return extChar23;
	}

	public void setExtChar23(String extChar23) {
		this.extChar23 = extChar23;
	}

	@Column(name = "ext_char_24")
	public String getExtChar24() {
		return extChar24;
	}

	public void setExtChar24(String extChar24) {
		this.extChar24 = extChar24;
	}

	@Column(name = "ext_char_25")
	public String getExtChar25() {
		return extChar25;
	}

	public void setExtChar25(String extChar25) {
		this.extChar25 = extChar25;
	}
	@Column(name = "ext_char_26")
	public String getExtChar26() {
		return extChar26;
	}
	
	@Column(name = "ext_char_27")
	public String getExtChar27() {
		return extChar27;
	}

	@Column(name = "ext_char_28")
	public String getExtChar28() {
		return extChar28;
	}

	@Column(name = "ext_char_29")
	public String getExtChar29() {
		return extChar29;
	}

	@Column(name = "ext_char_30")
	public String getExtChar30() {
		return extChar30;
	}

	public void setExtChar26(String extChar26) {
		this.extChar26 = extChar26;
	}

	public void setExtChar27(String extChar27) {
		this.extChar27 = extChar27;
	}

	public void setExtChar28(String extChar28) {
		this.extChar28 = extChar28;
	}

	public void setExtChar29(String extChar29) {
		this.extChar29 = extChar29;
	}

	public void setExtChar30(String extChar30) {
		this.extChar30 = extChar30;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param  java.lang.Integer 数字扩展字段1
	 */
	public void setExtNumber1(Integer extNumber1) {
		this.extNumber1 = extNumber1;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param  java.lang.Integer 数字扩展字段2
	 */
	public void setExtNumber2(Integer extNumber2) {
		this.extNumber2 = extNumber2;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param  java.lang.Integer 数字扩展字段3
	 */
	public void setExtNumber3(Integer extNumber3) {
		this.extNumber3 = extNumber3;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param  java.lang.String 字符扩展字段11
	 */
	public void setExtChar11(String extChar11) {
		this.extChar11 = extChar11;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param  java.lang.Integer 数字扩展字段4
	 */
	public void setExtNumber4(Integer extNumber4) {
		this.extNumber4 = extNumber4;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param  java.lang.Integer 数字扩展字段5
	 */
	public void setExtNumber5(Integer extNumber5) {
		this.extNumber5 = extNumber5;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 合作状态
	 */
	@Column(name = "cooperative")
	public String getCooperative() {
		return cooperative;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 合作状态
	 */
	public void setCooperative(String cooperative) {
		this.cooperative = cooperative;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 省
	 */
	@Column(name = "province")
	public String getProvince() {
		return province;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.Stirng 省 
	 */
	public void setProvince(String province) {
		this.province = province;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 市
	 */
	@Column(name = "city")
	public String getCity() {
		return city;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 市
	 */
	public void setCity(String city) {
		this.city = city;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 区县
	 */
	@Column(name = "area")
	public String getArea() {
		return area;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 区县
	 */
	public void setArea(String area) {
		this.area = area;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 状态
	 */
	@Column(name = "enable_status")
	public Integer getEnableStatus(){
		return enableStatus;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 状态
	 */
	public void setEnableStatus(Integer enableStatus) {
		this.enableStatus = enableStatus;
	}
	/**
	 * 方法:取得 java.util.List<com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGEntity>
	 * @return java.util.List<com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGEntity> 
	 */
	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
	@JoinColumn(name = "terminal_id")
	@Fetch(FetchMode.SUBSELECT)
	public List<TmRTermCustPosBGEntity> getTmRTermCustPosBGList() {
		return tmRTermCustPosBGList;
	}
	/**
	 * 方法:设置 java.util.List<com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGEntity>
	 * @param  java.util.List<com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGEntity> 
	 */
	public void setTmRTermCustPosBGList(List<TmRTermCustPosBGEntity> tmRTermCustPosBGList) {
		this.tmRTermCustPosBGList = tmRTermCustPosBGList;
	}
	
	@Override
	public String businessDesc() {
		return "终端基本信息";
	}
	@Override
	public String addLogContent() {
		return null;
	}
	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		return null;
	}
	
}
