package com.biz.eisp.mdm.terminal.service;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.terminal.vo.TmTermCustPostVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;

/** 
 * 终端经销商职位对应关系service接口
 * @author 肖胜
 * @version v1.0
 */
public interface TmTermCustPostService extends BaseService {

	/**
	 * 条件查询终经销商职位对应关系端列表
	 * @param tmTermCustPostVo
	 * @param page
	 * @return
	 */
	public List<TmTermCustPostVo> findTmTermCustPostList(
			TmTermCustPostVo tmTermCustPostVo,Page page);
	
	/**
	 * 删除终端经销商职位对应关系信息
	 * @param tmTermCustPostVo
	 */
	public void deleteTmTermCustPost(TmTermCustPostVo tmTermCustPostVo);


	/**
	 * 条件查询经销商终端信息 未关联任何经销商的门店
	 * @param tmTermCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	public List<TmTerminalVo> findNotAnyCustTerminalList(TmTermCustPostVo tmTermCustPostVo,Page page);

	/**
	 * 条件查询经销商终端信息未关联当前经销商门店
	 * @param tmTermCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	public List<TmTerminalVo> findNotCurrCustTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page);

	/**
	 * 批量添加 终端与经销商对应关系
	 * @param terminalIds
	 * @param customerId
	 */
	public void addRelotaionForCustomerId(String terminalIds,String customerId);

	/**
	 * 批量解除 终端与经销商对应关系
	 * @param ids
	 */
	public List<TmTermCustPostVo> deleteRelotaionForCustomerId(String ids,Integer flag);

	/**
	 * 删除对应关系
	 * @param ids
	 */
	public List<TmTermCustPostVo> deleteTmRCustTermPost(String ids);

	/**
	 * 替换 终端与经销商对应关系
	 * @param relationIds 对应关系主键ids
	 * @param customerId  新的客户id
	 */
	public List<TmTermCustPostVo> updateCustTerminalRelation(String relationIds,String customerId);

	/**
	 * 选择新的客户编码 替换经销商与终端对应关系
	 * @param tmTermCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	public List<TmCustomerVo> findCustomerBySelect(TmTermCustPostVo tmTermCustPostVo, Page page);

	/**
	 * 条件查询经销商终端信息 未关联任何职位的门店
	 * @param tmTermCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	public List<TmTerminalVo> findNotAnyPostTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page);

	/**
	 * 条件查询经销商终端信息未关联当前职位门店
	 * @param tmTermCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	public List<TmTerminalVo> findNotCurrPostTerminalList(TmTermCustPostVo tmTermCustPostVo,Page page);

	/**
	 * 选择新的客户编码 替换经销商与终端对应关系
	 * @param tmTermCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	public List<TmPositionVo> findPostionBySelect(TmTermCustPostVo tmTermCustPostVo, Page page);

	/**
	 * 批量添加 终端与经销商对应关系
	 * @param terminalIds
	 * @param positionId
	 */
	public void addRelotaionForPositionId(String terminalIds,String positionId);


	/**
	 * 替换 终端与经销商对应关系
	 * @param relationIds 对应关系主键ids
	 * @param positionId  新的职位id
	 */
	public void updatePostTerminalRelation(String relationIds,String positionId);
}
