package com.biz.eisp.mdm.terminal.service;

import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.terminal.vo.TmTermCustPostVo;

import java.util.List;

public interface TmTerminalCustPostExtendService extends BaseService {

    /**
     * 删除终端与经销商职位对应关系后操作
     */
    void afterDeleteTmTermCustPost(TmTermCustPostVo termCustPostVo);

    /**
     * 批量添加终端与客户对应关系后操作
     */
    void afterAddRelotaionForCustomerId(String terminalIds,String customerId);

    /**
     * 批量解除终端与客户对应关系后操作
     * @param ids 终端vo对象
     * @param flag 1表示客户批量调整 2表示职位批量调整
     */
    void afterDeleteRelotaion(List<TmTermCustPostVo> result, Integer flag);

    /**
     * 批量解除终端与客户对应关系
     * @param ids 终端vo对象
     */
    void afterDeleteTmRCustTermPost(List<TmTermCustPostVo> result);


    /**
     * 替换 终端与经销商对应关系
     * @param relationIds 对应关系主键ids
     * @param customerId  新的客户id
     */
    void afterUpdateCustTerminalRelation(List<TmTermCustPostVo> result,String customerId);


    /**
     * 批量添加终端与客户对应关系
     * @param terminalIds 终端vo对象
     * @param positionId 职位ID
     */
    void afterAddRelotaionForPositionId(String terminalIds,String positionId);

    /**
     * 替换 终端与经销商对应关系
     * @param relationIds 对应关系主键ids
     * @param positionId  新的职位id
     */
    void afterUpdatePostTerminalRelation(String relationIds,String positionId);

}
