package com.biz.eisp.mdm.terminal.service;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;

/** 
 * 终端删除扩展接口定义.
 * <p>
 * 终端删除或者编辑的扩展,如需扩展则需要实现该接口.
 * @author Sean (2017-09-21)
 * @version v1.0
 */
public interface TmTerminalDelExtendService extends BaseService{
	/**
	 * 验证删除数据.
	 * @author 
	 * 			 Sean
	 * @param page
	 * 			 页面对象
	 * @return 验证失败throw new BusinessException("失败内容")
	 */
	 void validate(TmTerminalEntity entity, Page page);

	/**
	 * 删除终端信息前操作（已经做了vo到Entity的转换操作）.
	 * @author 
	 * 			Sean
	 * @param entity
	 *          vo转换成Entity的值，该Entity，如果是新增操作即为游离态，修改操作即为持久态
	 * @param page
	 *            页面对象
	 * @return 返回Entity后，系统即删除返回的Entity。
	 */
	void delBefore(TmTerminalEntity entity, Page page);

	/**
	 * 删除终端后操作.
	 * <p>
	 * @author Sean
	 * @param entity
	 *            删除后的Entity对象，该Entity状态为持久态
	 * @param page
	 *            页面对象
	 * @return 返回Entity后，后面的其他操作，都会使用该Entity
	 */
	void delPost(TmTerminalEntity entity, Page page);
}
