package com.biz.eisp.mdm.terminal.service;

import java.util.List;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.terminal.vo.QueryTmTerminalVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;

/** 
 * 终端管理service接口
 * @author 肖胜
 * @version v1.0
 */
public interface TmTerminalService extends BaseService {

	/**
	 * 条件查询终端列表
	 * @param tmTerminalVo
	 * @param page
	 * @return
	 */
	public List<TmTerminalVo> findTmTerminalList(TmTerminalVo tmTerminalVo,Page page);
	
	/**
	 * 根据 id条件查询终端信息
	 * @param tmTerminalVo
	 * @return
	 */
	public TmTerminalVo getTmTerminal(TmTerminalVo tmTerminalVo, Page page);
	
	/**
	 * 保存终端信息
	 * @param tmTerminalVo 终端vo
	 * @param page 页面对象
	 * return 终端编码
	 */
	public String saveTmTerminal(TmTerminalVo tmTerminalVo, Page page);
	
	/**
	 * 删除终端信息
	 * @param ids
	 */
	public AjaxJson deleteTmTerminal(String ids, Page page);
	
	/**
	 * 通过其他vo参数查询终端.
	 * @author grover
	 * @param terminalVo 终端vo对象
	 * @param page 分页
	 * @return 终端信息
	 */
	List<TmTerminalVo> findTmTerminalByPosList(TmTerminalVo terminalVo, Page page);
	
	/**
	 * 查看客户日志
	 * @param tmLogVo
	 * @param page
	 * @return
	 */
	@Arguments({"tmLogVo","page"})
	@ResultType(TmLogVo.class)
	public List<TmLogVo> findTerminalLogList(TmLogVo tmLogVo, Page page);
	
	/**
	 * 终端相关接口 - 主要对外.
	 * <p>该接口提供了所有可能查询终端的方式.<br>
	 * 0、无参数 terminalName终端名称，terminalCode终端编码，
	 * 	cooperative终端状态 terminalType终端类型 模糊查询.<br>
	 * 1、当前职位信息  所需参数：id职位id.<br>
	 * 2、职位直管的终端信息  所需参数：positionId职位id 或者 positionName职位名称.<br>
	 * 3、职位及职位下级的终端信息  所需参数：levelAllPositionId职位id.<br>
	 * 4、组织直管的终端信息  所需参数：orgId组织id 或者 orgName组织名称. <br>
	 * 5、组织及组织下级的终端信息  所需参数：levelAllOrgId组织id.<br>
	 * 6、某客户下的终端信息  所需参数：customerId客户id 或者 customerName客户名称.<br>
	 * 7、某经销商用户下的终端信息  所需参数：userId用户id 或者 fullName用户名称.<br>
	 * @author grover
	 * @param queryTmTerminalVo 查询方式vo
	 * @param page 分页对象 如果不分页传入一个null
	 * @return 终端vo集合
	 */
	List<TmTerminalVo> findTmTerminalByAllPossible(QueryTmTerminalVo queryTmTerminalVo, Page page);
	/**
	 * 根据终端类型获取终端和上级客户.
	 * <p>该接口提供dms查询终端和客户信息.<br>
	 * @author grover
	 * @param queryTmTerminalVo 查询方式vo
	 * @param page 分页对象 如果不分页传入一个null
	 * @return 终端查询vo集合
	 */
	List<QueryTmTerminalVo> findTmTerminalAndCustByterminalType(QueryTmTerminalVo queryTmTerminalVo, Page page);
}
