package com.biz.eisp.mdm.terminal.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.terminal.dao.TmTermCustPostDao;
import com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGEntity;
import com.biz.eisp.mdm.terminal.service.TmTermCustPostService;
import com.biz.eisp.mdm.terminal.vo.TmTermCustPostVo;

import jodd.util.StringUtil;

/** 
 * 终端管理service实现
 * @author 肖胜
 * @version v1.0
 */
@Service("tmTermCustPostService")
@Transactional
public class TmTermCustPostServiceImpl extends BaseServiceImpl implements TmTermCustPostService{

	@Autowired
	private TmTermCustPostDao tmTermCustPostDao;
	
	@Override
	public List<TmTermCustPostVo> findTmTermCustPostList(
			TmTermCustPostVo tmTermCustPostVo,Page page) {
		if(page==null){
			return tmTermCustPostDao.findTermCustPostList(tmTermCustPostVo);
		}
		return tmTermCustPostDao.findTermListByCustomerId(tmTermCustPostVo,page);
	}

	@Override
	public void deleteTmTermCustPost(TmTermCustPostVo tmTermCustPostVo) {
		
		if(StringUtil.isEmpty(tmTermCustPostVo.getId())){
			throw new BusinessException("删除终端与经销商岗位对应关系时，"
					+ "主键ID找不到:" + tmTermCustPostVo.getId());
		}
		TmRTermCustPosBGEntity tmTermCustPostEntity=
				this.get(TmRTermCustPosBGEntity.class, tmTermCustPostVo.getId());
		tmTermCustPostVo.setTerminalCode(tmTermCustPostEntity.getTmTerminal().getTerminalCode());
		tmTermCustPostVo.setCustomerCode(tmTermCustPostEntity.getTmCustomer().getCustomerCode());
		this.delete(tmTermCustPostEntity);
	}

	@Override
	public List<TmTerminalVo> findNotAnyCustTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page) {
		return tmTermCustPostDao.findNotAnyCustTerminalList(tmTermCustPostVo, page);
	}

	@Override
	public List<TmTerminalVo> findNotCurrCustTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page) {
		return tmTermCustPostDao.findNotCurrCustTerminalList(tmTermCustPostVo, page);
	}

	@Override
	public void addRelotaionForCustomerId(String terminalIds, String customerId) {
		if(StringUtil.isEmpty(terminalIds)&&StringUtil.isEmpty(customerId)){
			throw new BusinessException("参数错误");
		}

		String[] ids=terminalIds.split(",");
		TmCustomerEntity tmCustomerEntity=this.get(TmCustomerEntity.class,customerId);
		TmTerminalEntity tmTerminalEntity=null;
		String hql="from TmRTermCustPosBGEntity where tmTerminal.id=? and tmCustomer.id=?";
		for(String terminalId:ids){
			tmTerminalEntity=this.get(TmTerminalEntity.class,terminalId);
			//校验是否重复
			List<TmRTermCustPosBGEntity> tmRTermCustPosBGEntities=this.findByHql(hql,terminalId,customerId);
			if(CollectionUtil.listNotEmptyNotSizeZero(tmRTermCustPosBGEntities)){
				continue;
			}
			//保存
			TmRTermCustPosBGEntity tmRTermCustPosBGEntity=new TmRTermCustPosBGEntity();
			tmRTermCustPosBGEntity.setTmCustomer(tmCustomerEntity);
			tmRTermCustPosBGEntity.setTmTerminal(tmTerminalEntity);
			this.save(tmRTermCustPosBGEntity);

			//保存日志
			String content="上级客户批量调整,关联上级客户:<b>"+tmCustomerEntity.getCustomerName()+"</b>";
			this.addLog(OperationType.INSERT,"终端与客户对应关系",terminalId,content);
		}
	}

	@Override
	public List<TmTermCustPostVo> deleteRelotaionForCustomerId(String ids,Integer flag){
		if(StringUtil.isEmpty(ids)){
			throw new BusinessException("参数错误");
		}

		String[] idArray=ids.split(",");
		List<TmTermCustPostVo> result = new ArrayList<>();
		for(String id:idArray){
			TmTermCustPostVo termCustPostVo = new TmTermCustPostVo();
			TmRTermCustPosBGEntity tmRTermCustPosBGEntity=this.get(TmRTermCustPosBGEntity.class,id);
			termCustPostVo.setId(id);
			termCustPostVo.setCustomerCode(tmRTermCustPosBGEntity.getTmCustomer().getCustomerCode());
			termCustPostVo.setTerminalCode(tmRTermCustPosBGEntity.getTmTerminal().getTerminalCode());
			result.add(termCustPostVo);

			String content="";
			if(flag!=null&&flag==1){//客户批量操作 当前关系对应职位为空 则删除 否则 更新
				content="终端上级客户批量调整,取消关联上级客户:<b>"+tmRTermCustPosBGEntity.getTmCustomer().getCustomerName()+"</b>";//保存日志
				if(tmRTermCustPosBGEntity.getTmPosition()==null){
					//执行删除
					this.delete(tmRTermCustPosBGEntity);
				}else{
					tmRTermCustPosBGEntity.setTmCustomer(null);
					this.updateEntity(tmRTermCustPosBGEntity);
				}
			}else{//职位批量操作 当前关系对应上级客户为空 则删除 否则 更新

				content="终端对接人职位批量调整,取消关联对接人职位:<b>"+tmRTermCustPosBGEntity.getTmPosition().getPositionName()+"</b>";
				if(tmRTermCustPosBGEntity.getTmCustomer()==null){
					//执行删除
					this.delete(tmRTermCustPosBGEntity);
				}else{
					tmRTermCustPosBGEntity.setTmPosition(null);
					this.updateEntity(tmRTermCustPosBGEntity);
				}
			}
			this.addLog(OperationType.DELETE,"终端与客户对应关系",tmRTermCustPosBGEntity.getTmTerminal().getId(),content);
		}
		return result;
	}

	@Override
	public List<TmTermCustPostVo> deleteTmRCustTermPost(String ids) {
		if(StringUtil.isEmpty(ids)&&StringUtil.isEmpty(ids)){
			throw new BusinessException("参数错误");
		}

		List<TmTermCustPostVo> result = new ArrayList<>();
		String[] idArray=ids.split(",");
		for(String id:idArray) {
			TmRTermCustPosBGEntity tmRTermCustPosBGEntity = this.get(TmRTermCustPosBGEntity.class, id);
			TmTermCustPostVo termCustPostVo = new TmTermCustPostVo();
			termCustPostVo.setId(tmRTermCustPosBGEntity.getId());
			termCustPostVo.setTerminalCode(tmRTermCustPosBGEntity.getTmTerminal().getTerminalCode());
			termCustPostVo.setCustomerCode(tmRTermCustPosBGEntity.getTmCustomer().getCustomerCode());
			result.add(termCustPostVo);

			this.delete(tmRTermCustPosBGEntity);
		}
		return result;
	}

	@Override
	public List<TmTermCustPostVo> updateCustTerminalRelation(String relationIds, String customerId) {
		if(StringUtil.isEmpty(relationIds)&&StringUtil.isEmpty(customerId)){
			throw new BusinessException("参数错误");
		}
		String[] ids=relationIds.split(",");
		String hql="from TmRTermCustPosBGEntity where tmTerminal.id=? and tmCustomer.id=?";
		TmCustomerEntity tmCustomerEntity=this.get(TmCustomerEntity.class,customerId);
		TmRTermCustPosBGEntity tmRTermCustPosBGEntity=null;

		List<TmTermCustPostVo> result = new ArrayList<>();
		for(String id:ids){
			tmRTermCustPosBGEntity=this.get(TmRTermCustPosBGEntity.class,id);
			TmTermCustPostVo termCustPostVo = new TmTermCustPostVo();
			termCustPostVo.setId(id);
			termCustPostVo.setTerminalCode(tmRTermCustPosBGEntity.getTmTerminal().getTerminalCode());
			termCustPostVo.setCustomerCode(tmRTermCustPosBGEntity.getTmCustomer().getCustomerCode());
			result.add(termCustPostVo);

			//校验是否重复
			List<TmRTermCustPosBGEntity> tmRTermCustPosBGEntities=this.findByHql(hql,tmRTermCustPosBGEntity.getTmTerminal().getId(),customerId);
			if(CollectionUtil.listNotEmptyNotSizeZero(tmRTermCustPosBGEntities)){
				continue;
			}
			//保存日志
			String content="上级客户批量调整,关联上级客户:<b>"+tmCustomerEntity.getCustomerName()+"</b>";;
			if(tmRTermCustPosBGEntity.getTmCustomer()!=null){
				content="上级客户替换,原上级客户:<b>"+tmRTermCustPosBGEntity.getTmCustomer().getCustomerName()
						+"</b>替换为<b>"+tmCustomerEntity.getCustomerName()+"<b>";
			}

			this.addLog(OperationType.UPDATE,"终端与客户对应关系",tmRTermCustPosBGEntity.getTmTerminal().getId(),content);

			//更新
			tmRTermCustPosBGEntity.setTmCustomer(tmCustomerEntity);
			this.updateEntity(tmRTermCustPosBGEntity);
		}

		return result;
	}

	@Override
	public List<TmCustomerVo> findCustomerBySelect(TmTermCustPostVo tmTermCustPostVo, Page page) {
		return tmTermCustPostDao.findCustomerBySelect(tmTermCustPostVo,page);
	}

	@Override
	public List<TmTerminalVo> findNotAnyPostTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page) {
		return tmTermCustPostDao.findNotAnyPostTerminalList(tmTermCustPostVo, page);
	}

	@Override
	public List<TmTerminalVo> findNotCurrPostTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page) {
		return tmTermCustPostDao.findNotCurrPostTerminalList(tmTermCustPostVo, page);
	}

	@Override
	public List<TmPositionVo> findPostionBySelect(TmTermCustPostVo tmTermCustPostVo, Page page) {
		return tmTermCustPostDao.findPositionBySelect(tmTermCustPostVo, page);
	}

	@Override
	public void addRelotaionForPositionId(String terminalIds, String positionId) {
		if(StringUtil.isEmpty(terminalIds)&&StringUtil.isEmpty(positionId)){
			throw new BusinessException("参数错误");
		}

		String[] ids=terminalIds.split(",");
		TmPositionEntity tmPositionEntity=this.get(TmPositionEntity.class,positionId);
		TmTerminalEntity tmTerminalEntity=null;
		String hql="from TmRTermCustPosBGEntity where tmTerminal.id=? and tmPosition.id=?";
		for(String terminalId:ids){
			tmTerminalEntity=this.get(TmTerminalEntity.class,terminalId);
			//校验是否重复
			List<TmRTermCustPosBGEntity> tmRTermCustPosBGEntities=this.findByHql(hql,terminalId,positionId);
			if(CollectionUtil.listNotEmptyNotSizeZero(tmRTermCustPosBGEntities)){
				continue;
			}
			//保存
			TmRTermCustPosBGEntity tmRTermCustPosBGEntity=new TmRTermCustPosBGEntity();
			tmRTermCustPosBGEntity.setTmPosition(tmPositionEntity);
//			tmRTermCustPosBGEntity.setBusinessGroup(tmPositionEntity.getBusinessGroup());
			tmRTermCustPosBGEntity.setTmTerminal(tmTerminalEntity);
			this.save(tmRTermCustPosBGEntity);

			//保存日志
			String content="终端对接人职位批量调整,关联对接人职位:<b>"+tmPositionEntity.getPositionName()+"</b>";
			this.addLog(OperationType.INSERT,"终端与职位对应关系",terminalId,content);
		}
	}

	@Override
	public void updatePostTerminalRelation(String relationIds, String positionId) {
		if(StringUtil.isEmpty(relationIds)&&StringUtil.isEmpty(positionId)){
			throw new BusinessException("参数错误");
		}
		String[] ids=relationIds.split(",");
		TmPositionEntity tmPositionEntity=this.get(TmPositionEntity.class,positionId);
		TmRTermCustPosBGEntity tmRTermCustPosBGEntity=null;
		String hql="from TmRTermCustPosBGEntity where tmTerminal.id=? and tmPosition.id=?";
		for(String id:ids){
			tmRTermCustPosBGEntity=this.get(TmRTermCustPosBGEntity.class,id);
			//校验是否重复
			List<TmRTermCustPosBGEntity> tmRTermCustPosBGEntities=this.findByHql(hql,tmRTermCustPosBGEntity.getTmTerminal().getId(),positionId);
			if(CollectionUtil.listNotEmptyNotSizeZero(tmRTermCustPosBGEntities)){
				continue;
			}
			//保存日志
			String content="终端对接人职位批量调整,关联对接人职位:<b>"+tmPositionEntity.getPositionName()+"</b>";
			if(tmRTermCustPosBGEntity.getTmPosition()!=null){
				 content="终端对接人职位替换,原对接人职位:<b>"+tmRTermCustPosBGEntity.getTmPosition().getPositionName()
						+"</b>替换为<b>"+tmPositionEntity.getPositionName()+"<b>";
			}

			this.addLog(OperationType.UPDATE,"终端与职位对应关系",tmRTermCustPosBGEntity.getTmTerminal().getId(),content);

			//更新
			tmRTermCustPosBGEntity.setTmPosition(tmPositionEntity);
			this.updateEntity(tmRTermCustPosBGEntity);
		}
	}

}
