package com.biz.eisp.mdm.terminal.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.terminal.service.TmTerminalBackExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalService;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;

/**
 * 终端信息excel导入 
 * @author 肖胜
 * @version v1.0
 */
public class TmTerminalEventHandler extends ImpEventHandler <TmTerminalVo>{
	
	private TmTerminalService tmTerminalService = null;

	private TmTerminalBackExtendService tmTerminalBackExtendService;

	private List<String> saveIdList;

	public TmTerminalEventHandler() {
		tmTerminalService =(TmTerminalService) ApplicationContextUtils
				.getContext().getBean("tmTerminalService");

		String[] beanNamesForBackExtendService = ApplicationContextUtils.getContext().getBeanNamesForType(TmTerminalBackExtendService.class);
		if (beanNamesForBackExtendService.length > 0){
			tmTerminalBackExtendService = ApplicationContextUtils.getContext().getBean(beanNamesForBackExtendService[0],TmTerminalBackExtendService.class);
		}

		saveIdList = Collections.synchronizedList(new ArrayList<>());
	}

	@Override
	public void endRow(Map<String, Object> row, TmTerminalVo bean) throws ValidateException {
		try {
			//执行保存
			Page page = new EuPage();
			String id = tmTerminalService.saveTmTerminal(bean, page);
			saveIdList.add(id);
		} catch (Exception e) {
			addError("第"+getRowNumber()+"行遇到错误:"+e.getMessage());
			e.printStackTrace();
		}
		//设置已成功导入条数
		setSuccNum(getSuccNum()+1);
	}

	@Override
	public void impEnd() {
		if (null != tmTerminalBackExtendService){
			tmTerminalBackExtendService.afterImportTmTerminal(saveIdList);
		}
	}
}
