package com.biz.eisp.mdm.terminal.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.terminal.dao.TmTerminalDao;
import com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGDetailEntity;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.service.TmTerminalDelExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalSearchExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalService;
import com.biz.eisp.mdm.terminal.transformer.TmTerminalVoToTmTerminalEntity;
import com.biz.eisp.mdm.terminal.util.TerminalLogMsgUtil;
import com.biz.eisp.mdm.terminal.vo.QueryTmTerminalVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * 终端管理service实现
 * @author 肖胜
 * @version v1.0
 */
@Service("tmTerminalService")
@Transactional
public class TmTerminalServiceImpl extends BaseServiceImpl implements TmTerminalService{
	/**
	 * 注入dao.
	 */
	@Autowired
	private TmTerminalDao tmTerminalDao;
	/**
	 * 注入扩展service.R
	 */
	@Autowired(required=false)
	private TmTerminalExtendService terminalExtendService;

	@Autowired(required=false)
	private TmTerminalSearchExtendService tmTerminalSearchExtendService;

	@Autowired(required=false)
	private TmTerminalDelExtendService tmTerminalDelExtendService;

	@Override
	public List<TmTerminalVo> findTmTerminalList(TmTerminalVo tmTerminalVo, Page page) {
		String sql="";

		List<TmTerminalVo> result = null;
		if(tmTerminalSearchExtendService!=null){
			sql=tmTerminalSearchExtendService.buildSearchSql(tmTerminalVo);
			if(StringUtil.isEmpty(sql)){
				sql=DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_TERMINAL, tmTerminalVo);
				sql=tmTerminalSearchExtendService.extendSearchSql(tmTerminalVo,sql);
			}
			result = tmTerminalDao.findTerminalList(tmTerminalVo, page, sql);
			return tmTerminalSearchExtendService.afterSearch(result);
		}else{
			sql=DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_TERMINAL, tmTerminalVo);
			sql=this.appendTerminalCondition(sql, tmTerminalVo);
			return tmTerminalDao.findTerminalList(tmTerminalVo, page, sql);
		}
	}

	/**
	 * 终端添加非本数据表字段查询条件
	 * @param sql
	 * @param terminalVo
	 * @return
	 */
	public String  appendTerminalCondition(String sql,TmTerminalVo terminalVo){

		//关联了终端与客户与职位业务组对应关系表、客户信息表、职位表、职位与用户对应关系表、用户表
		String joinSql="";

		String sqlOn=" ";
		String sqlWhere="";
		//id查询
		if(StringUtil.isNotEmpty(terminalVo.getId())){
			sqlWhere=" and (t.id='"+terminalVo.getId()+"'";
		}
		if (StringUtil.isEmpty(terminalVo.getId()) ||StringUtil.isNotEmpty(terminalVo.getDockUserName())||StringUtil.isNotEmpty(terminalVo.getDockPosition())
				||StringUtil.isNotEmpty(terminalVo.getBusinessGroup())||StringUtil.isNotEmpty(terminalVo.getCustomerName())){
			sqlWhere="and exists(select 1 from tm_terminal t2 left join TM_R_TERM_CUST_POS_BG t3 on t3.terminal_id=t2.id" +
					" left join tm_r_user_position up on up.position_id=t3.position_id left join tm_user tu on tu.id=up.user_id" +
					" left join tm_position t4 on t4.id = t3.position_id " +
					" left join tm_customer tc on tc.id=t3.customer_id  where t2.id=t.id ";
		}
		//页面自定义对接人姓名查询条件
		if(StringUtil.isNotEmpty(terminalVo.getDockUserName())){

			sqlWhere+=" and  (tu.fullname like '%"+terminalVo.getDockUserName()+"%' "
					+ " or tu.fullname like '%" + terminalVo.getDockUserName() + "%')";
		}
		//页面自定义对接人职位查询条件
		if(StringUtil.isNotEmpty(terminalVo.getDockPosition())){
			sqlWhere+= "and (t4.position_name like '%"+terminalVo.getDockPosition()+"%'"
					+ "or t4.position_code like '%" + terminalVo.getDockPosition() + "%')";;
		}
		//页面自定义业务组查询条件
		if(StringUtil.isNotEmpty(terminalVo.getBusinessGroup())){
			sqlWhere+=" and t3.business_group like '%"+terminalVo.getBusinessGroup()+"%'";
		}
		//页面自定义上级客户查询条件
		if(StringUtil.isNotEmpty(terminalVo.getCustomerName())){
			sqlWhere+= "and (tc.customer_name like '%"+terminalVo.getCustomerName()+"%' or tc.customer_code like '%"+terminalVo.getCustomerName()+"%')";
		}
		sqlWhere+=")";

		//不包含查询条件则不添加
		if(StringUtil.isEmpty(terminalVo.getId())&&
				StringUtil.isEmpty(terminalVo.getDockUserName())&&
				StringUtil.isEmpty(terminalVo.getDockPosition())&&
				StringUtil.isEmpty(terminalVo.getCustomerName())&&
				StringUtil.isEmpty(terminalVo.getBusinessGroup())){
			sqlWhere="";
		}

		String orderSql=" order by t.createDate DESC";
		return DynamicConfigUtil.getInstance().appendCustomCondition(sql, joinSql, sqlOn, sqlWhere,orderSql);
	}
	@Override
	public String saveTmTerminal(TmTerminalVo tmTerminalVo, Page page) {
		List <TmBusinessGroupVo> addBusinessGroupVoList = new ArrayList<TmBusinessGroupVo>(); //初始化新增业务组信息
		List <TmBusinessGroupVo> deleteBusinessGroupVoList = new ArrayList<TmBusinessGroupVo>(); //初始化要删除的业务组信息

		TmTerminalEntity terminalEntity = null;
		//保存前扩展 此时entity还未通过vo转换
		if(StringUtil.isNotEmpty(terminalExtendService)){
			//验证
			try {
				terminalExtendService.validate(tmTerminalVo, page);
			} catch (Exception e) {
				throw new BusinessException("验证数据失败:"+e.getMessage());
			}
			//扩展
			terminalEntity = terminalExtendService.saveBefore(tmTerminalVo, page);
		}
		//如果entity为null 则通过vo转换
		if (StringUtil.isEmpty(terminalEntity)) {
			terminalEntity = new TmTerminalVoToTmTerminalEntity(this, addBusinessGroupVoList, deleteBusinessGroupVoList).apply(tmTerminalVo);
		}
		//保存前扩展 此时entity已经通过vo转换
		if(StringUtil.isNotEmpty(terminalExtendService)){
			terminalEntity = terminalExtendService.saveBefore(terminalEntity, tmTerminalVo, page);
		}
		//保存
		this.saveOrUpdate(terminalEntity);

		executeSql("DELETE FROM TM_R_TERM_CUST_POS_BG WHERE TERMINAL_ID IS NULL");

		this.getSession().flush();
		//保存业务组信息
		this.saveBusinessGroupInfo(terminalEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);

		//保存后扩展
		if(StringUtil.isNotEmpty(terminalExtendService)){
			terminalEntity = terminalExtendService.savePost(terminalEntity, tmTerminalVo, page);
		}

		if (null != terminalEntity){
			return terminalEntity.getId();
		}
		return null;
	}

	/**
	 * 保存业务组信息.
	 * <p>
	 * @param addBusinessGroupVoList //要新增的业务信息
	 * @param deleteBusinessGroupVoList //要删除的业务信息
	 */
	private void saveBusinessGroupInfo(TmTerminalEntity tmTerminalEntity, List <TmBusinessGroupVo> addBusinessGroupVoList,
									   List <TmBusinessGroupVo> deleteBusinessGroupVoList) {
		//删除原来的关系数据
		if(CollectionUtil.listNotEmptyNotSizeZero(deleteBusinessGroupVoList)) {
			Map <String, String> map = new HashMap<String, String>();
			for(TmBusinessGroupVo vo : deleteBusinessGroupVoList) {
				map.put(vo.getBusinessGroup(), vo.getBusinessGroup());
			}

			String deleteSql = "delete from tm_r_term_cust_pos_bg_detail where business_group = ?";

			Set <String> keyset = map.keySet();
			for(Iterator <String>iter = keyset.iterator(); iter.hasNext();) {
				String key = iter.next();
				this.executeSql(deleteSql, key);
			}
		}

		this.getSession().flush();

		//保存新的关系数据
		if(CollectionUtil.listNotEmptyNotSizeZero(addBusinessGroupVoList)) {
			for(TmBusinessGroupVo vo : addBusinessGroupVoList) {
				if(vo.getTypeCode() != "orgCode" && vo.getTypeCode() != "positionCode" && vo.getTypeCode() != "customerCode") {
					TmRTermCustPosBGDetailEntity entity = new TmRTermCustPosBGDetailEntity();
					entity.setBusinessGroup(vo.getBusinessGroup());
					entity.setDetailCode(vo.getDetailCode());
					entity.setDetailName(vo.getDetailName());
					entity.setTypeCode(vo.getTypeCode());
					entity.setTypeName(vo.getTypeName());
					this.save(entity);
				}
			}
		}

		this.getSession().flush();

		this.saveBusinessGroupLog(tmTerminalEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
	}

	/**
	 * 保存业务组日志信息.
	 * <p>
	 * @param newBusinessGroupVoList
	 * @param oldBusinessGroupVoList
	 */
	private void saveBusinessGroupLog(TmTerminalEntity tmTerminalEntity, List <TmBusinessGroupVo> newBusinessGroupVoList,
									  List <TmBusinessGroupVo> oldBusinessGroupVoList) {
		Map <String, List <TmBusinessGroupVo>> oldMap = this.buildMapByBusinessGroup(oldBusinessGroupVoList);
		Map <String, List <TmBusinessGroupVo>> newMap = this.buildMapByBusinessGroup(newBusinessGroupVoList);

		Set <String>oldKeySet= oldMap.keySet();

		String updateMsg = "";
		String deleteMsg = "";
		String addMsg = "";

		for(Iterator <String>iter = oldKeySet.iterator(); iter.hasNext();) {
			String oldKey = iter.next();
			if(newMap.containsKey(oldKey)) { //修改的情况
				updateMsg += TerminalLogMsgUtil.buildUpdateMsg(newMap.get(oldKey), oldMap.get(oldKey)) + "<hr>";
				newMap.remove(oldKey);
			} else { //删除的情况
				deleteMsg += TerminalLogMsgUtil.buildDeleteMsg(oldMap.get(oldKey)) + "<hr>";
			}
		}
		addMsg += this.buildAddMsg(tmTerminalEntity, newMap);

		if(StringUtils.isNotBlank(addMsg)) {
			this.addLog(OperationType.INSERT, "业务组关系", tmTerminalEntity.getId(), addMsg);
		}
		if(StringUtils.isNotBlank(deleteMsg)) {
			this.addLog(OperationType.DELETE, "业务组关系", tmTerminalEntity.getId(), deleteMsg);
		}
		if(StringUtils.isNotBlank(updateMsg)) {
			this.addLog(OperationType.UPDATE, "业务组关系", tmTerminalEntity.getId(), updateMsg);
		}
	}

	/**
	 * 按照businessgroup汇总数据到Map上.
	 * <p>
	 * @param voList
	 * @return
	 */
	private Map<String , List<TmBusinessGroupVo>> buildMapByBusinessGroup(List <TmBusinessGroupVo> voList) {
		Map <String , List<TmBusinessGroupVo>> map = new HashMap<String , List<TmBusinessGroupVo>>();
		if(CollectionUtil.listNotEmptyNotSizeZero(voList)) {
			for(TmBusinessGroupVo oldBusinessGroupVo : voList) {
				if(map.containsKey(oldBusinessGroupVo.getBusinessGroup())) {
					map.get(oldBusinessGroupVo.getBusinessGroup()).add(oldBusinessGroupVo);
				} else {
					List <TmBusinessGroupVo> list = new ArrayList <TmBusinessGroupVo>();
					list.add(oldBusinessGroupVo);
					map.put(oldBusinessGroupVo.getBusinessGroup(), list);
				}
			}
		}
		return map;
	}

	/**
	 * 构造新增日志信息.
	 * <p>
	 * @param tmTerminalEntity
	 * @param newMap
	 * @return
	 */
	private String buildAddMsg(TmTerminalEntity tmTerminalEntity, Map <String, List <TmBusinessGroupVo>> newMap) {
		Set <String> keySet = newMap.keySet();
		String msg = "";
		for(Iterator <String>iter = keySet.iterator(); iter.hasNext();) {
			String key = iter.next();
			msg += TerminalLogMsgUtil.buildAddMsg(newMap.get(key));
			msg += "<hr>";
		}
		return msg;
	}

	@Override
	public AjaxJson deleteTmTerminal(String ids, Page page) {
		AjaxJson json = new AjaxJson();
		Map<String,Object> attributes = new HashMap<>();
		List<String> terminalCodeList = new ArrayList<>();
		if(StringUtil.isNotEmpty(ids)){
			String[] terminalIds=ids.split(",");
			for(String terminalId:terminalIds){
				TmTerminalEntity terminalEntity=this.get(TmTerminalEntity.class,terminalId);
				if(tmTerminalDelExtendService!=null){
					tmTerminalDelExtendService.validate(terminalEntity,page);
					tmTerminalDelExtendService.delBefore(terminalEntity,page);
				}
				if(terminalEntity!=null&&StringUtil.isNotEmpty(terminalEntity.getId())){
					terminalCodeList.add(terminalEntity.getTerminalCode());
					this.delete(terminalEntity);
					if(tmTerminalDelExtendService!=null){
						tmTerminalDelExtendService.delPost(terminalEntity,page);
					}
				}
			}
		}
		attributes.put("terminalCodeList",terminalCodeList);
		json.setAttributes(attributes);
		return json;
	}

	@Override
	public TmTerminalVo getTmTerminal(TmTerminalVo tmTerminalVo, Page page) {
		List<TmTerminalVo>list=this.findTmTerminalList(tmTerminalVo, page);
		return  list.size()>0?list.get(0):new TmTerminalVo();
	}

	@Override
	public List<TmTerminalVo> findTmTerminalByPosList(TmTerminalVo terminalVo, Page page) {
		return tmTerminalDao.findTmTerminalByPosList(terminalVo, page);
	}

	@Override
	public List<TmTerminalVo> findTmTerminalByAllPossible(
			QueryTmTerminalVo queryTmTerminalVo, Page page) {
		return tmTerminalDao.findTmTerminalByAllPossible(queryTmTerminalVo, page);
	}

	@Override
	public List<TmLogVo> findTerminalLogList(TmLogVo tmLogVo, Page page) {
		return tmTerminalDao.findTerminalLogList(tmLogVo, page);
	}

	@Override
	public List<QueryTmTerminalVo> findTmTerminalAndCustByterminalType(
			QueryTmTerminalVo queryTmTerminalVo, Page page) {

		return tmTerminalDao.findTmTerminalAndCustByterminalType(queryTmTerminalVo, page);
	}

}
