package com.biz.eisp.mdm.terminal.transformer;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.generatednum.num.util.TbNumRuleProvider;
import com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.util.ValidateUtil;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.product.entity.TmProductEntity;
import com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGDetailEntity;
import com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGEntity;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.service.TmTerminalService;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import com.google.common.base.Function;

/** 
 * 终端信息Vo转实体
 * @author 肖胜
 * @version v1.0
 */
@SuppressWarnings("deprecation")
public class TmTerminalVoToTmTerminalEntity implements Function<TmTerminalVo, TmTerminalEntity> {

	
	private TmTerminalService tmTerminalService;
	//编码生成
    private TbNumRuleProvider tbNumRuleProvider = null;
	private List <TmBusinessGroupVo> addBusinessGroupVoList;
	private List <TmBusinessGroupVo> deleteBusinessGroupVoList;
	
	private String [] channelCodes; //渠道编码
	private String [] orgIds; //组织id
	private String [] productCodes; //产品编码
	private String [] businessAreaCodes; //业务区域编码
	private String [] bgExtChar1s;
	private String [] bgExtChar2s;
	
	//构造注入tmTerminalService
	public TmTerminalVoToTmTerminalEntity(TmTerminalService tmTerminalService,
			List <TmBusinessGroupVo> addBusinessGroupVoList, List <TmBusinessGroupVo> deleteBusinessGroupVoList) {
		super();
		this.tmTerminalService = tmTerminalService;
		tbNumRuleProvider = (TbNumRuleProvider) ApplicationContextUtils.getContext().getBean("tbNumRuleProvider");
		this.addBusinessGroupVoList = addBusinessGroupVoList;
		this.deleteBusinessGroupVoList = deleteBusinessGroupVoList;
	}

	@Override
	public TmTerminalEntity apply(TmTerminalVo input) {
		TmTerminalEntity terminalEntity=null;
		if(StringUtil.isNotEmpty(input.getId())){
			terminalEntity=tmTerminalService.get(TmTerminalEntity.class, input.getId());
		}else{
			
			if(StringUtil.isEmpty(input.getTerminalName())){
				throw new BusinessException("终端名称为空" );
			}
			
			//防止重复数据 当名称与地址相同时覆盖
			List<TmTerminalEntity> list=tmTerminalService.
					findByHql("from TmTerminalEntity where terminalName=? ", input.getTerminalName());
			
			if(list!=null&&list.size()>0){
//				throw new BusinessException("终端信息名称" + input.getTerminalName()+"已存在");//2017年6月12 肖胜
			}
			terminalEntity=new TmTerminalEntity();
			if(StringUtil.isEmpty(input.getTerminalCode())){;//2018年3月22 肖胜 允许不用编码生成器
				//编码生成
				TbNumRuleProvider tbNumRuleProvider=
						(TbNumRuleProvider) ApplicationContextUtils.getContext().getBean("tbNumRuleProvider");
				String terminalCode=tbNumRuleProvider.getMaxNum(Globals.AuthTerminal);
				terminalEntity.setTerminalCode(terminalCode);
				input.setTerminalCode(terminalCode);
			}else{
				terminalEntity.setTerminalCode(input.getTerminalCode());
			}

//			terminalEntity.setEnableStatus(Globals.ENABLED);//2017年6月12 肖胜 由系统决定
		}
		
		//验证终端名称的有效性
		if(StringUtil.isNotEmpty(input.getTerminalName())){
			if(ValidateUtil.validateName(input.getTerminalName(),ValidateUtil.NAME)){
				throw new BusinessException("检测到终端名称包含非法字符:" + input.getTerminalName());
			}
		}
	
		//验证erpCode的有效性
		if(StringUtil.isNotEmpty(input.getErpCode())){
			if(!ValidateUtil.validateName(input.getErpCode(),ValidateUtil.ERPCODE)){
				throw new BusinessException("检测到终端ERP编码包含非法字符:" + input.getErpCode()+"，只能为数字和字母");
			}
		}
		//属性copy
		copyProperties(input,terminalEntity);
		
		//设置所属部门
		if(StringUtil.isNotEmpty(input.getOrgId())){
			TmOrgEntity tmOrg=
					tmTerminalService.get(TmOrgEntity.class, input.getOrgId());
			if(tmOrg == null) {
				throw new BusinessException("所属组织信息找不到:" + input.getOrgId());
			}
			terminalEntity.setTmOrg(tmOrg);
		}
		
		//导入时设置所属部门 动态配置表showField传递 组织code参数
		if(StringUtil.isNotEmpty(input.getOrgName())){
			TmOrgEntity tmOrg=
					tmTerminalService.findUniqueByProperty(TmOrgEntity.class,"orgCode", input.getOrgName());
			if(tmOrg == null) {
				throw new BusinessException("所属组织信息找不到:" + input.getOrgName());
			}
			terminalEntity.setTmOrg(tmOrg);
		}
		//装载终端与客户与职位对应关系
		terminalEntity.setTmRTermCustPosBGList(this.getTermCustPostList(terminalEntity, input));
		
		return terminalEntity;
	}

	/**
	 * 初始化业务组列表对象.
	 * 查询原来所有的业务对象，添加到要删除的列表中
	 * <p>
	 * @param termPostList
	 */
	private void initBusinessGroupInfo(List<TmRTermCustPosBGEntity> termPostList) {
		if(CollectionUtil.listNotEmptyNotSizeZero(termPostList)) {
			for(TmRTermCustPosBGEntity entity : termPostList) {
				List <TmRTermCustPosBGDetailEntity> detailEntityList = tmTerminalService
						.findByProperty(TmRTermCustPosBGDetailEntity.class, "businessGroup", entity.getBusinessGroup());
				for(TmRTermCustPosBGDetailEntity detailEntity : detailEntityList) {
					TmBusinessGroupVo businessGroupVo = new TmBusinessGroupVo();
					businessGroupVo.setBusinessGroup(detailEntity.getBusinessGroup());
					businessGroupVo.setDetailCode(detailEntity.getDetailCode());
					businessGroupVo.setDetailName(detailEntity.getDetailName());
					businessGroupVo.setTypeCode(detailEntity.getTypeCode());
					businessGroupVo.setTypeName(detailEntity.getTypeName());
					businessGroupVo.setPositionId(entity.getTmPosition() == null ? "" : entity.getTmPosition().getId());
					businessGroupVo.setOrgId(entity.getOrgId());
					TmCustomerEntity customerEntity = entity.getTmCustomer();
					if(customerEntity != null) {
						businessGroupVo.setCustomerId(customerEntity.getId());
						businessGroupVo.setCustomerCode(customerEntity.getCustomerCode());
						businessGroupVo.setCustomerName(customerEntity.getCustomerName());
					}
					deleteBusinessGroupVoList.add(businessGroupVo);
				}
			}
		}
	}
	

	/**
	 * 初始化业务Vo对象信息.
	 * <p>
	 * @param input
	 */
	private void initBusinessGroupVoInfo(TmTerminalVo input) {
		channelCodes = StringUtils.isNotBlank(input.getChannelCode()) ? input.getChannelCode().split(",", -1) : null;
		orgIds = StringUtils.isNotBlank(input.getBusinessGroupOrgId()) ? input.getBusinessGroupOrgId().split(",", -1) : null;
		productCodes = StringUtils.isNotBlank(input.getProductCode()) ? input.getProductCode().split(",", -1) : null;
		businessAreaCodes = StringUtils.isNotBlank(input.getBusinessAreaCode()) ? input.getBusinessAreaCode().split(",", -1) : null;
		bgExtChar1s = StringUtils.isNotBlank(input.getBgExtChar1s()) ? input.getBgExtChar1s().split(",") : null;
		bgExtChar2s = StringUtils.isNotBlank(input.getBgExtChar2s()) ? input.getBgExtChar2s().split(",") : null;
	}
	
	/**
	 * 拼装终端与客户与职位对应关系
	 * @param terminalEntity
	 * @param tmTerminalVo
	 * @return
	 */
	private List<TmRTermCustPosBGEntity> getTermCustPostList(TmTerminalEntity terminalEntity,TmTerminalVo tmTerminalVo){
		List<TmRTermCustPosBGEntity> custPostList=new ArrayList<TmRTermCustPosBGEntity>();
		
		initBusinessGroupInfo(terminalEntity.getTmRTermCustPosBGList());
		
		String relationIndex=tmTerminalVo.getRelationIndex();
		//上级客户信息
		String customerId=tmTerminalVo.getCustomerId();
		//对接人职位信息
		String positionId=tmTerminalVo.getPositionIds();
		//主键id
		String termCustId=tmTerminalVo.getTermCustId();
		
		String[] relationIndexs=null;
		String[] customerIds=null;
		String[] positionIds=null;
		//当为新增时主键id为空
		String[] ids=null;

		if(StringUtil.isEmpty(relationIndex)){
			if(StringUtil.isNotEmpty(positionId)&&
					StringUtil.isNotEmpty(customerId)){
				customerIds=customerId.split(",");
				positionIds=positionId.split(",");
				relationIndexs=positionIds.length>customerIds.length?positionIds:customerIds;
				ids=new String[relationIndexs.length];
			}else if(StringUtil.isNotEmpty(customerId)&&StringUtil.isEmpty(positionId)){
				customerIds=customerId.split(",");
				relationIndexs=customerIds;
				positionIds=new String[relationIndexs.length];
				ids=new String[relationIndexs.length];
			}else if(StringUtil.isEmpty(customerId)&&StringUtil.isNotEmpty(positionId)){
				positionIds=positionId.split(",");
				relationIndexs=positionIds;
				customerIds=new String[relationIndexs.length];
				ids=new String[relationIndexs.length];
			}
		
		}else{
			relationIndexs=relationIndex.split(",");
			ids=new String[relationIndexs.length];
			customerIds=new String[relationIndexs.length];
			positionIds=new String[relationIndexs.length];
			if(StringUtil.isNotEmpty(customerId)){
				customerIds=customerId.split(",");
			}
			if(StringUtil.isNotEmpty(positionId)){
				positionIds=positionId.split(",");
			}
			if(StringUtil.isNotEmpty(termCustId)){
				ids=termCustId.split(",");
			}
		}
		
		//初始化业务Vo对象信息
		initBusinessGroupVoInfo(tmTerminalVo);
		
		if(relationIndexs==null||relationIndexs.length==0){
			return custPostList;
		}
		
		for(int i=0;i<relationIndexs.length;i++){
			TmRTermCustPosBGEntity tmTermCustPosBgEntity=new TmRTermCustPosBGEntity();
			//设置终端
			tmTermCustPosBgEntity.setTmTerminal(terminalEntity);
			
			//设置职位
			String postId="";
			if(positionIds.length>i){
				postId=positionIds[i];
			}
			
			//设置客户
			String custId="";
			if(customerIds.length>i){
				custId=customerIds[i];
			}
			
			//设置主键id
			String id="";
			if(ids.length>i){
				id=ids[i];
			}
			if(StringUtil.isNotEmpty(id)){
				tmTermCustPosBgEntity=this.tmTerminalService.get(TmRTermCustPosBGEntity.class,id);
				TmPositionEntity newPostEntity = null;
				TmCustomerEntity customerEntity = null;
				if(StringUtils.isNotBlank(postId)) {
					newPostEntity = tmTerminalService.get(TmPositionEntity.class, postId);
					setPositionValue(newPostEntity.getId(), tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
				}
				tmTermCustPosBgEntity.setTmPosition(newPostEntity);
				if(StringUtils.isNotBlank(custId)) {
					customerEntity = tmTerminalService.get(TmCustomerEntity.class, custId);
				}
				tmTermCustPosBgEntity.setTmCustomer(customerEntity);
			
				if(orgIds != null&&orgIds.length>i) {
					tmTermCustPosBgEntity.setOrgId(orgIds[i]);
					setOrgValue(orgIds[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
				}
				if(bgExtChar1s != null&&bgExtChar1s.length>i) {
					tmTermCustPosBgEntity.setExtChar1(bgExtChar1s[i]);
				}
				if(bgExtChar2s != null&&bgExtChar2s.length>i) {
					tmTermCustPosBgEntity.setExtChar2(bgExtChar2s[i]);
				}
				if (StringUtil.isEmpty(tmTermCustPosBgEntity.getBusinessGroup())){
					tmTermCustPosBgEntity.setBusinessGroup(tbNumRuleProvider.getMaxNum("terminal_business_group"));
				}

				setChannelValue(channelCodes == null ? null : channelCodes[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
				setProductValue(productCodes == null ? null : productCodes[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
				setBusinessAreaValue(businessAreaCodes == null ? null : businessAreaCodes[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);

				custPostList.add(tmTermCustPosBgEntity);
			}else{
				//设置职位
				if(StringUtil.isNotEmpty(postId)){
					TmPositionEntity position=tmTerminalService.get(TmPositionEntity.class, postId);
					if( position==null){
						//导入时positionId 为职位code
						for(TmRTermCustPosBGEntity custPostEntity:custPostList){
							if(custPostEntity.getTmPosition().getPositionCode().equals(postId)){
								throw new BusinessException("对应职位信息["+postId+"]存在相同的多个编码" );
							}
						}
						position=tmTerminalService.findUniqueByProperty(TmPositionEntity.class, "positionCode", postId);
					}
					if(position==null){
						throw new BusinessException("职位信息["+positionId+"]不存在" );
					}else if(position.getEnableStatus()==1){
						throw new BusinessException("职位信息["+positionId+"]已停用" );
					}
					tmTermCustPosBgEntity.setTmPosition(position);
					setPositionValue(position.getId(), tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
				}
				
				//设置上级客户
				if(StringUtil.isNotEmpty(custId)){
					TmCustomerEntity customer=tmTerminalService.get(TmCustomerEntity.class, custId);
					if(customer==null){
						//导入时customerId 为客户code
						for(TmRTermCustPosBGEntity custPostEntity:custPostList){
							if(custPostEntity.getTmCustomer().getCustomerCode().equals(custId)
									&&StringUtil.isNotEmpty(positionId)
									&&positionId.equals(custPostEntity.getTmPosition().getPositionCode())){
								throw new BusinessException("对应上级客户信息["+custId+"]存在相同的多个编码" );
							}
						}
						customer=tmTerminalService.findUniqueByProperty(TmCustomerEntity.class, "customerCode", custId);
					}
					if(customer==null){
						throw new BusinessException("上级客户信息["+custId+"]不存在" );
					}else if(customer.getEnableStatus()==1){
						throw new BusinessException("上级客户信息["+custId+"]已停用" );
					}
					tmTermCustPosBgEntity.setTmCustomer(customer);
				}
				tmTermCustPosBgEntity.setBusinessGroup(tbNumRuleProvider.getMaxNum("terminal_business_group"));
				if(orgIds != null&&orgIds.length>i) {
					tmTermCustPosBgEntity.setOrgId(orgIds[i]);
					setOrgValue(orgIds[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
				}
				if(bgExtChar1s != null&&bgExtChar1s.length>i) {
					tmTermCustPosBgEntity.setExtChar1(bgExtChar1s[i]);
				}
				if(bgExtChar2s != null&&bgExtChar2s.length>i) {
					tmTermCustPosBgEntity.setExtChar2(bgExtChar2s[i]);
				}
				setChannelValue(channelCodes == null ? null : channelCodes[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
				setProductValue(productCodes == null ? null : productCodes[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
				setBusinessAreaValue(businessAreaCodes == null ? null : businessAreaCodes[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
				custPostList.add(tmTermCustPosBgEntity);
			}
		}
		return custPostList;
	}
	
	/**
	 * 设置业务区域信息.
	 * <p>
	 * @param businessAreaCode
	 * @param businessGroup
	 */
	private void setBusinessAreaValue(String businessAreaCode, String businessGroup, TmRTermCustPosBGEntity tmTermCustPosBgEntity) {
		if(StringUtils.isNotBlank(businessAreaCode)) {
			String detailCodeArr [] = businessAreaCode.split(";");
			
			for(String detail : detailCodeArr) {
				TmBusinessGroupVo vo = new TmBusinessGroupVo();
				vo.setBusinessGroup(businessGroup);
				vo.setDetailCode(detail);
				TmBusinessAreaEntity businessAreaEntity = tmTerminalService.findUniqueByProperty(TmBusinessAreaEntity.class, "businessAreaCode", detail);
				vo.setDetailName(businessAreaEntity.getBusinessAreaName());
				vo.setTypeCode("businessAreaCode");
				vo.setTypeName("业务区域");
				vo.setFlag("add");
				vo.setOrgId(tmTermCustPosBgEntity.getOrgId());
				vo.setPositionId(tmTermCustPosBgEntity.getTmPosition() != null ? tmTermCustPosBgEntity.getTmPosition().getId() : "");
				addBusinessGroupVoList.add(vo);
			}
		}
	}
	
	/**
	 * 设置组织信息.
	 * <p>
	 * @param orgId
	 * @param businessGroup
	 * @param tmTermCustPosBgEntity
	 */
	private void setOrgValue(String orgId, String businessGroup, TmRTermCustPosBGEntity tmTermCustPosBgEntity) {
		if(StringUtils.isNotBlank(orgId)) {
			TmBusinessGroupVo vo = new TmBusinessGroupVo();
			TmOrgEntity orgEntity = tmTerminalService.get(TmOrgEntity.class, tmTermCustPosBgEntity.getOrgId());
			vo.setBusinessGroup(businessGroup);
			vo.setDetailCode("");
			vo.setDetailName(orgEntity.getOrgName());
			vo.setTypeCode("orgCode");
			vo.setTypeName("所属分部");
			vo.setFlag("add");
			vo.setOrgId(tmTermCustPosBgEntity.getOrgId());
			vo.setPositionId(tmTermCustPosBgEntity.getTmPosition() != null ? tmTermCustPosBgEntity.getTmPosition().getId() : "");
			addBusinessGroupVoList.add(vo);
		}
	}
	
	/**
	 * 设置职位信息.
	 * <p>
	 * @param positionId
	 * @param businessGroup
	 * @param tmTermCustPosBgEntity
	 */
	private void setPositionValue(String positionId, String businessGroup, TmRTermCustPosBGEntity tmTermCustPosBgEntity) {
		if(StringUtils.isNotBlank(positionId)) {
			TmBusinessGroupVo vo = new TmBusinessGroupVo();
			vo.setBusinessGroup(businessGroup);
			vo.setDetailCode("");
			vo.setDetailName(tmTermCustPosBgEntity.getTmPosition() != null ?
					tmTermCustPosBgEntity.getTmPosition().getPositionName() : "");
			vo.setTypeCode("positionCode");
			vo.setTypeName("对接人职位");
			vo.setFlag("add");
			vo.setOrgId(tmTermCustPosBgEntity.getOrgId());
			vo.setPositionId(tmTermCustPosBgEntity.getTmPosition() != null ?
					tmTermCustPosBgEntity.getTmPosition().getId() : "");
			addBusinessGroupVoList.add(vo);
		}
	}
	
	/**
	 * 设置渠道信息.
	 * <p>
	 * @param channelCode
	 * @param businessGroup
	 */
	private void setChannelValue(String channelCode, String businessGroup, TmRTermCustPosBGEntity tmTermCustPosBgEntity) {
		if(StringUtils.isNotBlank(channelCode)) {
			String detailCodeArr [] = channelCode.split(";");
			
			for(String detail : detailCodeArr) {
				TmBusinessGroupVo vo = new TmBusinessGroupVo();
				vo.setBusinessGroup(businessGroup);
				vo.setDetailCode(detail);
				vo.setDetailName(DictUtil.getDictDataValueByCode("channel", detail));
				vo.setTypeCode("channelCode");
				vo.setTypeName("渠道");
				vo.setFlag("add");
				vo.setOrgId(tmTermCustPosBgEntity.getOrgId());
				vo.setPositionId(tmTermCustPosBgEntity.getTmPosition() != null ? tmTermCustPosBgEntity.getTmPosition().getId() : "");
				addBusinessGroupVoList.add(vo);
			}
		}
	}
	
	/**
	 * 设置产品信息.
	 * <p>
	 * @param productCode
	 * @param businessGroup
	 */
	private void setProductValue(String productCode, String businessGroup, TmRTermCustPosBGEntity tmTermCustPosBgEntity) {
		if(StringUtils.isNotBlank(productCode)) {
			String detailCodeArr [] = productCode.split(";");
			
			for(String detail : detailCodeArr) {
				TmBusinessGroupVo vo = new TmBusinessGroupVo();
				vo.setBusinessGroup(businessGroup);
				vo.setDetailCode(detail);
				TmProductEntity productEntity = tmTerminalService.findUniqueByProperty(TmProductEntity.class, "productCode", detail);
				vo.setDetailName(productEntity.getProductName());
				vo.setTypeCode("productCode");
				vo.setTypeName("产品");
				vo.setFlag("add");
				vo.setOrgId(tmTermCustPosBgEntity.getOrgId());
				vo.setPositionId(tmTermCustPosBgEntity.getTmPosition() != null ? tmTermCustPosBgEntity.getTmPosition().getId() : "");
				addBusinessGroupVoList.add(vo);
			}
		}
	}
	
	public void copyProperties(TmTerminalVo vo, TmTerminalEntity entity) {
		entity.setLinkman(vo.getLinkman());
		entity.setLinkmanPhone(vo.getLinkmanPhone());
		entity.setProvince(vo.getProvince());
		entity.setTerminalCode(vo.getTerminalCode());
		entity.setTerminalName(vo.getTerminalName());
		entity.setTerminalType(vo.getTerminalType());
		entity.setAddress(vo.getAddress());
		entity.setArea(vo.getArea());
		entity.setChannelType(vo.getChannelType());
		entity.setCity(vo.getCity());
		entity.setCooperative(vo.getCooperative());
		entity.setEnableStatus(vo.getEnableStatus());
		entity.setErpCode(vo.getErpCode());
		if(StringUtil.isNotEmpty(vo.getOrgId())){
			TmOrgEntity orgEntity=tmTerminalService.get(TmOrgEntity.class,vo.getOrgId());
			entity.setTmOrg(orgEntity);
		}
		entity.setExtChar1(vo.getExtChar1());
		entity.setExtChar2(vo.getExtChar2());
		entity.setExtChar3(vo.getExtChar3());
		entity.setExtChar4(vo.getExtChar4());
		entity.setExtChar5(vo.getExtChar5());
		entity.setExtChar6(vo.getExtChar6());
		entity.setExtChar7(vo.getExtChar7());
		entity.setExtChar8(vo.getExtChar8());
		entity.setExtChar9(vo.getExtChar9());
		entity.setExtChar10(vo.getExtChar10());
		entity.setExtChar11(vo.getExtChar11());
		entity.setExtChar12(vo.getExtChar12());
		entity.setExtChar13(vo.getExtChar13());
		entity.setExtChar14(vo.getExtChar14());
		entity.setExtChar15(vo.getExtChar15());
		entity.setExtChar16(vo.getExtChar16());
		entity.setExtChar17(vo.getExtChar17());
		entity.setExtChar18(vo.getExtChar18());
		entity.setExtChar19(vo.getExtChar19());
		entity.setExtChar20(vo.getExtChar20());
		entity.setExtChar21(vo.getExtChar21());
		entity.setExtChar22(vo.getExtChar22());
		entity.setExtChar23(vo.getExtChar23());
		entity.setExtChar24(vo.getExtChar24());
		entity.setExtChar25(vo.getExtChar25());
		entity.setExtChar26(vo.getExtChar26());
		entity.setExtChar27(vo.getExtChar27());
		entity.setExtChar28(vo.getExtChar28());
		entity.setExtChar29(vo.getExtChar29());
		entity.setExtChar30(vo.getExtChar30());
		entity.setExtNumber1(vo.getExtNumber1());
		entity.setExtNumber2(vo.getExtNumber2());
		entity.setExtNumber3(vo.getExtNumber3());
		entity.setExtNumber4(vo.getExtNumber4());
		entity.setExtNumber5(vo.getExtNumber5());

	}
}
