package com.biz.eisp.mdm.timeTask.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.timeTask.entity.TimeTaskEntity;
import com.biz.eisp.mdm.timeTask.service.DynamicTask;
import com.biz.eisp.mdm.timeTask.service.TimeTaskService;

/**
 * 定时任务动态管理controller.
 * @author grover
 * @version v1.0
 */
@Scope("prototype")
@Controller
@RequestMapping("/timeTaskController")
public class TimeTaskController extends BaseController {
	/**
	 * 注入定时任务service.
	 */
    @Autowired
    private TimeTaskService timeTaskService;
    /**
     * 注入quartz动态管理.
     */
    @Autowired
    private DynamicTask dynamicTask;

    /**
     * 定时任务管理列表 页面跳转
     * @author grover
     * @param request
     * 			请求对象
     * @return
     * 			定时任务主界面
     */
    @RequestMapping(value = "timeTask",method = {RequestMethod.GET,RequestMethod.POST})
    public ModelAndView timeTask(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/timeTask/timeTaskMain");
    }

    /**
     * 获取定时任务.
     * @author grover
     * @param timeTask
     * 			定时任务实体
     * @param request
     * 			请求对象
     * @param response
     * 			响应对象
     */
    @RequestMapping(value = "datagrid", method = {RequestMethod.GET, RequestMethod.POST})
    public void datagrid(TimeTaskEntity timeTask, HttpServletRequest request,HttpServletResponse response) {
    	Page page = new EuPage(request);
        List<TimeTaskEntity> tasks = timeTaskService.findTimeTaskList(timeTask, page);
    	this.datagridReturn(response, tasks, page);
    }

    /**
     * 删除定时任务管理
     * 
     * @return
     */
    @RequestMapping(value = "del", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson del(TimeTaskEntity timeTask, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        timeTask = timeTaskService.get(TimeTaskEntity.class, timeTask.getId());
        message = "定时任务管理删除成功";
        timeTaskService.delete(timeTask);
        j.setMsg(message);
        return j;
    }

    /**
     * 添加定时任务管理
     * 
     * @param ids
     * @return
     */
    @RequestMapping(value = "save", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson save(TimeTaskEntity timeTask, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
			j = timeTaskService.saveTask(timeTask);
		} catch (Exception e) {
			j.setSuccess(false);
			e.printStackTrace();
		}
        return j;
    }

    /**
     * 定时任务管理列表页面跳转
     * @author grover
     * @param timeTask  
     * 			定时任务实体
     * @param 
     * 			req 请求对象
     * @return
     */
    @RequestMapping(value = "addorupdate", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView addorupdate(TimeTaskEntity timeTask, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(timeTask.getId())) {
            timeTask = timeTaskService.get(TimeTaskEntity.class, timeTask.getId());
            req.setAttribute("timeTaskPage", timeTask);
        }
        return new ModelAndView("com/biz/eisp/mdm/timeTask/timeTaskForm");
    }

    /**
     * 修改触发cron时间.
     * @author grover
     * @param timeTask 
     * 			定时任务实体
     * @param request
     * 			请求对象
     * @return
     */
    @RequestMapping(value = "updateTime", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson updateTime(TimeTaskEntity timeTask, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        timeTask = timeTaskService.get(TimeTaskEntity.class, timeTask.getId());
        boolean isUpdate = dynamicTask.updateCronExpression(timeTask.getTaskId(), timeTask.getCronExpression());
        if (isUpdate) {
            timeTask.setIsEffect("1");
            timeTask.setIsStart("1");
            timeTaskService.updateEntity(timeTask);
        }
        j.setMsg(isUpdate ? "定时任务管理更新成功" : "定时任务管理更新失败");
        return j;
    }

    /**
     * 启动活动停止任务.
     * @author grover
     * @param timeTask
     * 			 定时任务实体
     * @param request 
     * 			请求对象
     * @return
     */
    @RequestMapping(value = "startOrStopTask", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson startOrStopTask(TimeTaskEntity timeTask, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        boolean isStart = timeTask.getIsStart().equals("1");
        timeTask = timeTaskService.get(TimeTaskEntity.class, timeTask.getId());
        boolean isSuccess = dynamicTask.startOrStop(timeTask.getTaskId(), isStart);
        if (isSuccess) {
            timeTask.setIsStart(isStart ? "1" : "0");
            timeTaskService.updateEntity(timeTask);
        }
        j.setMsg(isSuccess ? "定时任务管理更新成功" : "定时任务管理更新失败");
        return j;
    }

}
