package com.biz.eisp.mdm.timeTask.dao;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.mdm.timeTask.entity.TimeTaskEntity;

/**
 * 定时任务dao.
 * @author grover
 * @version v1.0
 */
@InterfaceDao
public interface TimeTaskDao {
	/**
	 * 查询定时任务.
	 * @author grover
	 * @param timeTaskEntity 定时任务
	 * @param page 页面信息
	 * @return
	 */
	@Arguments({"timeTaskEntity","page"})
	@ResultType(TimeTaskEntity.class)
	public List<TimeTaskEntity> findTimeTaskList(TimeTaskEntity timeTaskEntity, Page page);
}
