package com.biz.eisp.mdm.timeTask.service;


import java.text.ParseException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;

import com.biz.eisp.mdm.timeTask.entity.TimeTaskEntity;

/**
 * 在原有功能的基础上面增加数据库的读取.
 * @author grover
 * @version v1.0
 */
public class DataBaseCronTriggerBean extends CronTriggerFactoryBean {

    @Autowired
    private TimeTaskService timeTaskService;

    /**
     * spring加载完成之后,读取数据库更新spring-quartz文件。
     */
	@Override
	public void afterPropertiesSet() throws ParseException {
		super.afterPropertiesSet();
        TimeTaskEntity task = timeTaskService.findUniqueByProperty(TimeTaskEntity.class, "taskId", this.getObject().getKey().getName());
        if (task != null && task.getIsEffect().equals("1")
                        && !task.getCronExpression().equals(this.getObject().getCronExpression())) {
            this.setCronExpression(task.getCronExpression());
            DynamicTask.updateSpringMvcTaskXML(this.getObject(), task.getCronExpression());
        }
	}
}
